/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagemonitor;

import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.messagemonitor.DeliverToAdapterRequestDto;
import de.ponton.xmlpipe.rest.messagemonitor.MessageFilterDto;
import de.ponton.xmlpipe.rest.messagemonitor.MessageMonitorService;
import de.ponton.xmlpipe.rest.messagemonitor.MessageQueueService;
import de.ponton.xmlpipe.rest.messagemonitor.MessageResendException;
import de.ponton.xmlpipe.rest.messagemonitor.MessageResendService;
import de.ponton.xmlpipe.rest.messagemonitor.MessageSearchResultDto;
import de.ponton.xmlpipe.rest.messagemonitor.validation.ValidationGroupResend;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import de.pontonconsulting.xmlpipe.messenger.InboundQueueException;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.service.AdapterService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/messagemonitor"})
@Validated
public class MessageMonitorController {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + MessageMonitorController.class.getName()));
    private static final Logger AUDIT = LogManager.getLogger((String)("Audit." + MessageMonitorController.class.getName()));
    private static final String DOCUMENTATION_TAG_MESSAGE_MONITOR = "MessageMonitor";
    private final MessageMonitorService messageMonitorService;
    private final MessageResendService messageResendService;
    private final MessageQueueService messageQueueService;
    private final ExceptionDtoFactory exceptionDtoFactory;
    private final AdapterService adapterService;

    public MessageMonitorController(MessageMonitorService messageMonitorService, MessageResendService messageResendService, MessageQueueService messageQueueService, ExceptionDtoFactory exceptionDtoFactory, AdapterService adapterService) {
        this.messageMonitorService = messageMonitorService;
        this.adapterService = adapterService;
        this.messageResendService = messageResendService;
        this.messageQueueService = messageQueueService;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @GetMapping(value={"/resendFailedMessage/{id}"})
    @Operation(summary="resends a failed outbound message", description="permission:MESSAGE_MONITOR_RESEND_FAILED_MESSAGE_GET<br><br>A new transmission attempt is started for a previously failed outbound message.", tags={"MessageMonitor"})
    @Secured(value={"MESSAGE_MONITOR_RESEND_FAILED_MESSAGE_GET"})
    @Validated(value={ValidationGroup.Update.class})
    public ResponseEntity<Void> resendFailedMessage(@PathVariable Long id, Principal principal) throws IOException, ClassNotFoundException, DbException, MessageResendException {
        AUDIT.info("{} triggered resend of failed message {}", (Object)principal.getName(), (Object)id);
        this.messageResendService.resendFailedMessage(id);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/resendFailedMessages"})
    @Secured(value={"MESSAGE_MONITOR_RESEND_FAILED_MESSAGE_POST"})
    @Operation(summary="resends all failed messages of one direction (inbound or outbound) which matches the given filter criteria", description="permission:MESSAGE_MONITOR_RESEND_FAILED_MESSAGE_POST<br><br>A new transmission attempt is started for all previously failed messages of one direction (inbound or outbound) which matches the given filter criteria.", tags={"MessageMonitor"})
    @Validated(value={ValidationGroupResend.class})
    public ResponseEntity<Void> resendFailedMessages(@RequestBody @Valid MessageFilterDto filter, Principal principal) {
        AUDIT.info("{} triggered resending of failed messages with filter ({})", (Object)principal.getName(), (Object)filter);
        this.messageResendService.resendFailedMessages(filter, principal);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/resendSuccessfulMessage/{id}"})
    @Secured(value={"MESSAGE_MONITOR_RESEND_SUCCESSFUL_MESSAGE_GET"})
    @Operation(summary="resend a successful outbound message", description="permission:MESSAGE_MONITOR_RESEND_SUCCESSFUL_MESSAGE_GET<br><br>Creates s copy of a successful message and starts a transmission. A new message-id will be automatically generated.", tags={"MessageMonitor"})
    @Validated(value={ValidationGroup.Update.class})
    public ResponseEntity<Void> resendSuccessfulMessage(@PathVariable Long id, Principal principal) throws IOException, ClassNotFoundException, DbException, MessageResendException {
        AUDIT.info("{} triggered resend of successful message {}", (Object)principal.getName(), (Object)id);
        this.messageResendService.resendSuccessfulMessage(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/toggleMessageStatus/{id}"})
    @Secured(value={"MESSAGE_MONITOR_TOGGLE_MESSAGE_STATUS_GET"})
    @Operation(summary="toggle message status between FAILED and RESOLVED", description="permission:MESSAGE_MONITOR_TOGGLE_MESSAGE_STATUS_GET<br><br>Toggle message status between FAILED and RESOLVED", tags={"MessageMonitor"})
    public ResponseEntity<Void> toggleMessageStatus(@PathVariable Long id, Principal principal) throws DbException {
        AUDIT.info("{} triggered change status of FAILED/RESOLVED message {}", (Object)principal.getName(), (Object)id);
        if (this.messageResendService.toggleMessageStatus(id)) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/deleteMessageFromQueue/{id}"})
    @Secured(value={"MESSAGE_MONITOR_DELETE_MESSAGE_FROM_QUEUE_DELETE"})
    @Operation(summary="delete a message from the queue", description="permission:MESSAGE_MONITOR_DELETE_MESSAGE_FROM_QUEUE_DELETE<br><br>Delete an existing message from the queue", tags={"MessageMonitor"})
    @Validated(value={ValidationGroup.Update.class})
    public ResponseEntity<Void> deleteMessageFormQueue(@PathVariable Long id, Principal principal) {
        AUDIT.info("{} triggered deletion of message from queue {}", (Object)principal.getName(), (Object)id);
        boolean deleteFromQueueResult = this.messageQueueService.deleteMessageFromQueue(id);
        if (deleteFromQueueResult) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/findmessages"})
    @Operation(summary="Search for messages", description="permission:MESSAGE_MONITOR_FIND_MESSAGES_POST<br><br>Get a message search result containing the total count of found messages and the limited list of filtered messages", tags={"MessageMonitor"})
    @Secured(value={"MESSAGE_MONITOR_FIND_MESSAGES_POST"})
    public ResponseEntity<MessageSearchResultDto> findMessages(@RequestBody @Valid MessageFilterDto filter, Principal principal) {
        MessageSearchResultDto result = this.messageMonitorService.findMessages(filter, principal);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/delivertoaddapter"})
    @Secured(value={"MESSAGE_DELIVER_TO_ADAPTER_POST"})
    @Operation(summary="Deliver message to the given adapter", description="permission:MESSAGE_DELIVER_TO_ADAPTER_POST<br><br>Send the message with the given id to the adapter with the given id. ", tags={"MessageMonitor"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deliverToAdapter(@RequestBody @Valid DeliverToAdapterRequestDto requestDto, Principal principal) throws InboundQueueException, IOException, ClassNotFoundException, DbException {
        this.adapterService.changeAdapter(principal.getName(), requestDto.getMessageId(), requestDto.getAdapterId());
        return ResponseEntity.noContent().build();
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleBadRequest(IllegalStateException e) {
        LOG.error("Could not message monitor request. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MessageResendException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleProcessingError(MessageResendException e) {
        LOG.error("Could not resend message. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={FileNotFoundException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ExceptionDto> handleFileNotFoundException(FileNotFoundException e) {
        LOG.error("Could not resend message due to FileNotFoundException {}", (Object)e.getMessage());
        ExceptionDto exceptionDto = this.exceptionDtoFactory.create(e);
        exceptionDto.setErrorMessage("Could not resend message. Message has to be resend from backend.");
        return new ResponseEntity((Object)exceptionDto, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

