/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagemonitor;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.messagemonitor.MessageArchiveStatus;
import de.ponton.xmlpipe.rest.messagemonitor.MessageCategory;
import de.ponton.xmlpipe.rest.messagemonitor.MessageStatus;
import de.ponton.xmlpipe.rest.messagemonitor.validation.ResendMessagesFilterConstraint;
import de.ponton.xmlpipe.rest.messagemonitor.validation.ValidationGroupResend;
import de.ponton.xmlpipe.rest.validation.AdapterAccessConstraint;
import de.ponton.xmlpipe.rest.validation.PartnerAccessConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Describes filter for message searching")
@ResendMessagesFilterConstraint(groups={ValidationGroupResend.class})
public class MessageFilterDto {
    @Schema(description="Used to get messages, which are not older than the timestamp.")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @NotNull(groups={ValidationGroupResend.class})
    private Date fromDate;
    @Schema(description="Used to get messages, which are not younger than the timestamp.")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date toDate;
    @Schema(description="The list of technical IDs of potential local partners")
    private List<@PartnerAccessConstraint(groups={ValidationGroupResend.class}) String> localPartnerIds;
    @Schema(description="The list of technical IDs of potential remote partners")
    private List<String> remotePartnerIds;
    @Schema(description="The list of message states to filter inbound messages. Use empty list to filter out all inbound messages.")
    private List<MessageStatus> inboundStates;
    @Schema(description="The list of message states to filter outbound messages. Use empty list to filter out all outbound messages.")
    private List<MessageStatus> outboundStates;
    @Schema(description="The list of message categories to filter messages with one of the message category")
    private List<MessageCategory> messageCategories;
    @Schema(description="The list of adapter IDs")
    private List<@AdapterAccessConstraint(groups={ValidationGroupResend.class}) String> adapterIds;
    @Schema(description="The exact message ID of the message")
    @TrimmedField
    private String messageId;
    @Schema(description="The exact conversation ID of the message")
    @TrimmedField
    private String conversationId;
    @Schema(description="The exact log info of the message")
    @TrimmedField
    private String logInfo;
    @Schema(description="The list of schema set names to filter messages belongs to one of the schema set")
    private List<String> schemaSets;
    @Schema(description="The list of message type names to filter messages having one of the message type name")
    private List<String> messageTypes;
    @Schema(description="The list of message archive states to filter messages.")
    private List<MessageArchiveStatus> archiveStatus;

    public Date getFromDate() {
        return this.fromDate;
    }

    public MessageFilterDto setFromDate(Date fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public MessageFilterDto setToDate(Date toDate) {
        this.toDate = toDate;
        return this;
    }

    public List<String> getLocalPartnerIds() {
        return this.localPartnerIds;
    }

    public MessageFilterDto setLocalPartnerIds(List<String> localPartnerIds) {
        this.localPartnerIds = localPartnerIds;
        return this;
    }

    public List<String> getRemotePartnerIds() {
        return this.remotePartnerIds;
    }

    public MessageFilterDto setRemotePartnerIds(List<String> remotePartnerIds) {
        this.remotePartnerIds = remotePartnerIds;
        return this;
    }

    public List<MessageStatus> getInboundStates() {
        return this.inboundStates;
    }

    public MessageFilterDto setInboundStates(List<MessageStatus> inboundStates) {
        this.inboundStates = inboundStates;
        return this;
    }

    public List<MessageStatus> getOutboundStates() {
        return this.outboundStates;
    }

    public MessageFilterDto setOutboundStates(List<MessageStatus> outboundStates) {
        this.outboundStates = outboundStates;
        return this;
    }

    public List<MessageCategory> getMessageCategories() {
        return this.messageCategories;
    }

    public MessageFilterDto setMessageCategories(List<MessageCategory> messageCategories) {
        this.messageCategories = messageCategories;
        return this;
    }

    public List<String> getAdapterIds() {
        return this.adapterIds;
    }

    public MessageFilterDto setAdapterIds(List<String> adapterIds) {
        this.adapterIds = adapterIds;
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public MessageFilterDto setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public MessageFilterDto setConversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    public String getLogInfo() {
        return this.logInfo;
    }

    public MessageFilterDto setLogInfo(String logInfo) {
        this.logInfo = logInfo;
        return this;
    }

    public List<String> getSchemaSets() {
        return this.schemaSets;
    }

    public MessageFilterDto setSchemaSets(List<String> schemaSets) {
        this.schemaSets = schemaSets;
        return this;
    }

    public List<String> getMessageTypes() {
        return this.messageTypes;
    }

    public MessageFilterDto setMessageTypes(List<String> messageTypes) {
        this.messageTypes = messageTypes;
        return this;
    }

    public List<MessageArchiveStatus> getArchiveStatus() {
        return this.archiveStatus;
    }

    public MessageFilterDto setArchiveStatus(List<MessageArchiveStatus> archiveStatus) {
        this.archiveStatus = archiveStatus;
        return this;
    }
}

