/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.message;

import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import jakarta.persistence.EntityManager;
import org.springframework.stereotype.Component;

@Component
public class MessageLogInfoService {
    private final HibernateSessionFactory hibernateSessionFactory;

    public MessageLogInfoService(HibernateSessionFactory hibernateSessionFactory) {
        this.hibernateSessionFactory = hibernateSessionFactory;
    }

    public void updateLogInfo(long messageId, String logInfo) {
        try (EntityManager entityManager = this.hibernateSessionFactory.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Message dbMessage = (Message)entityManager.find(Message.class, (Object)messageId);
            if (dbMessage == null) {
                throw new ResourceNotFoundException("Could not get message logs for unknown message with id " + messageId);
            }
            dbMessage.setLoginfo(logInfo);
            entityManager.merge((Object)dbMessage);
            entityManager.getTransaction().commit();
        }
    }
}

