/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener;

import de.ponton.securelistener.administration.certs.ServerCertificate;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.server.certificate.CreateServerCertificateRequestDto;
import de.ponton.xmlpipe.rest.server.certificate.ServerCertificateRequestDto;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.admintool.messenger.ssl.certificate.KeyPairAlgorithm;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.SSLKeystoreBean;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.CertificateRequest;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.SecurityFileReader;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.operator.OperatorCreationException;
import org.springframework.stereotype.Component;

@Component
public class ListenerServerCertificateService {
    public static final String SSL_LISTENENER_CERT_ALIAS = "listener";
    private static final String IPV4_PATTERN = "^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.(?!$)|$)){4}$";
    private static final String IPV6_PATTERN = "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))";
    private static final Pattern ipv6_pattern = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");
    private static final Pattern ipv4_pattern = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.(?!$)|$)){4}$");
    private static final Logger log = LogManager.getLogger((String)("Messenger." + ListenerServerCertificateService.class.getName()));
    private final ListenerConfig listenerConfig;
    private final SecurityFileReader securityFileReader;
    private final CertificateUtility certificateUtility;
    private final SSLKeystoreBean keystoreBean;
    private final CertificateReader certificate;

    public ListenerServerCertificateService(ListenerConfig listenerConfig, SecurityFileReader securityFileReader, CertificateUtility certificateUtility, SSLKeystoreBean sslKeystoreBean, CertificateReader certificate) {
        this.listenerConfig = listenerConfig;
        this.securityFileReader = securityFileReader;
        this.certificateUtility = certificateUtility;
        this.keystoreBean = sslKeystoreBean;
        this.certificate = certificate;
    }

    public String installKeystore(String keystore, String password) throws Exception {
        SignCertInfo signCertInfo = this.securityFileReader.getSignCertInfo(new ByteArrayInputStream(Base64.getDecoder().decode(keystore)), password);
        return this.installCertificate(signCertInfo.getCertificateChain(), signCertInfo.getPrivateKey(), password);
    }

    public String installCertificate(String certificate, String password) throws ListenerConfigException, InstallCertException, CertificateException, NoSuchProviderException {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.installCertificate(this.certificateUtility.getX509Certificate(certificate), password, byteArrayOutputStream);
            SignCertInfo signCertInfo = this.securityFileReader.getSignCertInfo(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), password);
            string = this.installCertificate(signCertInfo.getCertificateChain(), signCertInfo.getPrivateKey(), password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Unable to import certificate.", (Throwable)e);
                throw new ListenerConfigException(0, e.getMessage());
            }
        }
        byteArrayOutputStream.close();
        return string;
    }

    private void installCertificate(X509Certificate certificate, String password, ByteArrayOutputStream out) throws Exception {
        this.verifyPublicKey(certificate);
        this.certificateUtility.storePkcs12PrivateKey(this.buildAliasForCertificate(certificate), password, this.getTempPrivateKey(password), this.keystoreBean.getSslCertificateChain(certificate), out);
        this.keystoreBean.deleteTempPrivateKey(SSL_LISTENENER_CERT_ALIAS);
    }

    public String buildAliasForCertificate(X509Certificate certificate) throws CertificateEncodingException {
        return UUID.nameUUIDFromBytes(certificate.getEncoded()).toString().toLowerCase();
    }

    private PrivateKey getTempPrivateKey(String password) throws GeneralSecurityException, InstallCertException {
        PrivateKey tempPrivateKey = null;
        try {
            tempPrivateKey = this.keystoreBean.getTempPrivateKey(SSL_LISTENENER_CERT_ALIAS, password.toCharArray());
        }
        catch (GeneralSecurityException e) {
            throw new InstallCertException(32002, "Wrong password. You must supply the password for your private key.");
        }
        if (tempPrivateKey == null) {
            throw new InstallCertException(32003, "No matching private key found for local ID. A certificate must be requested first.");
        }
        return tempPrivateKey;
    }

    private void verifyPublicKey(X509Certificate certificate) throws GeneralSecurityException, InstallCertException {
        Certificate[] tempCert = this.keystoreBean.getSslTempCertificateChain(SSL_LISTENENER_CERT_ALIAS);
        if (!certificate.getPublicKey().equals(tempCert[0].getPublicKey())) {
            throw new InstallCertException(32004, "Public key generated when requesting the certificate does not match with signed public key from certificate.");
        }
    }

    private boolean certificateAlreadyExists(String certificateAlias) {
        try {
            if (this.listenerConfig.getServerCertificate(certificateAlias) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void deleteCertificate(String id) throws ListenerConfigException {
        if (!this.certificateAlreadyExists(id)) {
            throw new ResourceNotFoundException(String.format("Listener certificate does not exist. [id=%s]", id));
        }
        this.listenerConfig.deleteServerCertificate(id);
        this.listenerConfig.restartServices();
    }

    public byte[] exportKeystore(String id, String password) throws ListenerConfigException {
        return this.listenerConfig.exportServerCertificate(id, password);
    }

    private void storeKeyPair(String password, KeyPair keyPair, CreateServerCertificateRequestDto form) throws GeneralSecurityException, OperatorCreationException {
        X500NameBuilder nameBuilder = new X500NameBuilder(X500Name.getDefaultStyle());
        nameBuilder.addRDN(BCStyle.CN, form.getCn());
        if (StringUtils.isNotBlank((CharSequence)form.getOu())) {
            nameBuilder.addRDN(BCStyle.OU, form.getOu());
        }
        nameBuilder.addRDN(BCStyle.O, form.getO());
        nameBuilder.addRDN(BCStyle.C, form.getC());
        X500Name issuer = nameBuilder.build();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate selfCert = this.certificate.createCertificate(issuer, publicKey, issuer, privateKey);
        this.keystoreBean.addTempPrivateKey(SSL_LISTENENER_CERT_ALIAS, privateKey, password.toCharArray(), selfCert);
    }

    public ServerCertificateRequestDto createListenerCertRequest(CreateServerCertificateRequestDto form) throws GeneralSecurityException, InstallCertException, OperatorCreationException, IOException {
        KeyPairAlgorithm keyPairAlgorithm = form.getAlgorithm();
        KeyPair keyPair = this.certificate.generateKeyPair(keyPairAlgorithm.getAlgorithm(), keyPairAlgorithm.getLength());
        CertificateRequest certRequest = this.createCertificateRequest(keyPair, form);
        this.storeKeyPair(form.getPassword(), keyPair, form);
        return new ServerCertificateRequestDto().setCertificateRequest(certRequest.getPEM()).setSubject(certRequest.getSubject()).setKeyPairAlgo(keyPairAlgorithm);
    }

    private CertificateRequest createCertificateRequest(KeyPair keyPair, CreateServerCertificateRequestDto form) throws InstallCertException {
        try {
            X500NameBuilder nameBuilder = new X500NameBuilder(X500Name.getDefaultStyle());
            nameBuilder.addRDN(BCStyle.CN, form.getCn());
            if (StringUtils.isNotBlank((CharSequence)form.getOu())) {
                nameBuilder.addRDN(BCStyle.OU, form.getOu());
            }
            nameBuilder.addRDN(BCStyle.O, form.getO());
            if (StringUtils.isNotBlank((CharSequence)form.getL())) {
                nameBuilder.addRDN(BCStyle.L, form.getL());
            }
            if (StringUtils.isNotBlank((CharSequence)form.getSt())) {
                nameBuilder.addRDN(BCStyle.ST, form.getSt());
            }
            nameBuilder.addRDN(BCStyle.C, form.getC());
            nameBuilder.addRDN(BCStyle.EmailAddress, form.getEmail());
            if (StringUtils.isNotBlank((CharSequence)form.getPhone())) {
                nameBuilder.addRDN(BCStyle.TELEPHONE_NUMBER, form.getPhone());
            }
            X500Name subject = nameBuilder.build();
            HashMap<String, String> extensions = new HashMap();
            if (form.isExtensions()) {
                extensions = this.buildExtensions();
            }
            return new CertificateRequest(this.certificateUtility.generateTempAlias(), subject, extensions, keyPair.getPublic(), keyPair.getPrivate(), new GeneralNames(form.getSan().stream().map(this::createGeneralName).toList().toArray(new GeneralName[0])));
        }
        catch (GeneralSecurityException | OperatorCreationException e) {
            InstallCertException ce = new InstallCertException(32013, new String[]{e.getMessage()}, e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    private GeneralName createGeneralName(String value) {
        return ipv6_pattern.matcher(value).matches() || ipv4_pattern.matcher(value).matches() ? new GeneralName(7, value) : new GeneralName(2, value);
    }

    private Map<String, String> buildExtensions() {
        HashMap<String, String> extensions = new HashMap<String, String>(3);
        extensions.put("1.3.6.1.4.1.14136.3.1", Constants.getXP_VERSION());
        extensions.put("1.3.6.1.4.1.14136.3.3", "ssl");
        return extensions;
    }

    private String installCertificate(Certificate[] certificates, PrivateKey privateKey, String password) throws ListenerConfigException, CertificateEncodingException {
        for (int i = certificates.length - 1; i > 0; --i) {
            this.listenerConfig.installServerCACertificate(new de.ponton.securelistener.administration.certs.Certificate(certificates[i].getEncoded()));
        }
        Certificate cert = certificates[0];
        String certificateId = this.listenerConfig.installServerCertificate(new ServerCertificate(org.bouncycastle.util.encoders.Base64.encode((byte[])cert.getEncoded()), org.bouncycastle.util.encoders.Base64.encode((byte[])privateKey.getEncoded()), password));
        this.listenerConfig.restartServices();
        return certificateId;
    }
}

