/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener;

import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.listener.ListenerClientCertificateService;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import io.swagger.v3.oas.annotations.Operation;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/listener/clientCertificate"})
@Validated
public class ListenerClientCertificateController {
    public static final String DOCUMENTATION_TAG = "Listener Configuration / Client Certificate";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final ListenerClientCertificateService listenerClientCertificateService;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public ListenerClientCertificateController(ListenerClientCertificateService listenerClientCertificateService, ExceptionDtoFactory exceptionDtoFactory) {
        this.listenerClientCertificateService = listenerClientCertificateService;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @GetMapping
    @Operation(summary="Get all client certificates", description="permission:LISTENER_CLIENT_CERTIFICATE_GET", tags={"Listener Configuration / Client Certificate"})
    @Secured(value={"LISTENER_CLIENT_CERTIFICATE_GET"})
    public ResponseEntity<List<CertificateDto>> getClientCertificates() throws ListenerConfigException {
        return ResponseEntity.ok(this.listenerClientCertificateService.getClientCertificates());
    }

    @PostMapping
    @Operation(summary="Import client  certificate", description="permission:LISTENER_CLIENT_CERTIFICATE_POST<br><br>Import the passed client certificate. If the certificate already exist for the same issuer it has to be deleted before", tags={"Listener Configuration / Client Certificate"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Secured(value={"LISTENER_CLIENT_CERTIFICATE_POST"})
    public ResponseEntity<String> importCertificate(@RequestBody String certificate) throws ListenerConfigException, InstallCertException, CertificateException, NoSuchProviderException {
        String certificateId = this.listenerClientCertificateService.installClientCertificates(certificate);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)certificateId);
    }

    @DeleteMapping(value={"/{certificateId}"})
    @Secured(value={"LISTENER_CLIENT_CERTIFICATE_DELETE"})
    @Operation(summary="Delete a client certificate", description="permission:LISTENER_CLIENT_CERTIFICATE_DELETE<br><br>Delete a client certificate identified by the passed id", tags={"Listener Configuration / Client Certificate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteCaCertificate(@PathVariable String certificateId) throws ListenerConfigException {
        this.listenerClientCertificateService.deleteClientCertificate(certificateId);
        return ResponseEntity.noContent().build();
    }

    @ExceptionHandler(value={ListenerConfigException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleInternalServerError(Exception e) {
        this.log.error("Listener client certificate data not found. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={KeyStoreException.class, InstallCertException.class, GeneralSecurityException.class})
    public ResponseEntity<ExceptionDto> handleBadRequest(Exception e) {
        this.log.error("Could not handle listener client certificate data. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResponseEntity<ExceptionDto> handleNotFound(Exception e) {
        this.log.error("Listener client certificate data not found. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

