/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener;

import de.ponton.securelistener.administration.certs.Certificate;
import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.certificate.CertificateDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ListenerClientCaCertificateService {
    private static final Logger log = LogManager.getLogger((String)("Messenger." + ListenerClientCaCertificateService.class.getName()));
    private final ListenerConfig listenerConfig;
    private final CertificateDtoFactory certificateDtoFactory;
    private final CertificateUtility certificateUtility;

    public ListenerClientCaCertificateService(ListenerConfig listenerConfig, CertificateDtoFactory certificateDtoFactory, CertificateUtility certificateUtility) {
        this.listenerConfig = listenerConfig;
        this.certificateDtoFactory = certificateDtoFactory;
        this.certificateUtility = certificateUtility;
    }

    public List<CertificateDto> getClientCaCertificates() throws ListenerConfigException {
        ArrayList<CertificateDto> caCertificates = new ArrayList<CertificateDto>();
        this.listenerConfig.listClientCACertificates().forEach(caCertificateAlias -> {
            try {
                Certificate clientCACertificate = this.listenerConfig.getClientCACertificate((String)caCertificateAlias);
                caCertificates.add(this.certificateDtoFactory.create(this.certificateUtility.getX509Certificate(clientCACertificate.getCertificate())).setId((String)caCertificateAlias));
            }
            catch (InstallCertException | ListenerConfigException | NoSuchProviderException | CertificateException e) {
                log.error("Could not load client ca certificate with alias: {}. Error: {}", caCertificateAlias, (Object)e.getMessage());
            }
        });
        return caCertificates;
    }

    public String installClientCaCertificates(String certificate) throws ListenerConfigException, InstallCertException, CertificateException, NoSuchProviderException {
        try {
            X509Certificate x509Certificate = this.certificateUtility.getX509Certificate(certificate);
            String certificateId = this.certificateUtility.buildAliasForCA(x509Certificate);
            if (this.certificateAlreadyExists(certificateId)) {
                this.listenerConfig.deleteClientCACertificate(certificateId);
            }
            this.listenerConfig.installClientCACertificate(new Certificate(x509Certificate.getEncoded()));
            return certificateId;
        }
        catch (InstallCertException | GeneralSecurityException e) {
            log.error("Unable to import client ca certificate.", (Throwable)e);
            throw e;
        }
    }

    private boolean certificateAlreadyExists(String certificateAlias) {
        try {
            if (this.listenerConfig.getClientCACertificate(certificateAlias) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void deleteClientCaCertificate(String certificateId) throws ListenerConfigException {
        if (!this.certificateAlreadyExists(certificateId)) {
            throw new ResourceNotFoundException(String.format("Listener client CA does not exist. [id=%s]", certificateId));
        }
        this.listenerConfig.deleteClientCACertificate(certificateId);
    }
}

