/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.hotfolder;

import de.ponton.xmlpipe.rest.adapter.AdapterAbsenceConstraint;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.hotfolder.HotFolderDto;
import de.ponton.xmlpipe.rest.hotfolder.HotFolderDtoFactory;
import de.ponton.xmlpipe.rest.hotfolder.HotFolderOutboxConstraint;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderCfg;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderConfiguration;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.Valid;
import jakarta.xml.bind.JAXBException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hotfolders"})
@Validated
public class HotFoldersController {
    public static final String DOCUMENTATION_TAG = "Hot Folders";
    private final Logger log = LogManager.getLogger((String)("Messenger." + String.valueOf(this.getClass())));
    private final HotFolderConfiguration hotFolderConfiguration;
    private final HotFolderDtoFactory hotFolderDtoFactory;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public HotFoldersController(HotFolderConfiguration hotFolderConfiguration, HotFolderDtoFactory hotFolderDtoFactory, ExceptionDtoFactory exceptionDtoFactory) {
        this.hotFolderConfiguration = hotFolderConfiguration;
        this.hotFolderDtoFactory = hotFolderDtoFactory;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @GetMapping
    @Operation(summary="Get Hot Folders", description="permission:HOTFOLDERS_GET<br><br>Return all Hot Folders Info", tags={"Hot Folders"})
    @Secured(value={"HOTFOLDERS_GET"})
    public ResponseEntity<List<HotFolderDto>> getHotFolders() throws JAXBException {
        ArrayList hotFolderInfoList = new ArrayList();
        for (String id : this.hotFolderConfiguration.getHotFolderIDs()) {
            Optional.ofNullable(this.hotFolderConfiguration.getHotFolder(id)).map(this.hotFolderDtoFactory::create).ifPresent(hotFolderInfoList::add);
        }
        return ResponseEntity.ok(hotFolderInfoList);
    }

    @GetMapping(value={"/{adapterId}"})
    @Operation(summary="Get Hot Folder", description="permission:HOTFOLDERS_GET<br><br>Return a single Hot Folders Info", tags={"Hot Folders"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Adapter configuration is returned"), @ApiResponse(responseCode="404", description="Adapter id does not exist")})
    @Secured(value={"HOTFOLDERS_GET"})
    public ResponseEntity<HotFolderDto> getHotFolder(@PathVariable String adapterId) throws JAXBException {
        return Optional.ofNullable(this.hotFolderConfiguration.getHotFolder(adapterId)).map(e -> ResponseEntity.ok((Object)this.hotFolderDtoFactory.create((HotFolderCfg)e))).orElseThrow(() -> new ResourceNotFoundException(String.format("Hot folder with adapter id %s not found", adapterId)));
    }

    @PostMapping
    @Operation(summary="Creates a Hot Folder", description="permission:HOTFOLDERS_POST<br><br>Creates a Hot Folder", tags={"Hot Folders"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Secured(value={"HOTFOLDERS_POST"})
    public ResponseEntity<HotFolderDto> postHotFolder(@Valid @RequestBody @AdapterAbsenceConstraint @HotFolderOutboxConstraint HotFolderDto hotFolderDto, Principal principal) throws JAXBException {
        this.hotFolderConfiguration.addHotFolder(hotFolderDto.getAdapterId());
        this.hotFolderDtoFactory.parse(hotFolderDto).save(principal.getName());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)hotFolderDto);
    }

    @PutMapping(value={"/{adapterId}"})
    @Secured(value={"HOTFOLDERS_PUT"})
    @Operation(summary="Edit a Hot Folder", description="permission:HOTFOLDERS_PUT<br><br>Edit a Hot Folder", tags={"Hot Folders"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Adapter configuration is updated"), @ApiResponse(responseCode="404", description="Adapter id does not exist")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<HotFolderDto> putHotFolder(@PathVariable String adapterId, @Valid @RequestBody @HotFolderOutboxConstraint HotFolderDto hotFolderDto, Principal principal) throws JAXBException {
        if (this.hotFolderConfiguration.getHotFolder(adapterId) != null) {
            this.hotFolderDtoFactory.parse(hotFolderDto).save(principal.getName());
            return ResponseEntity.noContent().build();
        }
        throw new ResourceNotFoundException(String.format("Hot folder with adapter id %s not found", adapterId));
    }

    @DeleteMapping(value={"/{adapterId}"})
    @Secured(value={"HOTFOLDERS_DELETE"})
    @Operation(summary="Delete an existing hot folder", description="permission:HOTFOLDERS_DELETE<br><br>Delete an existing hot folder adapter or return http not found error when there is no hot folder adapter with the given id", tags={"Hot Folders"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Adapter configuration was deleted"), @ApiResponse(responseCode="404", description="Adapter id does not exist")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteHotFolder(@PathVariable String adapterId, Principal principal) throws JAXBException {
        if (this.hotFolderConfiguration.getHotFolder(adapterId) != null) {
            this.hotFolderConfiguration.removeHotFolder(adapterId);
            this.hotFolderConfiguration.save(principal.getName());
            return ResponseEntity.noContent().build();
        }
        throw new ResourceNotFoundException(String.format("Hot folder with adapter id %s not found", adapterId));
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleNotFound(Exception e) {
        this.log.error("Resource not found, {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

