/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.health.checks;

import de.ponton.xmlpipe.rest.health.ComponentStatus;
import de.ponton.xmlpipe.rest.health.IHealthCheck;
import de.pontonconsulting.xmlpipe.server.Server;
import org.springframework.stereotype.Component;

@Component
public class StartupCheck
implements IHealthCheck {
    public static final String STARTUP_COMPLETED = "startup completed";
    public static final String STARTUP_IN_PROGRESS = "startup in progress";
    private final Server server;

    public StartupCheck(Server server) {
        this.server = server;
    }

    public ComponentStatus<String> healthCheck() {
        if (this.server.isStartupComplete()) {
            return new ComponentStatus<String>("startup", true, STARTUP_COMPLETED);
        }
        return new ComponentStatus<String>("startup", false, STARTUP_IN_PROGRESS);
    }
}

