/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.health;

import de.ponton.xmlpipe.rest.health.IHealthCheck;
import de.ponton.xmlpipe.rest.health.MessengerStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/health"})
public class HealthController {
    public static final String DOCUMENTATION_TAG = "Health";
    private final List<IHealthCheck> healthChecks;

    public HealthController(List<IHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    @Operation(summary="Checks for current messenger Health status", description="Returns the health status of messenger and its components.", tags={"Health"})
    @SecurityRequirements
    @GetMapping
    public ResponseEntity<MessengerStatus> healthCheck() {
        MessengerStatus status = new MessengerStatus();
        this.healthChecks.forEach(e -> status.addComponentStatus(e.healthCheck()));
        if (status.isOk()) {
            return ResponseEntity.ok((Object)status);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)status);
    }
}

