/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.exception;

import de.ponton.xmlpipe.rest.IDtoCreateFactory;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import java.text.MessageFormat;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class ExceptionDtoFactory
implements IDtoCreateFactory<ExceptionDto, Throwable> {
    private final MessageSource messageSource;

    public ExceptionDtoFactory(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public ExceptionDto create(Throwable exception) {
        return new ExceptionDto().setErrorMessage(this.interpolateMessage(exception)).setException(exception.getClass().getName()).setErrorKey(exception.getClass().getName() + ".message");
    }

    private String interpolateMessage(Throwable exception) {
        String messageTemplate = MessageFormat.format("{0}.message", exception.getClass().getName());
        try {
            return this.messageSource.getMessage(messageTemplate, null, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            return exception.getMessage();
        }
    }
}

