/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Schema(description="A Certificate Signing Request (CSR) or Certification Request is a digital request to create a digital certificate from a public key using a digital signature. For more information see explanation on Wikipedia: https://en.wikipedia.org/wiki/Certificate_signing_request")
public class CertificateRequestDto {
    @NotBlank
    @Schema(description="The id of the certificate request")
    @TrimmedField
    private String id;
    @NotBlank
    @Schema(description="The subject of the certificate request")
    @TrimmedField
    private String subject;
    @NotNull
    @Schema(description="The key pair algorithm which is used")
    @TrimmedField
    private String keyPairAlgo;
    @NotBlank
    @Schema(description="The certificate request")
    @TrimmedField
    private String certificateRequest;

    public String getId() {
        return this.id;
    }

    public CertificateRequestDto setId(String id) {
        this.id = id;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public CertificateRequestDto setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getKeyPairAlgo() {
        return this.keyPairAlgo;
    }

    public CertificateRequestDto setKeyPairAlgo(String keyPairAlgo) {
        this.keyPairAlgo = keyPairAlgo;
        return this;
    }

    public String getCertificateRequest() {
        return this.certificateRequest;
    }

    public CertificateRequestDto setCertificateRequest(String certificateRequest) {
        this.certificateRequest = certificateRequest;
        return this;
    }
}

