/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.certificate.CertificateDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.PontonKeystore;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class CertificateCaService {
    private static final Logger log = LogManager.getLogger((String)("Messenger." + CertificateCaService.class.getName()));
    private final KeystoreBean keystoreBean;
    private final CertificateDtoFactory certificateDtoFactory;
    private final CertificateUtility certificateUtility;

    public CertificateCaService(KeystoreBean keystoreBean, CertificateDtoFactory certificateDtoFactory, CertificateUtility certificateUtility) {
        this.keystoreBean = keystoreBean;
        this.certificateDtoFactory = certificateDtoFactory;
        this.certificateUtility = certificateUtility;
    }

    public List<CertificateDto> getAllCaCertificates() throws KeyStoreException {
        ArrayList<CertificateDto> certificateDtoList = new ArrayList<CertificateDto>();
        PontonKeystore keystore = this.keystoreBean.getKeystore();
        Enumeration<String> ids = keystore.caCertificateIds();
        while (ids.hasMoreElements()) {
            String id = ids.nextElement();
            X509Certificate caCertificate = keystore.getCA(id);
            CertificateDto certificateDto = this.certificateDtoFactory.create(caCertificate);
            certificateDto.setId(id);
            certificateDtoList.add(certificateDto);
        }
        return certificateDtoList;
    }

    public Optional<CertificateDto> getCertificate(String certificateId) throws KeyStoreException {
        X509Certificate certificate = this.keystoreBean.getKeystore().getCA(certificateId);
        if (certificate == null) {
            return Optional.empty();
        }
        CertificateDto certificateDto = this.certificateDtoFactory.create(certificate);
        certificateDto.setId(certificateId);
        return Optional.of(certificateDto);
    }

    public String importCaCertificate(String certificate) throws GeneralSecurityException, InstallCertException {
        try {
            PontonKeystore keystore = this.keystoreBean.getKeystore();
            X509Certificate x509Certificate = this.certificateUtility.getX509Certificate(certificate);
            String certificateAlias = keystore.buildAliasForCA(x509Certificate);
            if (this.certificateAlreadyExists(certificateAlias)) {
                keystore.deleteCA(certificateAlias);
            }
            return keystore.addNewCA(x509Certificate);
        }
        catch (InstallCertException | GeneralSecurityException e) {
            log.error("Unable to import ca certificate.", (Throwable)e);
            throw e;
        }
    }

    public void deleteCaCertificate(String certificateId) throws KeyStoreException {
        PontonKeystore keystore = this.keystoreBean.getKeystore();
        if (!this.certificateAlreadyExists(certificateId)) {
            throw new ResourceNotFoundException(String.format("CA does not exist. [id=%s]", certificateId));
        }
        keystore.deleteCA(certificateId);
    }

    private boolean certificateAlreadyExists(String id) throws KeyStoreException {
        return this.keystoreBean.getKeystore().getCA(id) != null;
    }
}

