/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.security.CertificateRequest;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.cert.crmf.jcajce.JcaCertificateRequestMessageBuilder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.Store;
import org.springframework.stereotype.Component;

@Component
public class BDEWCertificateRequestFactory {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + String.valueOf(BDEWCertificateRequestFactory.class)));
    private static final ASN1ObjectIdentifier BSI_DE = new ASN1ObjectIdentifier("0.4.0.127.0.7");
    private static final ASN1ObjectIdentifier BSI_DE_ID_CERT_REQ_MSGS = new ASN1ObjectIdentifier(BSI_DE.getId() + ".4.1.1.1");
    private static final ASN1ObjectIdentifier BSI_DE_ID_CERT_REQ_MSGS_WITH_OUTER_SIGNATURE = new ASN1ObjectIdentifier(BSI_DE.getId() + ".4.1.1.2");
    private final MessengerConfig messengerConfig;

    public BDEWCertificateRequestFactory(MessengerConfig messengerConfig) {
        this.messengerConfig = messengerConfig;
    }

    public byte[] createBDEWCertificateRequest(Map<CertificateRequest, PrivateKey> certificateRequests, SignCertInfo signCertInfo) throws IOException, OperatorCreationException, CRMFException, CertificateEncodingException, CMSException {
        ArrayList<CertReqMsg> certReqMsgs = new ArrayList<CertReqMsg>();
        for (Map.Entry<CertificateRequest, PrivateKey> entry : certificateRequests.entrySet()) {
            CertificateRequest certRequest = entry.getKey();
            PrivateKey privateKey = entry.getValue();
            PKCS10CertificationRequest pkcs10CertificationRequest = new PKCS10CertificationRequest(certRequest.getDER());
            ContentSigner signer = new JcaContentSignerBuilder(this.messengerConfig.getProperty("ponton.messenger.bdew.csr.signature.algorithm")).setProvider("BC").build(privateKey);
            BigInteger certReqId = BigInteger.valueOf(System.nanoTime());
            JcaCertificateRequestMessageBuilder jcaCertificateRequestMessageBuilder = new JcaCertificateRequestMessageBuilder(certReqId);
            jcaCertificateRequestMessageBuilder.setSubject(pkcs10CertificationRequest.getSubject());
            jcaCertificateRequestMessageBuilder.setPublicKey(certRequest.getPublicKey());
            Extensions requestedExtensions = pkcs10CertificationRequest.getRequestedExtensions();
            for (ASN1ObjectIdentifier extensionOID : requestedExtensions.getExtensionOIDs()) {
                Extension extension = requestedExtensions.getExtension(extensionOID);
                jcaCertificateRequestMessageBuilder.addExtension(extensionOID, extension.isCritical(), extension.getParsedValue());
            }
            jcaCertificateRequestMessageBuilder.setProofOfPossessionSigningKeySigner(signer);
            certReqMsgs.add(new CertificateRequestMessage(jcaCertificateRequestMessageBuilder.build().getEncoded()).toASN1Structure());
        }
        CertReqMessages certReqMessages = new CertReqMessages(certReqMsgs.toArray(new CertReqMsg[0]));
        if (signCertInfo == null) {
            DERTaggedObject content = new DERTaggedObject(0, (ASN1Encodable)certReqMessages);
            DERSequence asn1Encodables = new DERSequence(new ASN1Encodable[]{BSI_DE_ID_CERT_REQ_MSGS, content});
            LOG.trace("unsigned CRMF: {}", new Supplier[]{() -> ASN1Dump.dumpAsString((Object)asn1Encodables, (boolean)true)});
            return asn1Encodables.getEncoded();
        }
        List<X509Certificate> certList = List.of(signCertInfo.getCertificateChain());
        CMSProcessableByteArray cmsData = new CMSProcessableByteArray(BSI_DE_ID_CERT_REQ_MSGS, certReqMessages.getEncoded());
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator cmsGenerator = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(this.messengerConfig.getProperty("ponton.messenger.bdew.csr.signature.algorithm")).setProvider("BC").build(signCertInfo.getPrivateKey());
        cmsGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(contentSigner, signCertInfo.getCertificateChain()[0]));
        cmsGenerator.addCertificates((Store)certs);
        CMSSignedData cms = cmsGenerator.generate((CMSTypedData)cmsData, true);
        SignedData signedData = SignedData.getInstance((Object)cms.toASN1Structure().getContent());
        DERTaggedObject content = new DERTaggedObject(0, (ASN1Encodable)signedData);
        DERSequence asn1Encodables = new DERSequence(new ASN1Encodable[]{BSI_DE_ID_CERT_REQ_MSGS_WITH_OUTER_SIGNATURE, content});
        LOG.trace("signed CRMF: {}", new Supplier[]{() -> ASN1Dump.dumpAsString((Object)asn1Encodables, (boolean)true)});
        return asn1Encodables.getEncoded();
    }
}

