/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp;

import de.ponton.xmlpipe.rest.IDtoCreateFactory;
import de.ponton.xmlpipe.rest.cpp.PartnerDto;
import de.ponton.xmlpipe.rest.cpp.identification.PartyIdDtoFactory;
import de.pontonconsulting.xmlpipe.config.partnerprofile.PartyId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PartnerEntityDtoFactory
implements IDtoCreateFactory<PartnerDto, PartnerProfile> {
    private final PartyIdDtoFactory partyIdDtoFactory;

    public PartnerEntityDtoFactory(PartyIdDtoFactory partyIdDtoFactory) {
        this.partyIdDtoFactory = partyIdDtoFactory;
    }

    @Override
    public PartnerDto create(PartnerProfile partnerProfile) {
        PartnerDto partnerDto = new PartnerDto();
        partnerProfile.getBackendPartnerIds().stream().findFirst().ifPresent(backendPartnerId -> partnerDto.setBackendId(backendPartnerId.getBackendPartnerId()));
        partnerDto.setDisabled(false);
        partnerDto.setImported(partnerProfile.getRegistryPath() != null && !partnerProfile.getRegistryPath().isEmpty());
        partnerDto.setId(partnerProfile.getPartnerId());
        partnerDto.setDisplayName(partnerProfile.getDisplayName());
        partnerDto.setRemote(partnerProfile.isRemote());
        partnerDto.setPartyIds(partnerProfile.getPartyIds().stream().map(e -> {
            PartyId partyId = new PartyId();
            partyId.setType(e.getPartyIdType());
            partyId.setValue(e.getPartyIdId());
            return this.partyIdDtoFactory.create(partyId);
        }).collect(Collectors.toList()));
        return partnerDto;
    }
}

