/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp;

import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.certificate.CertificateDtoFactory;
import de.ponton.xmlpipe.rest.cpp.PartnerDto;
import de.ponton.xmlpipe.rest.cpp.PartnerDtoFactory;
import de.ponton.xmlpipe.rest.cpp.PartnerEntityDtoFactory;
import de.ponton.xmlpipe.rest.cpp.certificate.BDEWCertificateRequest;
import de.ponton.xmlpipe.rest.cpp.certificate.CertificateRequestDto;
import de.ponton.xmlpipe.rest.cpp.certificate.CertificateRequestService;
import de.ponton.xmlpipe.rest.cpp.certificate.CreateBDEWCertificateRequestDto;
import de.ponton.xmlpipe.rest.cpp.certificate.CreateCertificateRequestDto;
import de.ponton.xmlpipe.rest.cpp.certificate.DefaultCertificateDto;
import de.ponton.xmlpipe.rest.cpp.certificate.DefaultCertificateDtoFactory;
import de.ponton.xmlpipe.rest.cpp.certificate.ExportKeyPairDto;
import de.ponton.xmlpipe.rest.cpp.certificate.ImportCertificateDto;
import de.ponton.xmlpipe.rest.cpp.certificate.ImportKeyPairDto;
import de.ponton.xmlpipe.rest.cpp.certificate.validation.CertificateExpirationConstraint;
import de.ponton.xmlpipe.rest.cpp.certificate.validation.KeyPairPasswordConstraint;
import de.ponton.xmlpipe.rest.cpp.transport.TransportProtocol;
import de.ponton.xmlpipe.rest.cpp.validation.ImmutablePartnerFieldConstraint;
import de.ponton.xmlpipe.rest.cpp.validation.RequiredFieldsForLocalPartnerConstraint;
import de.ponton.xmlpipe.rest.cpp.validation.RequiredLocalPartnerConstraint;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertificateUpdateAdapter;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.admintool.messenger.ssl.certificate.KeyPairAlgorithm;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import de.pontonconsulting.xmlpipe.cp.DocumentTypeResolver;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CertificateRequestNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppContactInformation;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.DuplicateProfileException;
import de.pontonconsulting.xmlpipe.cpp.PackageIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PartnerCertificateManager;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerCertificateData;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.RemoteMaintenanceInterval;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.RemoteMaintenanceIntervalDAO;
import de.pontonconsulting.xmlpipe.security.CertificateRequest;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.SecurityFileReader;
import de.pontonconsulting.xmlpipe.security.acegi.ClientRoleService;
import de.pontonconsulting.xmlpipe.security.bsi.SmartMeterPkiException;
import de.pontonconsulting.xmlpipe.security.bsi.SmartMeterPkiServer;
import de.pontonconsulting.xmlpipe.security.bsi.SmartMeterPkiService;
import de.pontonconsulting.xmlpipe.security.ldap.LdapServerQueryService;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.operator.OperatorCreationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/partner"})
@Validated
public class PartnerController {
    public static final String DOCUMENTATION_TAG_PARTNER = "Partner";
    public static final String DOCUMENTATION_TAG_CERTIFICATE = "Partner / Certificate";
    public static final String DOCUMENTATION_TAG_KEYPAIR = "Partner / KeyPair";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final Profiles profiles;
    private final PartnerDtoFactory partnerDtoFactory;
    private final PartnerEntityDtoFactory partnerEntityDtoFactory;
    private final ExceptionDtoFactory exceptionDtoFactory;
    private final CertificateUtility certificateUtility;
    private final SchemataConfig schemataConfig;
    private final CertificateRequestService certificateRequestService;
    private final SecurityFileReader securityFileReader;
    private final KeystoreBean keystore;
    private final DefaultCertificateDtoFactory defaultCertificateDtoFactory;
    private final CertificateDtoFactory certificateDtoFactory;
    private final Agreements agreements;
    private final DocumentTypeResolver documentTypeResolver;
    private final AS4CertificateUpdateAdapter as4CertificateUpdateAdapter;
    private final LdapServerQueryService ldapServerQueryService;
    private final ClientRoleService clientRoleService;
    private final SmartMeterPkiService smartMeterPkiService;
    private final PartnerCertificateManager partnerCertificateManager;
    private final RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO;
    private final PartnerProfileDAO partnerProfileDAO;

    public PartnerController(Profiles profiles, PartnerDtoFactory partnerDtoFactory, PartnerEntityDtoFactory partnerEntityDtoFactory, ExceptionDtoFactory exceptionDtoFactory, CertificateUtility certificateUtility, SchemataConfig schemataConfig, CertificateRequestService certificateRequestService, SecurityFileReader securityFileReader, KeystoreBean keystore, CertificateDtoFactory certificateDtoFactory, DefaultCertificateDtoFactory defaultCertificateDtoFactory, Agreements agreements, DocumentTypeResolver documentTypeResolver, AS4CertificateUpdateAdapter as4CertificateUpdateAdapter, LdapServerQueryService ldapServerQueryService, ClientRoleService clientRoleService, SmartMeterPkiService smartMeterPkiService, PartnerCertificateManager partnerCertificateManager, RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO, PartnerProfileDAO partnerProfileDAO) {
        this.profiles = profiles;
        this.partnerDtoFactory = partnerDtoFactory;
        this.partnerEntityDtoFactory = partnerEntityDtoFactory;
        this.exceptionDtoFactory = exceptionDtoFactory;
        this.certificateUtility = certificateUtility;
        this.schemataConfig = schemataConfig;
        this.certificateRequestService = certificateRequestService;
        this.securityFileReader = securityFileReader;
        this.keystore = keystore;
        this.certificateDtoFactory = certificateDtoFactory;
        this.defaultCertificateDtoFactory = defaultCertificateDtoFactory;
        this.agreements = agreements;
        this.documentTypeResolver = documentTypeResolver;
        this.as4CertificateUpdateAdapter = as4CertificateUpdateAdapter;
        this.ldapServerQueryService = ldapServerQueryService;
        this.clientRoleService = clientRoleService;
        this.smartMeterPkiService = smartMeterPkiService;
        this.partnerCertificateManager = partnerCertificateManager;
        this.remoteMaintenanceIntervalDAO = remoteMaintenanceIntervalDAO;
        this.partnerProfileDAO = partnerProfileDAO;
    }

    @PostMapping
    @Secured(value={"PARTNER_POST"})
    @Operation(summary="Create a Partner", description="The passed Partner will be created on the messenger and returned to the caller if creation was successful.", tags={"Partner"})
    @Validated(value={ValidationGroup.Create.class})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<PartnerDto> createPartner(@RequestBody @Valid PartnerDto partner, Principal principal) throws ProfileException, AgreementException {
        CppPartner cppPartner = null;
        try {
            cppPartner = partner.isRemote() ? this.profiles.createNewRemotePartner(this.profiles.generateId(), partner.getBackendId(), partner.getDisplayName()) : this.profiles.createNewLocalPartner(this.profiles.generateId(), partner.getBackendId(), partner.getDisplayName());
            this.updateCppPartner(partner, cppPartner, principal);
            if (partner.isRemote()) {
                this.ldapServerQueryService.updatePartnerCertificatesFromLDAP(cppPartner);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.partnerDtoFactory.create(cppPartner));
        }
        catch (ProfileException e) {
            if (cppPartner != null) {
                this.profiles.deleteProfile(cppPartner.getLocalId());
            }
            throw e;
        }
    }

    @PutMapping(value={"/{partnerId}"})
    @Secured(value={"PARTNER_PUT"})
    @Operation(summary="Update a Partner", description="permission:PARTNER_PUT<br><br>The passed Partner will be updated on the messenger and returned to the caller if update was successful.", tags={"Partner"})
    @Validated(value={ValidationGroup.Update.class})
    @ImmutablePartnerFieldConstraint
    public synchronized ResponseEntity<PartnerDto> updatePartner(@PathVariable String partnerId, @RequestBody @Valid PartnerDto partner, Principal principal) throws ProfileException, AgreementException {
        this.updateCppPartner(partner, this.getCppPartner(partnerId, false), principal);
        if (partner.isRemote()) {
            this.ldapServerQueryService.updatePartnerCertificatesFromLDAP(this.getCppPartner(partnerId, false));
        }
        return ResponseEntity.ok((Object)this.partnerDtoFactory.create(this.getCppPartner(partnerId, false)));
    }

    private CppPartner getCppPartner(String partnerId, boolean useCache) throws ProfileException {
        return this.profiles.getProfileForLocalId(partnerId, useCache);
    }

    @PutMapping(value={"/remote/{partnerId}"})
    @Secured(value={"PARTNER_REMOTE_PUT"})
    @Operation(summary="Update a Partner", description="permission:PARTNER_REMOTE_PUT<br><br>The passed remote Partner will be updated on the messenger and returned to the caller if update was successful.", tags={"Partner"})
    @Validated(value={ValidationGroup.Update.class})
    @ImmutablePartnerFieldConstraint
    public synchronized ResponseEntity<PartnerDto> updateRemotePartner(@PathVariable String partnerId, @RequestBody @Valid PartnerDto partner, Principal principal) throws ProfileException, AgreementException {
        CppPartner cppPartner = this.getCppPartner(partnerId, false);
        if (cppPartner.isLocal()) {
            throw new IllegalArgumentException("Cannot edit local partner with this endpoint");
        }
        return this.updatePartner(partnerId, partner, principal);
    }

    @PutMapping(value={"/local/{partnerId}"})
    @Secured(value={"PARTNER_LOCAL_PUT"})
    @Operation(summary="Update a Partner", description="permission:PARTNER_LOCAL_PUT<br><br>The passed local Partner will be updated on the messenger and returned to the caller if update was successful.", tags={"Partner"})
    @Validated(value={ValidationGroup.Update.class})
    @ImmutablePartnerFieldConstraint
    public synchronized ResponseEntity<PartnerDto> updateLocalPartner(@PathVariable String partnerId, @RequestBody @Valid PartnerDto partner, Principal principal) throws ProfileException, AgreementException {
        CppPartner cppPartner = this.getCppPartner(partnerId, false);
        if (cppPartner.isRemote()) {
            throw new IllegalArgumentException("Cannot edit remote partner with this endpoint");
        }
        return this.updatePartner(partnerId, partner, principal);
    }

    private void updateCppPartner(PartnerDto partner, CppPartner cppPartner, Principal principal) throws ProfileException, AgreementException {
        DefaultCertificateDto certificates = this.defaultCertificateDtoFactory.create(cppPartner);
        certificates.setPartnerLocalId(partner.getId());
        cppPartner.setAllPipelineOptions(false);
        cppPartner.setAllPackagingOptions(false);
        cppPartner.setCertUpdateAllowed(partner.isAllowCertificateUpdate());
        this.updatePartnerCommonParameters(partner, cppPartner);
        this.updatePartyIds(partner, cppPartner);
        this.updateTransports(partner, cppPartner);
        cppPartner.setNumberOfParallelDeliveries(partner.getNumberOfParallelDeliveries());
        this.updateMessageTypes(partner, cppPartner);
        this.updateMaintenancePeriods(partner, cppPartner);
        this.defaultCertificateDtoFactory.updatePackagingCertificatesInPartner(certificates, cppPartner);
        this.profiles.validateFunctionalKeyOfPartner(cppPartner, false);
        cppPartner.save(true, true, true, true, true, principal.getName());
    }

    private void updateMessageTypes(PartnerDto partner, CppPartner cppPartner) {
        ArrayList<DocumentType> documentTypes = new ArrayList<DocumentType>();
        partner.getMessageTypeIds().forEach(messageTypeId -> {
            SchemaData schemaData = this.schemataConfig.findSchemaDataById((String)messageTypeId);
            if (schemaData == null) {
                throw new ResourceNotFoundException("No message type definition found for the id '" + messageTypeId + "'.");
            }
            DocumentType documentType = this.documentTypeResolver.resolveDocument(schemaData.getMessageType(), schemaData.getMessageVersion(), schemaData.getNamespace(), schemaData.getName(), schemaData.getSchemaSetName());
            if (documentType == null) {
                throw new ResourceNotFoundException("No message type definition found for the id '" + messageTypeId + "'.");
            }
            documentTypes.add(documentType);
        });
        cppPartner.setDocumentTypes(documentTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransports(PartnerDto partner, CppPartner cppPartner) {
        CppPartner cppPartner2 = cppPartner;
        synchronized (cppPartner2) {
            cppPartner.deleteAllTransports();
            partner.getTransports().forEach(transportDto -> {
                String scheme = TransportProtocol.valueOf(transportDto.getUrl().split(":")[0].toUpperCase()).getValue();
                long count = cppPartner.getTransportList().stream().filter(transport -> transport.getURL().toLowerCase().startsWith((scheme + ":").toLowerCase())).count();
                String id = scheme + String.valueOf(count > 0L ? Long.valueOf(count) : "");
                cppPartner.setTransportUrl(id, transportDto.getUrl());
                if (transportDto.getPreferred().booleanValue() && cppPartner.getPreferredTransportId() == null) {
                    cppPartner.setPreferredTransportId(id);
                }
                if (transportDto.getFallback().booleanValue() && cppPartner.getFallbackTransportId() == null) {
                    cppPartner.setFallbackTransportId(id);
                }
            });
        }
    }

    private void updatePartyIds(PartnerDto partner, CppPartner cppPartner) {
        cppPartner.deleteAllPartyIds();
        partner.getPartyIds().forEach(partyIdDto -> cppPartner.addPartyId(partyIdDto.getType(), partyIdDto.getValue(), partyIdDto.getIncludeInEbXml20(), partyIdDto.getIncludeInAS4()));
    }

    private void updatePartnerCommonParameters(PartnerDto partner, CppPartner cppPartner) throws PackageIdNotFoundException {
        CppContactInformation contactInformation = new CppContactInformation();
        contactInformation.setEmail(partner.getEmail());
        contactInformation.setName(partner.getName());
        contactInformation.setPhone(partner.getPhone());
        cppPartner.setContactInformation(contactInformation);
        cppPartner.setPreferredPackagingId(partner.getDefaultPackager());
        cppPartner.setInternalId(partner.getBackendId());
        cppPartner.setDisplayName(partner.getDisplayName());
        cppPartner.setDisabled(partner.isDisabled());
        cppPartner.setAutoupdate(partner.getAutomaticPartnerUpdate() != false && partner.isRemote());
        cppPartner.setAgreementAutoupdate(partner.getAutomaticAgreementsUpdate() != false && partner.isRemote());
    }

    private void updateMaintenancePeriods(PartnerDto partner, CppPartner cppPartner) {
        if (partner.getMaintenancePeriods() == null) {
            this.remoteMaintenanceIntervalDAO.deleteAll(cppPartner.getLocalId());
            return;
        }
        this.remoteMaintenanceIntervalDAO.update(cppPartner.getLocalId(), partner.getMaintenancePeriods().stream().map(period -> {
            long startMillis = period.getStartDate().toInstant().toEpochMilli();
            long endMillis = period.getEndDate().toInstant().toEpochMilli();
            return new RemoteMaintenanceInterval().setStartTime(startMillis).setEndTime(endMillis).setPartnerId(partner.getId());
        }).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/{partnerId}"})
    @Operation(summary="Get a Partner", description="permission:PARTNER_GET<br><br>Returns the Partner with the passed id.", tags={"Partner"})
    @Secured(value={"PARTNER_GET"})
    public ResponseEntity<PartnerDto> getPartner(@PathVariable String partnerId) throws ProfileException {
        CppPartner partner;
        CppPartner cppPartner = partner = this.getCppPartner(partnerId, true);
        synchronized (cppPartner) {
            return ResponseEntity.ok((Object)this.partnerDtoFactory.create(partner));
        }
    }

    @GetMapping
    @Operation(summary="Get a filtered list of Partners", description="permission:PARTNER_GET<br><br>Returns a list of Partners. The Partners can be filtered using the optional parameters of the operation.", tags={"Partner"})
    @Secured(value={"PARTNER_GET"})
    public ResponseEntity<List<PartnerDto>> getPartnersFiltered(@RequestParam(required=false) Optional<String> internalId, @RequestParam(required=false) Optional<Boolean> isLocal, @RequestParam(required=false) Optional<String> displayName, Principal principal) {
        List partnerDtoList = this.partnerProfileDAO.getAllPartnerProfiles(internalId, isLocal, displayName).stream().filter(profile -> this.clientRoleService.verifyPartnerAccess(profile.getPartnerId(), principal.getName())).map(this.partnerEntityDtoFactory::create).collect(Collectors.toList());
        return ResponseEntity.ok(partnerDtoList);
    }

    @DeleteMapping(value={"/{partnerId}"})
    @Secured(value={"PARTNER_DELETE"})
    @Operation(summary="Delete a Partner", description="permission:PARTNER_DELETE<br><br>The Partner with the passed id will be deleted.", tags={"Partner"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public synchronized ResponseEntity<Void> deletePartner(@PathVariable String partnerId) throws ProfileException {
        this.agreements.removeAgreementsOfPartner(partnerId);
        this.profiles.deleteProfile(partnerId);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @GetMapping(value={"/{partnerId}/certificate/{certId}"})
    @Operation(summary="Get a single Certificate for a Partner", description="permission:PARTNER_CERTIFICATE_GET<br><br>Returns the certificate with the passed certId for the partner with the passed id.", tags={"Partner / Certificate"})
    @Secured(value={"PARTNER_CERTIFICATE_GET"})
    public ResponseEntity<CertificateDto> getCertificate(@PathVariable String partnerId, @PathVariable String certId) throws Exception {
        CppPartner partner = this.getCppPartner(partnerId, true);
        X509Certificate x509Certificate = partner.getX509Certificate(certId);
        return ResponseEntity.ok((Object)this.certificateDtoFactory.create(x509Certificate).setId(certId));
    }

    @GetMapping(value={"/{partnerId}/certificate"})
    @Operation(summary="Get a list of Certificates for a Partner", description="permission:PARTNER_CERTIFICATE_GET<br><br>Returns a list of certificates for the partner with the passed id.", tags={"Partner / Certificate"})
    @Secured(value={"PARTNER_CERTIFICATE_GET"})
    public ResponseEntity<List<CertificateDto>> getCertificateList(@PathVariable String partnerId, boolean onlyInvalid) throws Exception {
        String[] certificateIds;
        CppPartner partner = this.getCppPartner(partnerId, true);
        List<CertificateDto> certificateDtoList = new ArrayList<CertificateDto>();
        for (String certId : certificateIds = partner.getCertificateIds()) {
            X509Certificate x509Certificate = partner.getX509Certificate(certId);
            certificateDtoList.add(this.certificateDtoFactory.create(x509Certificate).setId(certId));
        }
        if (onlyInvalid) {
            OffsetDateTime buffer = OffsetDateTime.now(ZoneOffset.UTC).plusMonths(1L);
            certificateDtoList = certificateDtoList.stream().filter(cert -> !cert.getValidTo().isAfter(buffer)).toList();
        }
        return ResponseEntity.ok(certificateDtoList);
    }

    @GetMapping(value={"/certificates"})
    @Operation(summary="Get a list of all Partner Certificates", description="permission:PARTNER_CERTIFICATE_GET<br><br>Returns a list of all certificates for all partners.", tags={"Partner / Certificate"})
    @Secured(value={"PARTNER_CERTIFICATE_GET"})
    public ResponseEntity<List<PartnerCertificateData>> getAllPartnerCertificates() {
        List<PartnerCertificateData> certificateDtoList = this.partnerProfileDAO.getAllPartnerCertificates();
        return ResponseEntity.ok(certificateDtoList);
    }

    @DeleteMapping(value={"/{partnerId}/certificate/{certId}"})
    @Operation(summary="Delete a Certificate for a partner", description="permission:PARTNER_CERTIFICATE_DELETE<br><br>The Certificate with  the passed id for the partner with the passed id will be deleted on the messenger.", tags={"Partner / Certificate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Secured(value={"PARTNER_CERTIFICATE_DELETE"})
    public ResponseEntity<Void> deleteCertificate(@PathVariable String partnerId, @PathVariable String certId) throws ProfileException, InstallCertException, GeneralSecurityException {
        CppPartner partner = this.getCppPartner(partnerId, false);
        partner.deletePartnerCertificate(certId);
        partner.save();
        this.profiles.partnerCertificateUpdated(partner);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/{partnerId}/keyPair/{certId}"})
    @Operation(summary="Export a KeyPair to a partner", description="permission:PARTNER_KEY_PAIR_GET<br><br>Exports a Base64 encoded PKS12 Keystore containing the Certificate Chain and Private Key from the partner", tags={"Partner / KeyPair"})
    @KeyPairPasswordConstraint
    @RequiredLocalPartnerConstraint
    @Secured(value={"PARTNER_KEY_PAIR_GET"})
    public ResponseEntity<ExportKeyPairDto> getKeyPair(@PathVariable String partnerId, @PathVariable String certId, @RequestParam String password) throws ProfileException, GeneralSecurityException, IOException {
        SignCertInfo signCertInfo;
        X509Certificate certificate;
        CppPartner partner = this.getCppPartner(partnerId, true);
        try {
            certificate = partner.getX509Certificate(certId);
            signCertInfo = partner.getPrivateKey(certId);
        }
        catch (Exception e) {
            throw new CertificateIdNotFoundException();
        }
        String certAlias = partner.buildAliasForPartnerCertificate(certificate);
        String privateKeyPassword = partner.getPrivateKeyPassword(certAlias);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.certificateUtility.storePkcs12PrivateKey(certAlias, privateKeyPassword, signCertInfo.getPrivateKey(), signCertInfo.getCertificateChain(), out);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)new ExportKeyPairDto().setId(certId).setKeystore(Base64.getEncoder().encodeToString(out.toByteArray())));
    }

    @PostMapping(value={"/{partnerId}/keyPair"})
    @Secured(value={"PARTNER_KEY_PAIR_POST"})
    @Operation(summary="Import a KeyPair to a partner", description="permission:PARTNER_KEY_PAIR_POST<br><br>The passed Base64 encoded PKS12 Keystore containing the Certificate Chain and Private Key is imported to the partner", tags={"Partner / KeyPair"})
    @Validated(value={ValidationGroup.Create.class})
    @RequiredLocalPartnerConstraint
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<ExportKeyPairDto> postKeyPair(@PathVariable String partnerId, @RequestBody @Valid ImportKeyPairDto importKeyPairDto) throws Exception {
        CppPartner partner = this.getCppPartner(partnerId, false);
        SignCertInfo signCertInfo = this.securityFileReader.getSignCertInfo(new ByteArrayInputStream(Objects.requireNonNull(Base64.getDecoder().decode(importKeyPairDto.getKeystore()))), importKeyPairDto.getPassword());
        X509Certificate certificate = signCertInfo.getCertificateChain()[0];
        certificate.checkValidity();
        Set<X509Certificate> allPartnerCertificates = partner.getAllCertificates();
        for (X509Certificate partnerCert : allPartnerCertificates) {
            if (!this.certificateUtility.certificatesEqual(certificate, partnerCert)) continue;
            throw new InstallCertException(32017, String.format("Certificate is already installed. Id [%s]", partner.getCertificateId(certificate)));
        }
        for (int i = signCertInfo.getCertificateChain().length; i > 1; --i) {
            X509Certificate cert = signCertInfo.getCertificateChain()[i - 1];
            this.keystore.getKeystore().addNewCA(cert);
        }
        String certId = partner.addPrivateKey(certificate, signCertInfo.getPrivateKey(), importKeyPairDto.getPassword());
        this.updateDefaultCertificate(partner, certificate, certId);
        partner.save();
        this.profiles.partnerCertificateUpdated(partner);
        if (partner.getAllValidCertificates().size() > 1) {
            this.as4CertificateUpdateAdapter.sendAS4CertificateUpdateRequestMessage(partner, certId);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)new ExportKeyPairDto().setId(certId).setKeystore(importKeyPairDto.getKeystore()));
    }

    private boolean updateDefaultCertificate(CppPartner localPartner, X509Certificate newCertificate, String newCertificateId) throws CertificateParsingException, CertificateIdNotFoundException {
        X509Certificate defaultCertificate;
        List<String> extendedKeyUsageOfDefaultCertificate;
        List<String> extendedKeyUsage = newCertificate.getExtendedKeyUsage();
        if (!(extendedKeyUsage == null || !extendedKeyUsage.contains(KeyPurposeId.id_kp_clientAuth.getId()) || localPartner.getDefaultCertRefId() == null || localPartner.getDefaultCertRefId().equals(newCertificateId) || (extendedKeyUsageOfDefaultCertificate = (defaultCertificate = localPartner.getX509Certificate(localPartner.getDefaultCertRefId())).getExtendedKeyUsage()) != null && extendedKeyUsageOfDefaultCertificate.contains(KeyPurposeId.id_kp_clientAuth.getId()))) {
            localPartner.setDefaultCertRefId(newCertificateId);
            this.log.info("The certificate with id '{}' set to default for the partner with id '{}'.", (Object)newCertificateId, (Object)localPartner.getLocalId());
            return true;
        }
        return false;
    }

    @PostMapping(value={"/{partnerId}/certificateRequest"})
    @Secured(value={"PARTNER_CERTIFICATE_REQUEST_POST"})
    @Operation(summary="Do a CertificateRequest for a partner", description="permission:PARTNER_CERTIFICATE_REQUEST_POST<br><br>The passed CertificateRequest for the partner with the passed id will be sent to the messenger. If the request was successful a String is returned to the  caller which contains the subject and the PEM.", tags={"Partner / Certificate"})
    @Validated(value={ValidationGroup.Create.class})
    @RequiredLocalPartnerConstraint
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<CertificateRequestDto> postCertificateRequest(@PathVariable String partnerId, @RequestBody @Valid CreateCertificateRequestDto createCertificateRequestDto) throws ProfileException, AgreementException, GeneralSecurityException, InstallCertException, IOException {
        CppPartner partner = this.getCppPartner(partnerId, false);
        CertificateRequest certificateRequest = this.certificateRequestService.requestCertificate(partner, createCertificateRequestDto);
        CertificateRequestDto certificateRequestDto = new CertificateRequestDto().setId(certificateRequest.getId()).setCertificateRequest(certificateRequest.getPEM()).setSubject(certificateRequest.getSubject()).setKeyPairAlgo(createCertificateRequestDto.getKeyPair().getAlgorithm());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)certificateRequestDto);
    }

    @PostMapping(value={"/{partnerId}/bdewCertificateRequest"})
    @Secured(value={"PARTNER_BDEW_CERTIFICATE_REQUEST_POST"})
    @Operation(summary="Do a BDEW CertificateRequest for a partner", description="permission:PARTNER_BDEW_CERTIFICATE_REQUEST_POST<br><br>The passed CertificateRequest for the partner with the passed id will be sent to the messenger. If the request was successful, 3 Strings are returned to the  caller which contains the subject and the PEM.", tags={"Partner / Certificate"})
    @Validated(value={ValidationGroup.Create.class})
    @RequiredLocalPartnerConstraint
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<CertificateRequestDto> postBDEWCertificateRequest(@PathVariable String partnerId, @RequestBody @Valid CreateBDEWCertificateRequestDto createBDEWCertificateRequestDto) throws ProfileException, AgreementException, GeneralSecurityException, InstallCertException, IOException, OperatorCreationException, CRMFException, CMSException {
        CppPartner partner = this.getCppPartner(partnerId, false);
        byte[] result = this.certificateRequestService.requestBDEWCertificate(partner, createBDEWCertificateRequestDto).getBDEWFormatedData();
        CertificateRequestDto certificateRequestDto = new CertificateRequestDto().setCertificateRequest(Base64.getMimeEncoder(64, "\n".getBytes()).encodeToString(result)).setKeyPairAlgo(KeyPairAlgorithm.brainpoolP256r1.getAlgorithm());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)certificateRequestDto);
    }

    @PostMapping(value={"/{partnerId}/requestBDEWCertificateBySubCA/{subCaName}"})
    @Secured(value={"PARTNER_BDEW_CERTIFICATE_REQUEST_POST"})
    @Operation(summary="Request and install BDEW Certificates for a partner", description="permission:PARTNER_BDEW_CERTIFICATE_REQUEST_POST<br><br>The passed CertificateRequest for the partner with the passed id will be sent to the messenger. If the request was successful, 3 new BDEW certificates are installed.", tags={"Partner / Certificate"})
    @Validated(value={ValidationGroup.Create.class})
    @RequiredLocalPartnerConstraint
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> postRequestBDEWCertificateBySubCA(@PathVariable String partnerId, @PathVariable String subCaName, @RequestBody @Valid CreateBDEWCertificateRequestDto createBDEWCertificateRequestDto) throws ProfileException, GeneralSecurityException, InstallCertException, IOException, OperatorCreationException, CRMFException, CMSException, SmartMeterPkiException, AgreementException {
        List<byte[]> certificates;
        CppPartner partner = this.getCppPartner(partnerId, false);
        Optional<SmartMeterPkiServer> smartMeterPkiServer = this.smartMeterPkiService.getSmartMeterPkiServer(subCaName);
        if (smartMeterPkiServer.isEmpty()) {
            this.log.error("Sub-CA with the name '{}' not found.", (Object)subCaName);
            throw new IllegalArgumentException(String.format("Sub-CA with the name '%s' not found.", subCaName));
        }
        Optional<SignCertInfo> defaultValidSignKey = Optional.ofNullable(this.partnerCertificateManager.getDefaultValidSignKey(partner));
        if (defaultValidSignKey.isEmpty()) {
            this.log.error("No valid TLS Certificate found for partner '{}' with id '{}' .", (Object)partner.getInternalId(), (Object)partner.getLocalId());
            throw new CertificateException("No valid TLS Certificate found for the partner.");
        }
        partner = this.getCppPartner(partnerId, false);
        BDEWCertificateRequest bdewCertificateRequest = this.certificateRequestService.requestBDEWCertificate(partner, createBDEWCertificateRequestDto);
        try {
            certificates = this.smartMeterPkiService.requestCertificate(smartMeterPkiServer.get(), bdewCertificateRequest.getBDEWFormatedData(), defaultValidSignKey.get().getCertificateChain(), defaultValidSignKey.get().getPrivateKey());
        }
        catch (SmartMeterPkiException e) {
            for (CertificateRequest certificateRequest : bdewCertificateRequest.getCertificateRequests()) {
                partner.removeCertificateRequestData(certificateRequest.getId());
            }
            partner.save(false, true, true, false, false);
            throw e;
        }
        for (byte[] certificate : certificates) {
            X509Certificate x509Certificate = this.certificateUtility.getX509Certificate(certificate);
            String certId = this.certificateRequestService.installCertificate(partner, x509Certificate, createBDEWCertificateRequestDto.getPassword());
            this.updateDefaultCertificate(partner, x509Certificate, certId);
        }
        partner.save(false, true, true, false, false);
        this.profiles.partnerCertificateUpdated(partner);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{partnerId}/certificate"})
    @Secured(value={"PARTNER_CERTIFICATE_POST"})
    @Operation(summary="Install a certificate for a partner", description="permission:PARTNER_CERTIFICATE_POST<br><br>The passed Certificate and password for the partner with the passed id will be sent to the messenger and installed there. As a response the id of the installed certificate is returned to the caller.", tags={"Partner / Certificate"})
    @Validated(value={ValidationGroup.Create.class})
    @RequiredFieldsForLocalPartnerConstraint
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<String> postCertificate(@PathVariable String partnerId, @RequestBody @Valid ImportCertificateDto certificateDto) throws GeneralSecurityException, InstallCertException, ProfileException, AgreementException {
        String certId;
        CppPartner partner = this.getCppPartner(partnerId, false);
        X509Certificate x509Certificate = this.certificateUtility.getX509Certificate(certificateDto.getCertificateBase64());
        if (partner.isLocal()) {
            certId = this.certificateRequestService.installCertificate(partner, x509Certificate, certificateDto.getPassword());
            this.updateDefaultCertificate(partner, x509Certificate, certId);
        } else {
            this.keystore.getKeystore().checkCertificate(x509Certificate);
            certId = partner.addPartnerCertificate(x509Certificate);
        }
        partner.save(false, true, true, false, false);
        this.profiles.partnerCertificateUpdated(partner);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)certId);
    }

    @GetMapping(value={"/{id}/certificateRequest"})
    @RequiredLocalPartnerConstraint
    @Operation(summary="Get all certificate requests for a partner", description="permission:PARTNER_CERTIFICATE_REQUEST_GET<br><br>Return a list of certificate requests for a given partner id", tags={"Partner / Certificate"})
    @Secured(value={"PARTNER_CERTIFICATE_REQUEST_GET"})
    public ResponseEntity<List<CertificateRequestDto>> getAllCertificateRequestsForPartner(@PathVariable String id) throws IOException, ProfileException {
        return ResponseEntity.ok(this.certificateRequestService.getAllCertificateRequestsForLocalId(id));
    }

    @GetMapping(value={"/{id}/certificateRequest/{certificateRequestId}"})
    @RequiredLocalPartnerConstraint
    @Operation(summary="Get a specific certificate request for a partner", description="permission:PARTNER_CERTIFICATE_REQUEST_GET<br><br>Return a specific certificate request for a given partner id. The concrete certificate request to be returned is specified by the given certificate request id", tags={"Partner / Certificate"})
    @Secured(value={"PARTNER_CERTIFICATE_REQUEST_GET"})
    public ResponseEntity<CertificateRequestDto> getCertificateRequestForPartner(@PathVariable String id, @PathVariable String certificateRequestId) throws IOException, ProfileException {
        List<CertificateRequestDto> certificateRequests = this.certificateRequestService.getAllCertificateRequestsForLocalId(id);
        Optional<CertificateRequestDto> certificateRequestDto = certificateRequests.stream().filter(certificateRequest -> certificateRequest.getId().equals(certificateRequestId)).findFirst();
        return ResponseEntity.ok((Object)certificateRequestDto.orElseThrow(() -> new CertificateRequestNotFoundException(String.format("CertificateRequest not found. [LocalId=%s, CertificateRequestId=%s]", id, certificateRequestId))));
    }

    @GetMapping(value={"/{partnerId}/defaultCertificate"})
    @Operation(summary="Get the default certificates for the partner", description="permission:PARTNER_DEFAULT_CERTIFICATE_GET<br><br>The DefaultCertificateDto contains a default certificate for each packagingId, processing pipeline and partner default certificate", tags={"Partner / Certificate"})
    @Secured(value={"PARTNER_DEFAULT_CERTIFICATE_GET"})
    public ResponseEntity<DefaultCertificateDto> getDefaultCertificates(@PathVariable String partnerId) throws ProfileException {
        return ResponseEntity.ok((Object)this.defaultCertificateDtoFactory.create(this.getCppPartner(partnerId, true)));
    }

    @PutMapping(value={"/{partnerId}/defaultCertificate"})
    @Secured(value={"PARTNER_DEFAULT_CERTIFICATE_PUT"})
    @CertificateExpirationConstraint
    @Operation(summary="Set the default certificates for the partner", description="permission:PARTNER_DEFAULT_CERTIFICATE_PUT<br><br>The DefaultCertificateDto contains a default certificate for each packagingId, processing pipeline and partner default certificate", tags={"Partner / Certificate"})
    @Validated(value={ValidationGroup.Update.class})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> setDefaultCertificates(@PathVariable String partnerId, @Valid @RequestBody DefaultCertificateDto defaultCertificateDto) throws ProfileException, AgreementException {
        defaultCertificateDto.setPartnerLocalId(partnerId);
        this.defaultCertificateDtoFactory.parse(defaultCertificateDto).save(false, true, true, false, false);
        return ResponseEntity.noContent().build();
    }

    @ExceptionHandler(value={InstallCertException.class, GeneralSecurityException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleBadRequest(Exception e) {
        this.log.error("Could not handle certificate / certificate request. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ProfileNotFoundException.class, IndexOutOfBoundsException.class, CertificateException.class, CertificateIdNotFoundException.class, CertificateRequestNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleNotFound(Exception e) {
        this.log.error("Partner data not found. Error: {}", (Object)e.getMessage());
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(cause), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={DuplicateProfileException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleDuplicateProfileException(DuplicateProfileException e) {
        this.log.error("Duplicate profile: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e).addErrorMessageParameter("key", e.key()).addErrorMessageParameter("value", e.value()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ProfileException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ExceptionDto> handleProfileException(ProfileException e) {
        this.log.error("Unexpected error when handling partner data. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

