/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.rules;

import java.util.HashMap;
import java.util.Map;

public enum RuleOperator {
    GREATER_THAN("GreaterThan"),
    LESS_THAN("LessThan"),
    NOT_EQUAL("NotEqual"),
    EQUAL("Equal"),
    CONTAINS("Contains"),
    CONTAINS_NOT("ContainsNot"),
    STARTS_WITH("StartsWith"),
    ENDS_WITH("EndsWith");

    private final String name;
    private static final Map<String, RuleOperator> nameLookup;

    private RuleOperator(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static RuleOperator of(String name) {
        return nameLookup.get(name);
    }

    static {
        nameLookup = new HashMap<String, RuleOperator>();
        for (RuleOperator ruleOperator : RuleOperator.values()) {
            nameLookup.put(ruleOperator.getName(), ruleOperator);
        }
    }
}

