/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing.data;

import de.pontonconsulting.xmlpipe.config.privatepartneragreement.DoctypeActionType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum DocTypeProcessing {
    ADD("add"),
    REMOVE("remove");

    private static final Map<String, DocTypeProcessing> nameLookup;
    private final String name;

    private DocTypeProcessing(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DocTypeProcessing of(String name) {
        return nameLookup.get(name);
    }

    public static DocTypeProcessing ofOptionValue(String doctypeAction) {
        if (StringUtils.isNotBlank((CharSequence)doctypeAction)) {
            DoctypeActionType doctypeActionType = DoctypeActionType.fromValue((String)doctypeAction);
            switch (doctypeActionType) {
                case ADD_UPDATE: {
                    return ADD;
                }
                case REMOVE: {
                    return REMOVE;
                }
            }
            return null;
        }
        return null;
    }

    public static String asOptionValue(DocTypeProcessing docTypeProcessing) {
        switch (docTypeProcessing.ordinal()) {
            case 0: {
                return DoctypeActionType.ADD_UPDATE.value();
            }
            case 1: {
                return DoctypeActionType.REMOVE.value();
            }
        }
        return DoctypeActionType.NO_CHANGE.value();
    }

    static {
        nameLookup = new HashMap<String, DocTypeProcessing>();
        for (DocTypeProcessing docTypeProcessing : DocTypeProcessing.values()) {
            nameLookup.put(docTypeProcessing.getName(), docTypeProcessing);
        }
    }
}

