/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing.data;

import java.util.HashMap;
import java.util.Map;

public enum CharacterEncoding {
    UTF_8("UTF-8"),
    UTF_16("UTF-16"),
    ISO_8859_1("ISO-8859-1"),
    ISO_8859_2("ISO-8859-2"),
    ISO_8859_3("ISO-8859-3"),
    ISO_8859_4("ISO-8859-4"),
    ISO_8859_5("ISO-8859-5"),
    ISO_8859_6("ISO-8859-6"),
    ISO_8859_7("ISO-8859-7"),
    ISO_8859_8("ISO-8859-8"),
    ISO_8859_9("ISO-8859-9"),
    ISO_8859_13("ISO-8859-13"),
    ISO_8859_15("ISO-8859-15"),
    ISO_2022_JP("ISO-2022-JP"),
    SHIFT_JIS("Shift_JIS"),
    EUC_JP("EUC-JP");

    private final String name;
    private static final Map<String, CharacterEncoding> nameLookup;

    private CharacterEncoding(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static CharacterEncoding of(String name) {
        return nameLookup.get(name);
    }

    static {
        nameLookup = new HashMap<String, CharacterEncoding>();
        for (CharacterEncoding characterEncoding : CharacterEncoding.values()) {
            nameLookup.put(characterEncoding.getName(), characterEncoding);
        }
    }
}

