/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging.as4.data;

import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.HashAlgorithm;

public enum SignatureEncryptionAlgorithm {
    RSA,
    ECDSA;


    public static SignatureEncryptionAlgorithm ofOptionValue(String optionValue) {
        switch (optionValue) {
            case "rsa-sha1": 
            case "rsa-sha256": 
            case "rsa-sha512": {
                return RSA;
            }
            case "ecdsa-sha1": 
            case "ecdsa-sha256": 
            case "ecdsa-sha512": {
                return ECDSA;
            }
        }
        return null;
    }

    public static String asOptionValue(HashAlgorithm hashAlgorithm, SignatureEncryptionAlgorithm signatureEncryptionAlgorithm) {
        if (hashAlgorithm != null && signatureEncryptionAlgorithm != null) {
            switch (signatureEncryptionAlgorithm.ordinal()) {
                case 0: {
                    switch (hashAlgorithm) {
                        case SHA1: {
                            return "rsa-sha1";
                        }
                        case SHA256: {
                            return "rsa-sha256";
                        }
                        case SHA512: {
                            return "rsa-sha512";
                        }
                    }
                }
                case 1: {
                    switch (hashAlgorithm) {
                        case SHA1: {
                            return "ecdsa-sha1";
                        }
                        case SHA256: {
                            return "ecdsa-sha256";
                        }
                        case SHA512: {
                            return "ecdsa-sha512";
                        }
                    }
                }
            }
        }
        return null;
    }
}

