/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging.as4.data;

import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.SignatureEncryptionAlgorithm;

public enum HashAlgorithm {
    SHA1,
    SHA256,
    SHA512;


    public static HashAlgorithm ofOptionValue(String optionValue) {
        switch (optionValue) {
            case "rsa-sha1": 
            case "ecdsa-sha1": {
                return SHA1;
            }
            case "rsa-sha256": 
            case "ecdsa-sha256": {
                return SHA256;
            }
            case "rsa-sha512": 
            case "ecdsa-sha512": {
                return SHA512;
            }
        }
        return null;
    }

    public static String asOptionValue(HashAlgorithm hashAlgorithm, SignatureEncryptionAlgorithm signatureEncryptionAlgorithm) {
        if (hashAlgorithm != null && signatureEncryptionAlgorithm != null) {
            switch (signatureEncryptionAlgorithm) {
                case RSA: {
                    switch (hashAlgorithm.ordinal()) {
                        case 0: {
                            return "rsa-sha1";
                        }
                        case 1: {
                            return "rsa-sha256";
                        }
                        case 2: {
                            return "rsa-sha512";
                        }
                    }
                    return null;
                }
                case ECDSA: {
                    switch (hashAlgorithm.ordinal()) {
                        case 0: {
                            return "ecdsa-sha1";
                        }
                        case 1: {
                            return "ecdsa-sha256";
                        }
                        case 2: {
                            return "ecdsa-sha512";
                        }
                    }
                    return null;
                }
            }
        }
        return null;
    }
}

