/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.integration;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.cpa.rules.IntegrationRuleDataDto;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.AdapterAccessConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="The integration settings of an agreement defines the parameters for the backend", name="Agreement.Integration")
public class IntegrationDto {
    @NotBlank
    @Schema(description="The default adapter for inbound messages. This adapter can be overwritten with a intgration rule.")
    @TrimmedField
    @AdapterAccessConstraint
    private String defaultAdapter;
    @Valid
    @NotNull
    @Schema(description="Integration rules allow to override the default adapter for incoming messages. For each rule you define a XPATH whose value will be compared with VALUE by OPERATOR. The result of a regular XPATH will depend on the XML content that is received. There are special XPATH-expressions are available, which will not depend on the XML content and are instead set during the processing: '!MessageId', '!ConversationId', '!MessageType', '!MessageVersion', '!SchemaSet', '!TestFlag' and '!LogInfo'.")
    private @Valid @NotNull List<@Valid IntegrationRuleDataDto> rules = new ArrayList<IntegrationRuleDataDto>();

    public String getDefaultAdapter() {
        return this.defaultAdapter;
    }

    public IntegrationDto setDefaultAdapter(String defaultAdapter) {
        this.defaultAdapter = defaultAdapter;
        return this;
    }

    public IntegrationDto addRule(IntegrationRuleDataDto ruleDataDto) {
        this.rules.add(ruleDataDto);
        return this;
    }

    public List<IntegrationRuleDataDto> getRules() {
        return this.rules;
    }

    public IntegrationDto setRules(List<IntegrationRuleDataDto> rules) {
        this.rules = rules;
        return this;
    }
}

