/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.cpa.AgreementDto;
import de.ponton.xmlpipe.rest.cpa.CommunicationsTuple;
import de.ponton.xmlpipe.rest.cpa.communication.CommunicationDtoFactory;
import de.ponton.xmlpipe.rest.cpa.communication.CommunicationDtoHolder;
import de.ponton.xmlpipe.rest.cpa.integration.IntegrationDtoFactory;
import de.ponton.xmlpipe.rest.cpa.integration.IntegrationDtoHolder;
import de.ponton.xmlpipe.rest.cpa.packaging.AS1PackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.AS1PackagingDtoFactory;
import de.ponton.xmlpipe.rest.cpa.packaging.AS2PackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.AS2PackagingDtoFactory;
import de.ponton.xmlpipe.rest.cpa.packaging.AS3PackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.AS3PackagingDtoFactory;
import de.ponton.xmlpipe.rest.cpa.packaging.AS4PackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.AS4PackagingDtoFactory;
import de.ponton.xmlpipe.rest.cpa.packaging.EbXml20PackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.EbXml20PackagingDtoFactory;
import de.ponton.xmlpipe.rest.cpa.packaging.PackagingDtoHolder;
import de.ponton.xmlpipe.rest.cpa.packaging.PlainPackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.PlainPackagingDtoFactory;
import de.ponton.xmlpipe.rest.cpa.processing.ProcessingDtoFactory;
import de.ponton.xmlpipe.rest.cpa.processing.ProcessingDtoHolder;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import de.pontonconsulting.xmlpipe.cp.DocumentTypeResolver;
import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PackageIdNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class AgreementDtoFactory
implements IDtoFactory<AgreementDto, Agreement> {
    private final Agreements agreements;
    private final IntegrationDtoFactory integrationDtoFactory;
    private final CommunicationDtoFactory communicationDtoFactory;
    private final AS1PackagingDtoFactory as1PackagingDtoFactory;
    private final AS2PackagingDtoFactory as2PackagingDtoFactory;
    private final AS3PackagingDtoFactory as3PackagingDtoFactory;
    private final AS4PackagingDtoFactory as4PackagingDtoFactory;
    private final EbXml20PackagingDtoFactory ebXml20PackagingDtoFactory;
    private final PlainPackagingDtoFactory plainPackagingDtoFactory;
    private final ProcessingDtoFactory processingDtoFactory;
    private final SchemataConfig schemataConfig;
    private final DocumentTypeResolver documentTypeResolver;
    private final DistributionConfigFinder distributionConfigFinder;

    public AgreementDtoFactory(Agreements agreements, IntegrationDtoFactory integrationDtoFactory, CommunicationDtoFactory communicationDtoFactory, AS1PackagingDtoFactory as1PackagingDtoFactory, AS2PackagingDtoFactory as2PackagingDtoFactory, AS3PackagingDtoFactory as3PackagingDtoFactory, AS4PackagingDtoFactory as4PackagingDtoFactory, EbXml20PackagingDtoFactory ebXml20PackagingDtoFactory, PlainPackagingDtoFactory plainPackagingDtoFactory, ProcessingDtoFactory processingDtoFactory, SchemataConfig schemataConfig, DocumentTypeResolver documentTypeResolver, DistributionConfigFinder distributionConfigFinder) {
        this.agreements = agreements;
        this.integrationDtoFactory = integrationDtoFactory;
        this.communicationDtoFactory = communicationDtoFactory;
        this.as1PackagingDtoFactory = as1PackagingDtoFactory;
        this.as2PackagingDtoFactory = as2PackagingDtoFactory;
        this.as3PackagingDtoFactory = as3PackagingDtoFactory;
        this.as4PackagingDtoFactory = as4PackagingDtoFactory;
        this.ebXml20PackagingDtoFactory = ebXml20PackagingDtoFactory;
        this.plainPackagingDtoFactory = plainPackagingDtoFactory;
        this.processingDtoFactory = processingDtoFactory;
        this.schemataConfig = schemataConfig;
        this.documentTypeResolver = documentTypeResolver;
        this.distributionConfigFinder = distributionConfigFinder;
    }

    @Override
    public AgreementDto create(Agreement agreement) {
        AgreementDto agreementDto = new AgreementDto();
        agreementDto.setId(agreement.getId()).setOwnPartnerId(agreement.getPartner1LocalId()).setCommunicationPartnerId(agreement.getPartner2LocalId()).setIntegration(this.integrationDtoFactory.create(agreement).getIntegrationDto()).setCommunication(this.communicationDtoFactory.create(agreement).getCommunicationDto());
        agreementDto.setTemplateId(Objects.requireNonNullElse(agreement.getTemplateId(), this.distributionConfigFinder.getDefaultAgreementTemplateId()));
        this.createMessageTypes(agreement, agreementDto);
        try {
            this.createPackaging(agreement, agreementDto);
            this.createProcessing(agreement, agreementDto);
        }
        catch (CommunicationNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        return agreementDto;
    }

    private void createMessageTypes(Agreement agreement, AgreementDto agreementDto) {
        ArrayList<String> messageTypeIds = new ArrayList<String>();
        agreement.getDocumentTypes().forEach(documentType -> {
            SchemaData schema = this.schemataConfig.getSchemaBySetTypeVersion(documentType.getSchemaSet(), documentType.getType(), documentType.getVersion());
            if (schema != null) {
                messageTypeIds.add(schema.getId());
            }
        });
        agreementDto.setMessageTypeIds(messageTypeIds);
    }

    private void createProcessing(Agreement agreement, AgreementDto agreementDto) throws CommunicationNotFoundException {
        Communication outbound = agreement.getCommunication(agreement.getPartner1LocalId(), agreement.getPartner2LocalId());
        Communication inbound = agreement.getCommunication(agreement.getPartner2LocalId(), agreement.getPartner1LocalId());
        agreementDto.setProcessing(this.processingDtoFactory.create(new CommunicationsTuple(inbound, outbound)).getProcessingDto());
    }

    private void createPackaging(Agreement agreement, AgreementDto agreementDto) throws CommunicationNotFoundException {
        Communication outbound = agreement.getCommunication(agreement.getPartner1LocalId(), agreement.getPartner2LocalId());
        Communication inbound = agreement.getCommunication(agreement.getPartner2LocalId(), agreement.getPartner1LocalId());
        CommunicationsTuple communicationsTuple = new CommunicationsTuple(inbound, outbound);
        if (!outbound.getPackagingId().equals(inbound.getPackagingId())) {
            throw new IllegalStateException("Inbound and Outbound packaging ID cannot be different");
        }
        switch (outbound.getPackagingId()) {
            case "AS1": {
                agreementDto.setPackager(this.as1PackagingDtoFactory.create(communicationsTuple).getPackagingDto());
                break;
            }
            case "AS2": {
                agreementDto.setPackager(this.as2PackagingDtoFactory.create(communicationsTuple).getPackagingDto());
                break;
            }
            case "AS3": {
                agreementDto.setPackager(this.as3PackagingDtoFactory.create(communicationsTuple).getPackagingDto());
                break;
            }
            case "AS4": {
                agreementDto.setPackager(this.as4PackagingDtoFactory.create(communicationsTuple).getPackagingDto());
                break;
            }
            case "EbXml20": {
                agreementDto.setPackager(this.ebXml20PackagingDtoFactory.create(communicationsTuple).getPackagingDto());
                break;
            }
            case "Plain": {
                agreementDto.setPackager(this.plainPackagingDtoFactory.create(communicationsTuple).getPackagingDto());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported packagingId: " + outbound.getPackagingId());
            }
        }
    }

    @Override
    public Agreement parse(AgreementDto agreementDto) {
        try {
            Agreement agreement = this.agreements.getAgreement(agreementDto.getId(), false);
            this.updateAgreementFromDTO(agreement, agreementDto);
            return agreement;
        }
        catch (AgreementException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    public void updateAgreementFromDTO(Agreement agreement, AgreementDto agreementDto) {
        try {
            if (!agreementDto.getOwnPartnerId().equals(agreement.getLocalPartnerId())) {
                throw new IllegalArgumentException("Cannot change local partner id.");
            }
            if (!agreementDto.getCommunicationPartnerId().equals(agreement.getRemotePartnerId())) {
                throw new IllegalArgumentException("Cannot change remote partner id.");
            }
            this.integrationDtoFactory.parse(new IntegrationDtoHolder(agreement, agreementDto.getIntegration()));
            this.communicationDtoFactory.parse(new CommunicationDtoHolder(agreement, agreementDto.getCommunication()));
            this.parsePackaging(agreement, agreementDto);
            this.parseProcessing(agreement, agreementDto);
            this.parseMessageTypes(agreementDto, agreement);
            agreement.initUrlValidity(true, true);
        }
        catch (CommunicationNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    private void parseMessageTypes(AgreementDto agreementDto, Agreement agreement) {
        ArrayList<DocumentType> documentTypes = new ArrayList<DocumentType>();
        agreementDto.getMessageTypeIds().forEach(messageTypeId -> {
            SchemaData schema = this.schemataConfig.findSchemaDataById((String)messageTypeId);
            if (schema == null) {
                throw new ResourceNotFoundException("No message type definition found for the id '" + messageTypeId + "'.");
            }
            DocumentType documentType = this.documentTypeResolver.resolveDocument(schema.getMessageType(), schema.getMessageVersion(), schema.getNamespace(), schema.getName(), schema.getSchemaSetName());
            if (documentType == null) {
                throw new ResourceNotFoundException("No message type definition found for the id '" + messageTypeId + "'.");
            }
            documentTypes.add(documentType);
        });
        Collections.sort(documentTypes);
        agreement.setDocumentTypes(documentTypes);
    }

    private void parseProcessing(Agreement agreement, AgreementDto agreementDto) throws CommunicationNotFoundException {
        Communication outbound = agreement.getCommunication(agreement.getPartner1LocalId(), agreement.getPartner2LocalId());
        Communication inbound = agreement.getCommunication(agreement.getPartner2LocalId(), agreement.getPartner1LocalId());
        this.processingDtoFactory.parse(new ProcessingDtoHolder(agreementDto.getProcessing(), new CommunicationsTuple(inbound, outbound)));
    }

    private void parsePackaging(Agreement agreement, AgreementDto agreementDto) throws CommunicationNotFoundException {
        Communication outbound = agreement.getCommunication(agreement.getPartner1LocalId(), agreement.getPartner2LocalId());
        Communication inbound = agreement.getCommunication(agreement.getPartner2LocalId(), agreement.getPartner1LocalId());
        CommunicationsTuple communicationsTuple = new CommunicationsTuple(inbound, outbound);
        outbound.setPackagingId(agreementDto.getPackager().getType());
        inbound.setPackagingId(agreementDto.getPackager().getType());
        if (!outbound.getPackagingId().equals(inbound.getPackagingId())) {
            throw new IllegalStateException("Inbound and Outbound packaging ID cannot be different");
        }
        switch (outbound.getPackagingId()) {
            case "AS1": {
                this.as1PackagingDtoFactory.parse(new PackagingDtoHolder<AS1PackagingDto>((AS1PackagingDto)agreementDto.getPackager(), communicationsTuple));
                break;
            }
            case "AS2": {
                this.as2PackagingDtoFactory.parse(new PackagingDtoHolder<AS2PackagingDto>((AS2PackagingDto)agreementDto.getPackager(), communicationsTuple));
                break;
            }
            case "AS3": {
                this.as3PackagingDtoFactory.parse(new PackagingDtoHolder<AS3PackagingDto>((AS3PackagingDto)agreementDto.getPackager(), communicationsTuple));
                break;
            }
            case "AS4": {
                this.as4PackagingDtoFactory.parse(new PackagingDtoHolder<AS4PackagingDto>((AS4PackagingDto)agreementDto.getPackager(), communicationsTuple));
                break;
            }
            case "EbXml20": {
                this.ebXml20PackagingDtoFactory.parse(new PackagingDtoHolder<EbXml20PackagingDto>((EbXml20PackagingDto)agreementDto.getPackager(), communicationsTuple));
                break;
            }
            case "Plain": {
                this.plainPackagingDtoFactory.parse(new PackagingDtoHolder<PlainPackagingDto>((PlainPackagingDto)agreementDto.getPackager(), communicationsTuple));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported packagingId: " + outbound.getPackagingId());
            }
        }
    }

    private void setPackaging(Communication communication, Option option) {
        try {
            communication.setPackagingOptionValue(option.getPath(), option.getValue(), option.getType());
            Arrays.stream(option.getSubOptions()).forEach(subOption -> this.setPackaging(communication, (Option)subOption));
        }
        catch (PackageIdNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

