/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.configuration;

import com.google.common.collect.ImmutableList;
import de.ponton.xmlpipe.rest.jwt.JwtAuthenticationEntryPoint;
import de.ponton.xmlpipe.rest.jwt.JwtRequestFilter;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.security.acegi.ClientRoleService;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import de.pontonconsulting.xmlpipe.security.acegi.PostAuthenticationChecks;
import de.pontonconsulting.xmlpipe.security.acegi.PreAuthenticationChecks;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationManagers;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@EnableWebSecurity
@Configuration
@EnableMethodSecurity(securedEnabled=true)
public class SpringSecurityConfig {
    private final String allowedOriginPatterns;
    @Value(value="${springdoc.swagger-ui.url}")
    private String swaggerUiConfigUrl;

    public SpringSecurityConfig(IMessengerProperties properties) {
        this.allowedOriginPatterns = properties.getProperty("ponton.messenger.gui-allowed-origin-patterns", "http://localhost,http://localhost:*,https://localhost,https://localhost:*");
    }

    @Bean
    MvcRequestMatcher.Builder mvc(HandlerMappingIntrospector introspector) {
        return new MvcRequestMatcher.Builder(introspector);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity httpSecurity, @Qualifier(value="corsConfigurationSource") CorsConfigurationSource corsConfigurationSource, JwtAuthenticationEntryPoint jwtAuthenticationEntryPoint, JwtRequestFilter jwtRequestFilter, MvcRequestMatcher.Builder mvc, ClientRoleService clientRoleService) throws Exception {
        return (SecurityFilterChain)httpSecurity.csrf(csrf -> csrf.disable()).cors(cors -> cors.configurationSource(corsConfigurationSource)).sessionManagement(sessionManagement -> sessionManagement.enableSessionUrlRewriting(false).sessionCreationPolicy(SessionCreationPolicy.STATELESS)).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)jwtAuthenticationEntryPoint)).headers(headers -> {
            headers.contentTypeOptions(Customizer.withDefaults());
            headers.xssProtection(Customizer.withDefaults());
            headers.contentSecurityPolicy(csp -> csp.policyDirectives("default-src 'self'; style-src 'self' 'unsafe-inline'"));
            headers.frameOptions(frameOptionsConfig -> frameOptionsConfig.deny());
        }).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{mvc.pattern("/partner/{partnerId}/**"), mvc.pattern("/registry/upload/{partnerId}"), mvc.pattern("/registry/synchronize/{partnerId}")})).access(AuthorizationManagers.allOf((AuthorizationManager[])new AuthorizationManager[]{AuthenticatedAuthorizationManager.authenticated(), (authentication, requestAuthorizationContext) -> new AuthorizationDecision(clientRoleService.verifyPartnerAccess((String)requestAuthorizationContext.getVariables().get("partnerId"), ((MessengerUser)((Authentication)authentication.get()).getPrincipal()).getUsername()))})).requestMatchers(new RequestMatcher[]{mvc.pattern("/agreements/{agreementId}/**")})).access(AuthorizationManagers.allOf((AuthorizationManager[])new AuthorizationManager[]{AuthenticatedAuthorizationManager.authenticated(), (authentication, requestAuthorizationContext) -> new AuthorizationDecision(clientRoleService.verifyAgreementAccess((String)requestAuthorizationContext.getVariables().get("agreementId"), ((MessengerUser)((Authentication)authentication.get()).getPrincipal()).getUsername()))})).requestMatchers(new RequestMatcher[]{mvc.pattern("/messagemonitor/deleteMessageFromQueue/{messageId}"), mvc.pattern("/messagemonitor/toggleMessageStatus/{messageId}"), mvc.pattern("/messagemonitor/resendFailedMessage/{messageId}"), mvc.pattern("/messagemonitor/resendSuccessfulMessage/{messageId}"), mvc.pattern("/messages/{messageId}/**")})).access(AuthorizationManagers.allOf((AuthorizationManager[])new AuthorizationManager[]{AuthenticatedAuthorizationManager.authenticated(), (authentication, requestAuthorizationContext) -> new AuthorizationDecision(clientRoleService.verifyMessageAccess((String)requestAuthorizationContext.getVariables().get("messageId"), ((MessengerUser)((Authentication)authentication.get()).getPrincipal()).getUsername()))})).requestMatchers(new RequestMatcher[]{mvc.pattern("/adapters/{adapterId}/**")})).access(AuthorizationManagers.allOf((AuthorizationManager[])new AuthorizationManager[]{AuthenticatedAuthorizationManager.authenticated(), (authentication, requestAuthorizationContext) -> new AuthorizationDecision(clientRoleService.verifyAdapterAccess((String)requestAuthorizationContext.getVariables().get("adapterId"), ((MessengerUser)((Authentication)authentication.get()).getPrincipal()).getUsername()))})).requestMatchers(new RequestMatcher[]{mvc.pattern("/health"), mvc.pattern("/authenticate"), mvc.pattern("/display")})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/swagger-ui/**"), AntPathRequestMatcher.antMatcher((String)"/v3/api-docs/**"), AntPathRequestMatcher.antMatcher((String)"/swagger-resources/**"), AntPathRequestMatcher.antMatcher((String)(this.swaggerUiConfigUrl + "/**"))})).permitAll().anyRequest()).authenticated()).logout(logout -> logout.disable()).addFilterBefore((Filter)jwtRequestFilter, UsernamePasswordAuthenticationFilter.class).build();
    }

    @Bean
    public AuthenticationEventPublisher authenticationEventPublisher() {
        return new DefaultAuthenticationEventPublisher();
    }

    @Bean
    public PreAuthenticationChecks preAuthenticationChecks() {
        return new PreAuthenticationChecks();
    }

    @Bean
    public PostAuthenticationChecks postAuthenticationChecks() {
        return new PostAuthenticationChecks();
    }

    @Bean
    public DaoAuthenticationProvider daoAuthenticationProvider(PasswordEncoder passwordEncoder, PontonUserDetailsServiceImpl pontonUserDetailsService, @Qualifier(value="preAuthenticationChecks") UserDetailsChecker preAuthenticationChecks, @Qualifier(value="postAuthenticationChecks") UserDetailsChecker postAuthenticationChecks) {
        DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
        daoAuthenticationProvider.setPasswordEncoder(passwordEncoder);
        daoAuthenticationProvider.setUserDetailsService((UserDetailsService)pontonUserDetailsService);
        daoAuthenticationProvider.setPreAuthenticationChecks(preAuthenticationChecks);
        daoAuthenticationProvider.setPostAuthenticationChecks(postAuthenticationChecks);
        return daoAuthenticationProvider;
    }

    @Bean
    public ProviderManager authenticationManager(AuthenticationEventPublisher eventPublisher, AuthenticationProvider daoAuthenticationProvider) {
        ProviderManager providerManager = new ProviderManager(new AuthenticationProvider[]{daoAuthenticationProvider});
        providerManager.setEraseCredentialsAfterAuthentication(false);
        providerManager.setAuthenticationEventPublisher(eventPublisher);
        return providerManager;
    }

    @Autowired
    public void initialize(AuthenticationManagerBuilder builder, PontonUserDetailsServiceImpl pontonUserDetailsService, PasswordEncoder passwordEncoder) throws Exception {
        builder.userDetailsService((UserDetailsService)pontonUserDetailsService).passwordEncoder(passwordEncoder);
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setAllowedOriginPatterns(Arrays.asList(this.allowedOriginPatterns.split(",")));
        configuration.setAllowedMethods(List.of("HEAD", "GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"));
        configuration.setAllowedHeaders((List)ImmutableList.of((Object)"Authorization", (Object)"Cache-Control", (Object)"Content-Type"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }
}

