/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.configuration;

import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.listener.AbstractMessageReceiver;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.properties.SwaggerUiOAuthProperties;
import org.springdoc.webmvc.core.configuration.SpringDocWebMvcConfiguration;
import org.springdoc.webmvc.ui.SwaggerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebMvc
@ComponentScan(basePackages={"org.springdoc"})
@Import(value={SpringDocConfiguration.class, SpringDocWebMvcConfiguration.class, SwaggerConfig.class, SwaggerUiConfigProperties.class, SwaggerUiOAuthProperties.class, JacksonAutoConfiguration.class})
@PropertySource(value={"classpath:springDoc.properties"})
public class SpringDocConfig
implements WebMvcConfigurer {
    @Bean
    public OpenAPI springDocMessengerOpenAPI(IMessengerProperties properties) {
        PrimitiveType.enablePartialTime();
        OpenAPI openAPI = new OpenAPI().specVersion(SpecVersion.V30).info(new Info().title("Messenger REST API").description("Messenger Name: " + AbstractMessageReceiver.MESSENGER_NAME).version(Constants.getXP_VERSION())).components(new Components().addSecuritySchemes("bearer-key", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT"))).addSecurityItem(new SecurityRequirement().addList("bearer-key"));
        String serversAsString = properties.getProperty("ponton.messenger.swagger-servers", "/api");
        openAPI.setServers(Arrays.stream(serversAsString.split(",")).map(url -> new Server().url(url)).collect(Collectors.toList()));
        return openAPI;
    }

    @RestController
    @RequestMapping(value={"/swagger-ui"})
    @Hidden
    @PropertySource(value={"classpath:springDoc.properties"})
    private static class SpringDocController {
        @Value(value="${springdoc.swagger-ui.config-url}")
        private String swaggerUiConfigUrl;

        private SpringDocController() {
        }

        @GetMapping
        public void redirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.sendRedirect(request.getServletPath() + "/swagger-ui/index.html?configUrl=" + this.swaggerUiConfigUrl);
        }
    }
}

