/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.authentication;

import de.ponton.xmlpipe.rest.RequestUtils;
import de.ponton.xmlpipe.rest.authentication.JwtRequest;
import de.ponton.xmlpipe.rest.authentication.JwtResponse;
import de.ponton.xmlpipe.rest.authentication.PasswordReuseException;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.jwt.JwtTokenUtil;
import de.ponton.xmlpipe.rest.jwt.TokenBlacklistService;
import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerUserDAO;
import de.pontonconsulting.xmlpipe.security.InvalidTotpException;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import de.pontonconsulting.xmlpipe.security.acegi.UserWith2faCredentialsExpiredException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.Authentication;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Validated
public class AuthenticationController {
    private static final Logger AUDIT = LogManager.getLogger((String)("Audit." + AuthenticationController.class.getName()));
    public static final String DOCUMENTATION_TAG = "Authentication";
    private final AuthenticationManager authenticationManager;
    private final ExceptionDtoFactory exceptionDtoFactory;
    private final JwtTokenUtil jwtTokenUtil;
    private final PontonUserDetailsServiceImpl userDetailsService;
    private final MessengerUserDAO messengerUserDAO;
    private final TokenBlacklistService tokenBlacklistService;

    public AuthenticationController(AuthenticationManager authenticationManager, JwtTokenUtil jwtTokenUtil, PontonUserDetailsServiceImpl userDetailsService, MessengerUserDAO messengerUserDAO, TokenBlacklistService tokenBlacklistService, ExceptionDtoFactory exceptionDtoFactory) {
        this.authenticationManager = authenticationManager;
        this.jwtTokenUtil = jwtTokenUtil;
        this.userDetailsService = userDetailsService;
        this.messengerUserDAO = messengerUserDAO;
        this.tokenBlacklistService = tokenBlacklistService;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @Operation(summary="Authenticate a user", description="After successful login a bearer token is returned for authenticated api operations.", tags={"Authentication"})
    @SecurityRequirements
    @RequestMapping(value={"/authenticate"}, method={RequestMethod.POST})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(examples={@ExampleObject(value="{ \"username\": \"xpadmin\", \"password\": \"xppass\" }")})})
    public ResponseEntity<JwtResponse> createAuthenticationToken(@RequestBody @Valid JwtRequest authenticationRequest, HttpServletRequest request) throws Exception {
        try {
            this.authenticate(authenticationRequest.getUsername(), authenticationRequest.getPassword());
            this.checkSecondFactor(authenticationRequest.getUsername(), authenticationRequest.getTotp());
        }
        catch (CredentialsExpiredException e) {
            if (StringUtils.isNotBlank((CharSequence)authenticationRequest.getNewPassword())) {
                this.checkSecondFactor(authenticationRequest.getUsername(), authenticationRequest.getTotp());
                if (!this.messengerUserDAO.isPasswordAlreadyUsed(authenticationRequest.getUsername(), authenticationRequest.getNewPassword())) {
                    this.changePassword(authenticationRequest.getUsername(), authenticationRequest.getNewPassword());
                }
                throw new PasswordReuseException("newPassword: Password has already been used. Please choose a different one.");
            }
            if (this.userDetailsService.isTotpEnabled(authenticationRequest.getUsername())) {
                throw new UserWith2faCredentialsExpiredException(e.getMessage());
            }
            throw e;
        }
        MessengerUser userDetails = this.userDetailsService.loadUserByUsername(authenticationRequest.getUsername());
        String token = this.jwtTokenUtil.generateToken(userDetails, request, new Date());
        boolean twoFactorSetupNeeded = this.userDetailsService.isTwoFactorsEnforced() && !this.userDetailsService.isTotpEnabled(authenticationRequest.getUsername());
        return ResponseEntity.ok((Object)new JwtResponse(token, authenticationRequest.getUsername(), twoFactorSetupNeeded));
    }

    private void changePassword(String username, String newPassword) throws Exception {
        this.userDetailsService.setPasswordForUser(username, newPassword, false);
    }

    @Operation(summary="Get a new JSON Web Token", description="before a JSON Web Token expires, a new token can be fetched from this endpoint. This requires a still valid JSON Web Token", tags={"Authentication"})
    @RequestMapping(value={"/refreshToken"}, method={RequestMethod.GET})
    public ResponseEntity<JwtResponse> refreshAuthenticationToken(HttpServletRequest httpServletRequest) {
        Principal user = httpServletRequest.getUserPrincipal();
        MessengerUser userDetails = this.userDetailsService.loadUserByUsername(user.getName());
        String token = this.jwtTokenUtil.generateToken(userDetails, httpServletRequest, new Date());
        AUDIT.info("{'{}', '{}' -> '{}'} user token successfully refreshed.", (Object)httpServletRequest.getUserPrincipal().getName(), (Object)httpServletRequest.getRemoteAddr(), (Object)RequestUtils.getLocalAddress());
        return ResponseEntity.ok((Object)new JwtResponse(token, user.getName(), false));
    }

    @Operation(summary="Logout and invalidate JWT Token", description="after this method is call, the token will be blacklisted until messenger restart", tags={"Authentication"})
    @RequestMapping(value={"/logout"}, method={RequestMethod.GET})
    public ResponseEntity<Void> logout(HttpServletRequest httpServletRequest) {
        String requestTokenHeader = httpServletRequest.getHeader("Authorization");
        this.tokenBlacklistService.blacklistToken(requestTokenHeader.substring(7));
        AUDIT.info("{'{}', '{}' -> '{}'} user successfully logged out.", (Object)httpServletRequest.getUserPrincipal().getName(), (Object)httpServletRequest.getRemoteAddr(), (Object)RequestUtils.getLocalAddress());
        return ResponseEntity.ok().build();
    }

    private void authenticate(String username, String password) throws AccountStatusException {
        Authentication authentication = this.userDetailsService.createAuthenticationToken(username, password);
        this.authenticationManager.authenticate(authentication);
    }

    private void checkSecondFactor(String username, String totp) {
        if (this.userDetailsService.isTotpEnabled(username)) {
            if (totp == null) {
                throw new InvalidTotpException("2FA is enabled. Please provide TOTP");
            }
            if (!this.userDetailsService.isValidTotp(username, totp)) {
                throw new InvalidTotpException("TOTP not valid");
            }
        }
    }
}

