/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.adapter;

import de.ponton.xmlpipe.rest.adapter.AdapterDto;
import de.ponton.xmlpipe.rest.adapter.AdapterDtoFactory;
import de.ponton.xmlpipe.rest.adapter.AdapterInfoService;
import de.ponton.xmlpipe.rest.adapter.AdapterStatusDto;
import de.ponton.xmlpipe.rest.adapter.NotInternalAdapterConstraint;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.message.MessageController;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessException;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.security.acegi.ClientRoleService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adapters"})
@Validated
public class AdapterController {
    public static final String DOCUMENTATION_TAG_ADAPTER = "Adapter";
    private static final Logger LOG = LogManager.getLogger((String)("Adapter." + MessageController.class.getName()));
    private final AdapterInfoService adapterInfoService;
    private final ExceptionDtoFactory exceptionDtoFactory;
    private final AdapterDtoFactory adapterDtoFactory;
    private final ClientRoleService clientRoleService;

    public AdapterController(AdapterInfoService adapterInfoService, ExceptionDtoFactory exceptionDtoFactory, AdapterDtoFactory adapterDtoFactory, ClientRoleService clientRoleService) {
        this.adapterInfoService = adapterInfoService;
        this.exceptionDtoFactory = exceptionDtoFactory;
        this.adapterDtoFactory = adapterDtoFactory;
        this.clientRoleService = clientRoleService;
    }

    @GetMapping(value={"/{adapterId}"})
    @Secured(value={"ADAPTERS_GET"})
    @Operation(summary="Get adapter information", description="permission:ADAPTERS_GET<br><br>Get information for the adapter identified by the given adapter-id", tags={"Adapter"})
    public ResponseEntity<AdapterDto> getAdapter(@PathVariable String adapterId) {
        return ResponseEntity.ok((Object)this.adapterDtoFactory.create(this.adapterInfoService.getAdapter(adapterId)));
    }

    @GetMapping(value={"/{adapterId}/status"})
    @Secured(value={"ADAPTERS_STATUS_GET"})
    @Schema(description="The status of the adapter in readable text form")
    @Operation(summary="Get adapter status", description="permission:ADAPTERS_STATUS_GET<br><br>The status of the adapter in readable text form by the given adapter-id, uses adapter configured timeout", tags={"Adapter"})
    public ResponseEntity<AdapterStatusDto> getAdapterStatus(@PathVariable String adapterId) throws AdapterAccessException {
        boolean status = this.adapterInfoService.getAdapterIsSelfCheckOk(adapterId);
        String message = status ? this.adapterInfoService.getAdapterStatusMessage(adapterId) : "not connected";
        return ResponseEntity.ok((Object)new AdapterStatusDto(status ? AdapterStatusDto.Status.OK : AdapterStatusDto.Status.DOWN, message));
    }

    @GetMapping
    @Secured(value={"ADAPTERS_GET"})
    @Operation(summary="Get all adapter", description="permission:ADAPTERS_GET<br><br>Get a list of adapters with their information", tags={"Adapter"})
    public ResponseEntity<List<AdapterDto>> getAllAdapters(Principal principal) {
        return ResponseEntity.ok(this.adapterInfoService.getAllAdapters().stream().filter(adapterInfo -> this.clientRoleService.verifyAdapterAccess(adapterInfo.getId(), principal.getName())).map(this.adapterDtoFactory::create).collect(Collectors.toList()));
    }

    @GetMapping(value={"/archive"})
    @Secured(value={"ADAPTERS_GET"})
    @Operation(summary="Get all adapter", description="permission:ADAPTERS_GET<br><br>Get a list of adapters with their information", tags={"Adapter"})
    public ResponseEntity<List<AdapterDto>> getArchiveAdapters(Principal principal) {
        return ResponseEntity.ok(this.adapterInfoService.getArchiveAdapters().stream().filter(adapterInfo -> this.clientRoleService.verifyAdapterAccess(adapterInfo.getId(), principal.getName())).map(this.adapterDtoFactory::create).collect(Collectors.toList()));
    }

    @DeleteMapping(value={"/{adapterId}"})
    @Secured(value={"ADAPTERS_DELETE"})
    @Operation(summary="Delete a adapter", description="permission:ADAPTERS_DELETE<br><br>Delete a adapter for a given adapter-id", tags={"Adapter"})
    @Validated
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteAdapter(@PathVariable @Valid @NotInternalAdapterConstraint String adapterId) throws DbException {
        boolean adapterDeleted = this.adapterInfoService.deleteAdapter(adapterId);
        if (!adapterDeleted) {
            throw new ResourceNotFoundException(String.format("Adapter not found. [AdapterId=%s]", adapterId));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleNotFound(Exception e) {
        LOG.error("Adapter not found, {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={AdapterAccessException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<String> handleAdapterAccessException(Exception e) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)("No adapter info available: " + e.getMessage()));
    }
}

