/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.ponton.xmlpipe.queue.IQueueMessage;
import de.ponton.xmlpipe.queue.MultipleQueue;
import de.ponton.xmlpipe.queue.QueueMessageSendingTaskFactory;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueueMessageConsumer
implements Runnable {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final MultipleQueue multipleQueue;
    private final ThreadPoolExecutor executorService;
    private final QueueMessageSendingTaskFactory queueMessageSendingTaskFactory;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final AtomicBoolean isWaiting = new AtomicBoolean(false);
    private final Supplier<Boolean> maintenanceChecker;
    private final Supplier<Boolean> databaseIsAvailableChecker;
    private final Supplier<Long> scanInterval;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final int maxThreads;
    private final Map<Long, Future<Void>> runningThreads = new ConcurrentHashMap<Long, Future<Void>>();

    public QueueMessageConsumer(MultipleQueue multipleQueue, ThreadPoolExecutor executorService, int maxThreads, QueueMessageSendingTaskFactory queueMessageSendingTaskFactory, Supplier<Long> scanInterval, Supplier<Boolean> maintenanceChecker, Supplier<Boolean> databaseIsAvailableChecker) {
        this.multipleQueue = multipleQueue;
        this.maintenanceChecker = maintenanceChecker;
        this.databaseIsAvailableChecker = databaseIsAvailableChecker;
        this.scanInterval = scanInterval;
        multipleQueue.setListener(this);
        this.queueMessageSendingTaskFactory = queueMessageSendingTaskFactory;
        this.executorService = executorService;
        this.maxThreads = maxThreads;
    }

    private boolean sendMessage() {
        this.log.trace("Trying to get a next message for delivery.");
        if (this.hasCapacity()) {
            Optional<IQueueMessage> nextMessage = this.multipleQueue.getNextMessage();
            if (nextMessage.isPresent()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("[{}] Scheduling delivery task.", (Object)nextMessage.get().getUniqueId());
                }
                CountDownLatch countDownLatch = new CountDownLatch(1);
                try {
                    Future<Void> task = this.executorService.submit(() -> {
                        try {
                            countDownLatch.await();
                            Void void_ = (Void)this.queueMessageSendingTaskFactory.createTask((IQueueMessage)nextMessage.get()).call();
                            return void_;
                        }
                        finally {
                            this.afterTask((IQueueMessage)nextMessage.get());
                        }
                    });
                    this.beforeTask(nextMessage.get(), task);
                    countDownLatch.countDown();
                }
                catch (Throwable e) {
                    this.log.error("Error occurs while starting a delivery task.", e);
                    throw e;
                }
                return true;
            }
            this.log.trace("No message available for delivery.");
        }
        return false;
    }

    private void beforeTask(IQueueMessage queueMessage, Future<Void> task) {
        queueMessage.setNextTry();
        queueMessage.deliveryStarted();
        this.runningThreads.put(queueMessage.getUniqueId(), task);
    }

    private void afterTask(IQueueMessage queueMessage) {
        this.runningThreads.remove(queueMessage.getUniqueId());
        queueMessage.deliveryFinished();
        this.wakeUp();
    }

    private boolean hasCapacity() {
        this.log.trace("{}: ActiveThreadCount: {}, MaximumPoolSize: {}", (Object)this.executorService.toString(), (Object)this.getActiveThreadCount(), (Object)this.maxThreads);
        return this.getActiveThreadCount() < this.maxThreads;
    }

    public int getActiveThreadCount() {
        return this.runningThreads.size();
    }

    public void wakeUp() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isWaiting() {
        return this.isWaiting.get();
    }

    @Override
    public void run() {
        while (this.isRunning.get()) {
            Thread.interrupted();
            try {
                this.waitAMoment();
                this.isWaiting.set(false);
                while (this.isRunning.get() && !this.maintenanceChecker.get().booleanValue() && this.databaseIsAvailableChecker.get().booleanValue()) {
                    if (this.sendMessage()) continue;
                }
            }
            catch (Exception e) {
                this.log.error("unexpected exception occurred", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAMoment() {
        long time = this.scanInterval.get();
        this.lock.lock();
        try {
            this.isWaiting.set(true);
            this.condition.await(time, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
        this.isRunning.set(false);
        this.wakeUp();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean interruptDelivery(long messageDataId) {
        Future<Void> task = this.runningThreads.get(messageDataId);
        if (task != null) {
            this.log.info("[{}] Try to interrupt message delivery.", (Object)messageDataId);
            task.cancel(true);
            return true;
        }
        return false;
    }
}

