/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerActivation;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.OutboundQueueMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerActivationDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.OutboundQueueMessageDAO;
import java.time.OffsetDateTime;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutboundQueueExpiredMessagesTask {
    private static final Logger log = LogManager.getLogger((String)"Messenger.OutboundQueueExpiredMessagesTask");
    private final OutboundQueueMessageDAO outboundQueueMessageDAO;
    private final MessengerActivationDAO messengerActivationDAO;
    private final ReferenceDateTask referenceDateTask;

    public OutboundQueueExpiredMessagesTask(OutboundQueueMessageDAO outboundQueueMessageDAO, MessengerActivationDAO messengerActivationDAO, ReferenceDateTask referenceDateTask) {
        this.outboundQueueMessageDAO = outboundQueueMessageDAO;
        this.messengerActivationDAO = messengerActivationDAO;
        this.referenceDateTask = referenceDateTask;
    }

    public void run() {
        log.debug("Starting OutboundQueueExpiredMessagesTask");
        try {
            OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
            List<Integer> stoppedMessengerIds = this.messengerActivationDAO.loadAllMessengerActivations().stream().filter(messengerActivation -> messengerActivation.getLastHeartBeat().plusMinutes(2L).isBefore(now)).map(MessengerActivation::getMessengerId).toList();
            List<OutboundQueueMessage> allExpiredMessages = this.outboundQueueMessageDAO.getExpiredMessages(stoppedMessengerIds);
            for (OutboundQueueMessage message : allExpiredMessages) {
                log.info("Found OutboundQueueRecord 'IN TRANSFER' with expired TTL and start sendMessageThread for messageId: {}", (Object)message.getMessageId());
                this.outboundQueueMessageDAO.resetTransmissionState(message.getMessageId());
            }
        }
        catch (Exception e) {
            log.fatal("Can't load expired messages 'IN TRANSFER' to init OutboundQueueExpiredMessagesTask: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Can't load expired messages 'IN TRANSFER' to init OutboundQueueExpiredMessagesTask", e);
        }
        log.debug("Finished OutboundQueueExpiredMessagesTask");
    }
}

