/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.metrics.XPMetrics;
import de.ponton.xmlpipe.queue.XpMessageLoader;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.common.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.Util;
import de.pontonconsulting.xmlpipe.adapter.TransportURLType;
import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.OutboundQueueException;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.SendToListenerResult;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.OutboundQueueMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.database.tables.OutboundQueueMessageDAO;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.IPackagingManager;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.FileSystemUtils;

public class OutboundQueue {
    public static String PROTOCOL_INTERNAL = "Internal";
    public static String PLACEHOLDER_PREFIX = "%";
    public static String PLACEHOLDER_POSTFIX = "%";
    public static String ORIGINAL_FILENAME = "original_filename";
    public static String TIMESTAMP = "timestamp";
    public static String SCHEMA_SET = "schema_set";
    public static String MESSAGE_TYPE = "message_type";
    public static String MESSAGE_VERSION = "message_version";
    public static String RECEIVER = "receiver";
    public static String SENDER = "sender";
    public static String CONVERSATION_ID = "conversation_id";
    public static String MESSAGE_ID = "message_id";
    public static String DATABASE_ID = "database_id";
    public static String DEFAULT_EXTENSION = "default_extension";
    public static String ORIGINAL_EXTENSION = "original_extension";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final OutboundQueueMessageDAO outboundQueueMessageDAO;
    private final IFolders folders;
    private final IPackagingManager packagingManager;
    private final MessengerLog messengerLog;
    private final MessengerConfig messengerConfig;
    private final ReferenceDateTask referenceDateTask;
    private final MessageDAO messageDAO;
    private final ArchiveProcessor archiveProcessor;
    private final XpMessageLoader xpMessageLoader;
    private final SchemataConfig schemataConfig;
    private final MessageWorkDataDAO messageWorkDataDAO;
    private Function<Long, Boolean> messageInTransferCanceller;
    private final MetricsService metricsService;

    public OutboundQueue(OutboundQueueMessageDAO outboundQueueMessageDAO, IFolders folders, IPackagingManager packagingManager, MessengerLog messengerLog, MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask, MessageDAO messageDAO, ArchiveProcessor archiveProcessor, XpMessageLoader xpMessageLoader, SchemataConfig schemataConfig, MessageWorkDataDAO messageWorkDataDAO, MetricsService metricsService) {
        this.outboundQueueMessageDAO = outboundQueueMessageDAO;
        this.folders = folders;
        this.packagingManager = packagingManager;
        this.messengerLog = messengerLog;
        this.messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
        this.messageDAO = messageDAO;
        this.archiveProcessor = archiveProcessor;
        this.xpMessageLoader = xpMessageLoader;
        this.schemataConfig = schemataConfig;
        this.messageWorkDataDAO = messageWorkDataDAO;
        this.metricsService = metricsService;
    }

    public boolean deleteFromOutboundQueue(long messageDataID) throws DbException {
        this.deleteMessageWorkFolder(messageDataID);
        boolean finished = this.outboundQueueMessageDAO.finishMessage(messageDataID);
        if (finished) {
            this.log.debug("Finished OutboundMessage");
        }
        return finished;
    }

    public Optional<OutboundQueueMessage> removeFromOutboundQueue(long messageDataID) throws DbException {
        this.deleteMessageWorkFolder(messageDataID);
        return Optional.ofNullable(this.outboundQueueMessageDAO.finishMessageWithResult(messageDataID));
    }

    public boolean cancelIfInTransfer(long messageDataID) {
        if (Objects.nonNull(this.messageInTransferCanceller)) {
            return this.messageInTransferCanceller.apply(messageDataID);
        }
        this.log.warn("Can not cancel message, because no 'messageInTransferCanceller' is injected");
        return false;
    }

    public SendToListenerResult deliverMessageToPartner(XpMessage xpMessage) {
        long databaseId = xpMessage.getDatabaseId();
        try {
            File work = new File(this.folders.getWorkOutboundFolder(), String.valueOf(databaseId));
            work.mkdirs();
            File messageFile = new File(work, "xp_message.dat");
            File messageHeaderFile = new File(work, "xp_message_header.dat");
            List<Integer> retryIntervals = xpMessage.getCommunication().getRetryIntervals();
            int maxNumberOfRetries = xpMessage.getCommunication().getNumberOfRetries();
            if (this.isPing(xpMessage)) {
                xpMessage.setAckRequested(true);
                if (retryIntervals.isEmpty()) {
                    this.log.warn("Partner agreement retry interval is empty, faulty configuration. Taking a default of 20 seconds.");
                    retryIntervals = List.of(Integer.valueOf(20));
                } else {
                    retryIntervals = List.of(retryIntervals.getFirst());
                }
                maxNumberOfRetries = 0;
            }
            BasePackager packager = this.packagingManager.getPackager(xpMessage.getMessagePackaging());
            if (!xpMessage.isPackaged()) {
                this.prePackageMessage(xpMessage, packager, messageFile, messageHeaderFile);
            }
            Long timeToLive = null;
            if (!this.messengerConfig.isTtlOnFirstSend()) {
                timeToLive = this.forcePackageFinalizing(xpMessage, packager, work, retryIntervals, maxNumberOfRetries);
            }
            int priority = this.getPriority(xpMessage);
            this.updateDestinationUrl(xpMessage);
            this.moveMessageFileToDB(xpMessage);
            this.xpMessageLoader.saveXpMessage(xpMessage);
            this.outboundQueueMessageDAO.enqueue(xpMessage, timeToLive, priority);
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_QUEUE_ADD_RATE).mark();
            this.log.debug("Enqueued OutboundMessage {} [timeToLive={} / priority={}]", (Object)xpMessage.getMessageId(), (Object)(timeToLive == null ? null : new Date(timeToLive)), (Object)priority);
        }
        catch (ActivationException | DbException | PackagingException pe) {
            this.log.error("Could not package the message due to a {}", (Object)pe.toString(), (Object)(this.log.isDebugEnabled() ? pe : null));
            this.messengerLog.log2db(522, databaseId, pe.getMessage());
            this.setStatusToFailedAndMoveFilesToFailedArchive(xpMessage);
            return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_PACKAGE_MESSAGE, xpMessage, (Exception)pe);
        }
        catch (Exception pe) {
            this.log.error("Could not package the message as {} .. ", (Object)xpMessage.getMessagePackaging(), (Object)pe);
            this.messengerLog.log2db(522, databaseId, xpMessage.getMessagePackaging());
            this.setStatusToFailedAndMoveFilesToFailedArchive(xpMessage);
            return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_PACKAGE_MESSAGE, xpMessage, pe);
        }
        return new SendToListenerResult(SendToListenerResult.Result.MSG_SUCCESSFULLY_SENT, xpMessage);
    }

    private void moveMessageFileToDB(XpMessage xpMessage) throws DbException {
        this.messageWorkDataDAO.uploadDirectoryToDB(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
        this.deleteMessageWorkFolder(xpMessage.getDatabaseId());
    }

    private void deleteMessageWorkFolder(long messageDataID) {
        File messageWorkDirectory = new File(this.folders.getWorkOutboundFolder(), String.valueOf(messageDataID));
        FileSystemUtils.deleteRecursively((File)messageWorkDirectory);
        this.log.debug("Cleaned up outbound directory for message with id {}", (Object)messageDataID);
    }

    private Long forcePackageFinalizing(XpMessage xpMessage, BasePackager packager, File work, List<Integer> retryIntervals, int numberOfRetries) throws OutboundQueueException {
        Long timeToLive = null;
        long timestamp = this.referenceDateTask.getReferenceCurrentTimeMillis();
        String ttlAsString = xpMessage.getProcessingDirective("TTL");
        if (ttlAsString != null) {
            this.log.debug("Found processing directive 'TTL' with the value '{}'.", (Object)ttlAsString);
            try {
                timeToLive = Long.parseLong(ttlAsString);
            }
            catch (NumberFormatException e) {
                this.log.warn("Processing directive 'TTL' doesn't have a valid format: '{}'. The processing directive will be ignored.", (Object)ttlAsString);
            }
        }
        if (Objects.isNull(timeToLive)) {
            timeToLive = timestamp + Util.calculateTTL(numberOfRetries, retryIntervals) * 1000L;
        }
        this.log.debug("Setting time to live for message '{}' to: {}", (Object)xpMessage.getMessageId(), (Object)new Date(timeToLive));
        try {
            Communication communication = xpMessage.getCommunication();
            packager.storePostqueueingFormat(communication, timeToLive, work);
            this.log.debug("packaging completed");
        }
        catch (Exception e) {
            this.log.error("Could not package message: ", (Throwable)e);
            throw new OutboundQueueException(e);
        }
        return timeToLive;
    }

    private void setStatusToFailedAndMoveFilesToFailedArchive(XpMessage xpMessage) {
        try {
            this.moveMessageFileToDB(xpMessage);
        }
        catch (DbException e) {
            this.log.error("Could not move message files to db: {}", (Object)e.toString());
        }
        this.archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
        this.messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
    }

    private String buildDestinationUrl(XpMessage xpMessage) {
        String destinationUrl = xpMessage.getDestinationUrl();
        String originalFullFilename = xpMessage.getProcessingDirective("OriginalFilename");
        if (StringUtils.isNotBlank((CharSequence)originalFullFilename)) {
            destinationUrl = this.replace(destinationUrl, ORIGINAL_FILENAME, FilenameUtils.getBaseName((String)originalFullFilename));
            destinationUrl = this.replace(destinationUrl, ORIGINAL_EXTENSION, FilenameUtils.getExtension((String)originalFullFilename));
        }
        destinationUrl = this.replace(destinationUrl, TIMESTAMP, String.valueOf(this.referenceDateTask.getReferenceCurrentTimeMillis()));
        destinationUrl = this.replace(destinationUrl, SCHEMA_SET, xpMessage.getSchemaSet());
        destinationUrl = this.replace(destinationUrl, MESSAGE_TYPE, xpMessage.getMessageType());
        destinationUrl = this.replace(destinationUrl, MESSAGE_VERSION, xpMessage.getMessageVersion());
        destinationUrl = this.replace(destinationUrl, RECEIVER, xpMessage.getReceiverInternalId());
        destinationUrl = this.replace(destinationUrl, SENDER, xpMessage.getSenderInternalId());
        destinationUrl = this.replace(destinationUrl, CONVERSATION_ID, xpMessage.getConversationId());
        destinationUrl = this.replace(destinationUrl, MESSAGE_ID, xpMessage.getMessageId());
        destinationUrl = this.replace(destinationUrl, DATABASE_ID, String.valueOf(xpMessage.getDatabaseId()));
        destinationUrl = this.replace(destinationUrl, DEFAULT_EXTENSION, FilenameUtils.getExtension((String)MimeTypeMapper.getExtension(xpMessage.getCurrentContentType())));
        return destinationUrl;
    }

    private String replace(String destinationUrl, String placeholder, String value) {
        if (StringUtils.isBlank((CharSequence)destinationUrl) || StringUtils.isBlank((CharSequence)value)) {
            return destinationUrl;
        }
        String fullPlaceholder = PLACEHOLDER_PREFIX + placeholder + PLACEHOLDER_POSTFIX;
        return destinationUrl.replaceAll(fullPlaceholder, value);
    }

    private void updateDestinationUrl(XpMessage xpMessage) {
        String destinationUrl = this.buildDestinationUrl(xpMessage);
        if (!xpMessage.getDestinationUrl().equals(destinationUrl)) {
            xpMessage.setTransportURLType(TransportURLType.FIXED);
            this.log.info("Updating URL from '{}' to '{}'.", (Object)xpMessage.getDestinationUrl(), (Object)destinationUrl);
            xpMessage.setDestinationUrl(destinationUrl);
        }
        TransportURLType transportURL = xpMessage.getTransportURLType();
        switch (transportURL) {
            case PRIMARY: 
            case FALLBACK: 
            case DYNAMIC: {
                String newUrl = transportURL.name();
                this.log.debug("Updating URL from '{}' to '{}'.", (Object)xpMessage.getDestinationUrl(), (Object)newUrl);
                xpMessage.setDestinationUrl(newUrl);
                break;
            }
        }
    }

    private void prePackageMessage(XpMessage xpMessage, BasePackager packager, File messageFile, File messageHeaderFile) throws PackagingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("starting the packaging ({})", (Object)xpMessage.getMessagePackaging());
        }
        packager.storePrequeueingFormat(xpMessage, messageFile, messageHeaderFile);
        if (this.log.isDebugEnabled()) {
            this.log.debug("prepackaging completed");
        }
        this.messengerLog.log2db(79, xpMessage.getDatabaseId(), xpMessage.getMessagePackaging());
    }

    private boolean isPing(XpMessage xpMessage) {
        return "ponton".equals(xpMessage.getSchemaSet()) && ("PING".equals(xpMessage.getMessageType()) || "StatusRequest".equals(xpMessage.getMessageType()) || "CertUpdateRequest".equals(xpMessage.getMessageType()));
    }

    private boolean isPong(XpMessage xpMessage) {
        return "PONG".equals(xpMessage.getMessageType());
    }

    private boolean isSignal(XpMessage xpMessage) {
        return "ponton".equals(xpMessage.getSchemaSet());
    }

    int getPriority(XpMessage xpMessage) {
        int priority = 0;
        if (this.isSignal(xpMessage)) {
            if (this.isPing(xpMessage) || this.isPong(xpMessage)) {
                priority = 99;
            } else if (xpMessage.isAck()) {
                String refSchemaSet = xpMessage.getProcessingDirective("ReferenceSchemaSet");
                String refMessageType = xpMessage.getProcessingDirective("ReferenceMessageType");
                String refMessageVersion = xpMessage.getProcessingDirective("ReferenceSchemaVersion");
                priority = this.schemataConfig.getPriorityBySetTypeVersion(refSchemaSet, refMessageType, refMessageVersion);
            }
        } else {
            priority = this.schemataConfig.getPriorityBySetTypeVersion(xpMessage.getSchemaSet(), xpMessage.getMessageType(), xpMessage.getMessageVersion());
        }
        return priority;
    }

    public int getTotalMessageCount() {
        return this.outboundQueueMessageDAO.getQueueSize();
    }

    public void setMessageInTransferCanceller(Function<Long, Boolean> messageInTransferCanceller) {
        this.messageInTransferCanceller = messageInTransferCanceller;
    }
}

