/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.ponton.xmlpipe.queue.EndpointQueue;
import de.ponton.xmlpipe.queue.IEndpointQueueFactory;
import de.ponton.xmlpipe.queue.InboundEndpointQueue;
import de.ponton.xmlpipe.queue.InboundQueueMessageFactory;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.InboundQueueingDAO;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboundEndpointQueueFactory
implements IEndpointQueueFactory {
    public static final Logger LOG = LogManager.getLogger((String)"Messenger.InboundEndpointQueueFactory");
    private final AdapterRegistry adapterRegistry;
    private final InboundQueueingDAO inboundQueueingDAO;
    private final InboundQueueMessageFactory inboundQueueMessageFactory;

    public InboundEndpointQueueFactory(AdapterRegistry adapterRegistry, InboundQueueingDAO inboundQueueingDAO, InboundQueueMessageFactory inboundQueueMessageFactory) {
        this.adapterRegistry = adapterRegistry;
        this.inboundQueueingDAO = inboundQueueingDAO;
        this.inboundQueueMessageFactory = inboundQueueMessageFactory;
    }

    @Override
    public EndpointQueue createEndpointQueue(String adapterId) {
        return new InboundEndpointQueue(adapterId, () -> {
            AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(adapterId);
            if (adapterInfo == null) {
                return 1;
            }
            return adapterInfo.getMaximumThreads();
        }, 300000L, this.inboundQueueingDAO, this.adapterRegistry, this.inboundQueueMessageFactory);
    }

    @Override
    public List<String> getAllEndpointsFromQueuedMessages() {
        try {
            return this.inboundQueueingDAO.getAdaptersWithPendingMessages();
        }
        catch (DbException e) {
            LOG.error("Can't get all pending endpoints from queue", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

