/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.httpadapter.configuration;

import de.ponton.xmlpipe.httpadapter.CustomAuthenticationFilter;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import de.pontonconsulting.xmlpipe.security.acegi.PreAuthenticationChecks;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity(securedEnabled=true)
public class HttpAdapterSecurityConfig {
    @Value(value="${springdoc.swagger-ui.url}")
    private String swaggerUiConfigUrl;
    private final PasswordEncoder passwordEncoder;
    private final BasicAuthenticationEntryPoint basicAuthenticationEntryPoint;
    private final UserDetailsService userDetailsService;
    private final CustomAuthenticationFilter customAuthenticationFilter;

    public HttpAdapterSecurityConfig(PasswordEncoder passwordEncoder, BasicAuthenticationEntryPoint basicAuthenticationEntryPoint, UserDetailsService userDetailsService, CustomAuthenticationFilter customAuthenticationFilter) {
        this.passwordEncoder = passwordEncoder;
        this.basicAuthenticationEntryPoint = basicAuthenticationEntryPoint;
        this.userDetailsService = userDetailsService;
        this.customAuthenticationFilter = customAuthenticationFilter;
    }

    @Bean
    MvcRequestMatcher.Builder mvc(HandlerMappingIntrospector introspector) {
        return new MvcRequestMatcher.Builder(introspector);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, MvcRequestMatcher.Builder mvc) throws Exception {
        http.csrf(csrf -> csrf.disable()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{mvc.pattern("/swagger-ui/**"), AntPathRequestMatcher.antMatcher((String)"/v3/api-docs/**"), AntPathRequestMatcher.antMatcher((String)"/swagger-resources/**"), AntPathRequestMatcher.antMatcher((String)(this.swaggerUiConfigUrl + "/**"))})).permitAll().anyRequest()).authenticated()).httpBasic(basic -> basic.authenticationEntryPoint((AuthenticationEntryPoint)this.basicAuthenticationEntryPoint)).addFilterAfter((Filter)this.customAuthenticationFilter, BasicAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AuthenticationEventPublisher authenticationEventPublisher() {
        return new DefaultAuthenticationEventPublisher();
    }

    @Bean
    public PreAuthenticationChecks preAuthenticationChecks() {
        return new PreAuthenticationChecks();
    }

    @Bean
    public DaoAuthenticationProvider daoAuthenticationProvider(PasswordEncoder passwordEncoder, PontonUserDetailsServiceImpl pontonUserDetailsService, UserDetailsChecker preAuthenticationChecks, UserDetailsChecker postAuthenticationChecks) {
        DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
        daoAuthenticationProvider.setPasswordEncoder(passwordEncoder);
        daoAuthenticationProvider.setUserDetailsService((UserDetailsService)pontonUserDetailsService);
        daoAuthenticationProvider.setPreAuthenticationChecks(preAuthenticationChecks);
        daoAuthenticationProvider.setPostAuthenticationChecks(postAuthenticationChecks);
        return daoAuthenticationProvider;
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth, ProviderManager providerManager) throws Exception {
        auth.userDetailsService(this.userDetailsService).passwordEncoder(this.passwordEncoder);
        auth.parentAuthenticationManager((AuthenticationManager)providerManager);
    }

    @Bean
    public ProviderManager authenticationManager(AuthenticationEventPublisher eventPublisher, AuthenticationProvider daoAuthenticationProvider) {
        ProviderManager providerManager = new ProviderManager(new AuthenticationProvider[]{daoAuthenticationProvider});
        providerManager.setEraseCredentialsAfterAuthentication(false);
        providerManager.setAuthenticationEventPublisher(eventPublisher);
        return providerManager;
    }
}

