/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.httpadapter;

import de.ponton.xmlpipe.httpadapter.HttpAdapterAckMessage;
import de.ponton.xmlpipe.httpadapter.HttpAdapterConfig;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import jakarta.annotation.PostConstruct;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class HttpAdapterAckQueue {
    private static final Logger logger = LogManager.getLogger(HttpAdapterAckQueue.class);
    public static final String SEPARATOR = "_";
    public static final String META_INFO_SUFFIX = "_meta_info";
    public static final String PAYLOAD_SUFFIX = "_payload";
    private final HttpAdapterConfig httpAdapterConfig;
    private final IServerConfigBean serverConfig;
    private final ReentrantLock lock;
    private Path ackFolder;
    private Path indexFile;

    public HttpAdapterAckQueue(HttpAdapterConfig httpAdapterConfig, IServerConfigBean serverConfig) {
        this.httpAdapterConfig = httpAdapterConfig;
        this.serverConfig = serverConfig;
        this.lock = new ReentrantLock();
    }

    @PostConstruct
    void init() throws IOException {
        this.ackFolder = this.serverConfig.getRealFile(this.httpAdapterConfig.getAckFolder()).toPath();
        if (!Files.exists(this.ackFolder, new LinkOption[0])) {
            Files.createDirectories(this.ackFolder, new FileAttribute[0]);
            logger.info("Created ack folder: {}", (Object)this.ackFolder);
        } else if (!Files.isDirectory(this.ackFolder, new LinkOption[0])) {
            throw new IOException("The defined ack folder is a file: " + String.valueOf(this.ackFolder));
        }
        this.indexFile = this.ackFolder.resolve("index");
        if (Files.notExists(this.indexFile, new LinkOption[0])) {
            this.createIndexFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFile() throws IOException {
        this.lock.lock();
        try (Stream<Path> list = Files.list(this.ackFolder);){
            List sortedMetaInfoList = list.filter(path -> path.getFileName().toString().endsWith(META_INFO_SUFFIX)).map(Path::toFile).sorted(Comparator.comparingLong(this::lastModified).thenComparingLong(this::extractId)).collect(Collectors.toList());
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(this.indexFile, new OpenOption[0]));){
                for (File metaInfoFile : sortedMetaInfoList) {
                    ((OutputStream)outputStream).write((String.valueOf(this.extractId(metaInfoFile)) + "\n").getBytes());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private Long lastModified(File file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attr.lastModifiedTime().toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private Long extractId(File file) {
        return Long.valueOf(file.getName().split(SEPARATOR)[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<HttpAdapterAckMessage> getNextMessage() throws IOException {
        this.lock.lock();
        try {
            Scanner fileScanner = new Scanner(this.indexFile);
            try {
                String messageUniqueId = fileScanner.nextLine();
                Path metaInfoPath = this.ackFolder.resolve(messageUniqueId + META_INFO_SUFFIX);
                Path payloadPath = this.ackFolder.resolve(messageUniqueId + PAYLOAD_SUFFIX);
                Optional<HttpAdapterAckMessage> optional = Optional.of(new HttpAdapterAckMessage(messageUniqueId, metaInfoPath, payloadPath));
                fileScanner.close();
                return optional;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileScanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (NoSuchElementException e) {
                    Optional<HttpAdapterAckMessage> optional = Optional.empty();
                    return optional;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCurrentAckByUniqueId(String messageUniqueId) throws IOException {
        boolean indexEntryDeleted;
        logger.debug("Deleting stored message with ID '{}'.", (Object)messageUniqueId);
        this.lock.lock();
        try {
            String indexFileContent = Files.readString(this.indexFile);
            if (indexFileContent.startsWith(messageUniqueId + "\n")) {
                Files.writeString(this.indexFile, (CharSequence)indexFileContent.substring((messageUniqueId + "\n").length()), new OpenOption[0]);
                indexEntryDeleted = true;
                logger.debug("Deleted message with ID '{}' from index file.", (Object)messageUniqueId);
            } else {
                indexEntryDeleted = false;
                logger.warn("Message with ID '{}' is not found at the first place in the index file.", (Object)messageUniqueId);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (indexEntryDeleted) {
            Files.deleteIfExists(this.ackFolder.resolve(messageUniqueId + META_INFO_SUFFIX));
            Files.deleteIfExists(this.ackFolder.resolve(messageUniqueId + PAYLOAD_SUFFIX));
            logger.debug("Deleted stored message with ID '{}' from file system.", (Object)messageUniqueId);
        }
        return indexEntryDeleted;
    }

    public long getQueueSize() throws IOException {
        this.lock.lock();
        try {
            long l;
            block9: {
                Stream<String> lines = Files.lines(this.indexFile);
                try {
                    l = lines.count();
                    if (lines == null) break block9;
                }
                catch (Throwable throwable) {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lines.close();
            }
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public MessageResult addMessage(BackEndMessage backEndMessage) {
        String id = backEndMessage.getDatabaseId();
        logger.debug("Receiving message with ID '{}'.", (Object)id);
        Path metaInfoPath = this.ackFolder.resolve(id + META_INFO_SUFFIX);
        Path payloadPath = this.ackFolder.resolve(id + PAYLOAD_SUFFIX);
        if (Files.exists(metaInfoPath, new LinkOption[0]) && Files.exists(payloadPath, new LinkOption[0])) {
            MessageResult messageResult = new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
            messageResult.setDescription("Ignored duplicate message.");
            return messageResult;
        }
        try {
            Properties metaInfo = this.buildMetaInfoProperties(backEndMessage, id);
            try (OutputStream metaInfoOut = Files.newOutputStream(metaInfoPath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                metaInfo.store(metaInfoOut, "Powered by PONTON GmbH.");
                logger.debug("Stored meta info: {}", (Object)metaInfoPath);
            }
            try (OutputStream payloadPathOut = Files.newOutputStream(payloadPath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                backEndMessage.writeMessageDocumentTo(payloadPathOut);
                logger.debug("Stored payload: {}", (Object)payloadPath);
            }
            this.addToIndex(backEndMessage.getDatabaseId());
        }
        catch (Exception e) {
            logger.error("Could not stored message.", (Throwable)e);
            this.deleteFile(metaInfoPath);
            this.deleteFile(payloadPath);
            MessageResult messageResult = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
            messageResult.setDescription(e.toString());
            return messageResult;
        }
        logger.info("Received message with ID '{}'", (Object)id);
        return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToIndex(String messageUniqueId) throws IOException {
        this.lock.lock();
        try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(this.indexFile, StandardOpenOption.APPEND));){
            ((OutputStream)fileOutputStream).write((messageUniqueId + "\n").getBytes());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void deleteFile(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException ioe) {
            logger.warn("Could not delete file: {}.", (Object)ioe.toString());
        }
    }

    private Properties buildMetaInfoProperties(BackEndMessage message, String id) {
        Properties metaInfo = new Properties();
        metaInfo.setProperty("Content-Type", message.getMimeType());
        metaInfo.setProperty("X-Id", id);
        metaInfo.setProperty("X-MessageId", message.getTransferIDText());
        metaInfo.setProperty("X-RefId", message.getProcessingDirectiveAsString("ReferenceUniqueId"));
        metaInfo.setProperty("X-RefMessageId", message.getReferenceId());
        metaInfo.setProperty("X-ConversationId", message.getConversationIDText());
        metaInfo.setProperty("X-RefSchemaSet", message.getProcessingDirectiveAsString("ReferenceSchemaSet"));
        metaInfo.setProperty("X-RefMessageType", message.getProcessingDirectiveAsString("ReferenceMessageType"));
        metaInfo.setProperty("X-RefMessageVersion", message.getProcessingDirectiveAsString("ReferenceSchemaVersion"));
        metaInfo.setProperty("X-RefBackendSenderId", message.getProcessingDirectiveAsString("ReferenceSenderId"));
        metaInfo.setProperty("X-RefBackendReceiverId", message.getProcessingDirectiveAsString("ReferenceReceiverId"));
        return metaInfo;
    }
}

