/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket.security;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;

public class SignatureVerifier {
    private final KeyFactory keyFactory = KeyFactory.getInstance("RSA");

    public boolean verify(byte[] data, byte[] signature, byte[] publicKeyBytes) throws GeneralSecurityException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = this.keyFactory.generatePublic(x509EncodedKeySpec);
        Signature publicSignature = Signature.getInstance("SHA256withRSA");
        publicSignature.initVerify(publicKey);
        publicSignature.update(data);
        return publicSignature.verify(signature);
    }
}

