/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket;

import de.ponton.xp.adapter.api.domainvalues.OutboundStatusEnum;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.MetaDataPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;
import de.pontonconsulting.xmlpipe.messenger.SendToListenerResult;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpOutboundMessage;
import java.util.Objects;
import java.util.TreeMap;

public class OutboundMessageStatusUpdateFactory {
    private static final String UNKNOWN = "UNKNOWN";

    public SimpleProperties createStatusUpdate(XpInboundMessage ackXpMessage) {
        SimpleProperties properties = new SimpleProperties();
        properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.OutboundMessageStatusUpdate.name());
        properties.setProperty(AdapterPropertiesEnum.TRANSFER_ID, ackXpMessage.getTransferId());
        properties.setProperty(AdapterPropertiesEnum.RESULT, this.getResultForAckResult(ackXpMessage.getProcessingDirective("AckResult")));
        properties.setProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT, ackXpMessage.getProcessingDirective("AckResultText"), UNKNOWN);
        properties.setProperty(AdapterPropertiesEnum.IS_FINAL, String.valueOf(true));
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_ID, ackXpMessage.getProcessingDirective("ReferenceMessageId"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_UNIQUE_ID, ackXpMessage.getProcessingDirective("ReferenceUniqueId"));
        properties.setProperty(MetaDataPropertiesEnum.CONVERSATION_ID, ackXpMessage.getProcessingDirective("ReferenceConversationId"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.SEQUENCE_NUMBER, ackXpMessage.getProcessingDirective("ReferenceSequenceNumber"), "-1");
        properties.setProperty(MetaDataPropertiesEnum.SENDER_ID, ackXpMessage.getProcessingDirective("ReferenceSenderId"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.RECEIVER_ID, ackXpMessage.getProcessingDirective("ReferenceReceiverId"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.CREATION_TIME, ackXpMessage.getProcessingDirective("ReferenceCreationTime"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.RECEPTION_TIME, ackXpMessage.getMessageTimestamp() == null ? null : String.valueOf(ackXpMessage.getMessageTimestamp().getTime()), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.FILENAME, ackXpMessage.getProcessingDirective("OriginalFilename"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_TYPE, ackXpMessage.getProcessingDirective("ReferenceMessageType"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_TYPE_DISPLAY_NAME, ackXpMessage.getProcessingDirective("ReferenceMessageType"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_VERSION, ackXpMessage.getProcessingDirective("ReferenceSchemaVersion"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.SCHEMA_SET, ackXpMessage.getProcessingDirective("ReferenceSchemaSet"), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.MIME_TYPE, ackXpMessage.getProcessingDirective("ReferenceContentType"), UNKNOWN);
        TreeMap processingDirectives = new TreeMap();
        ackXpMessage.getProcessingDirectives().forEach((key, value) -> {
            if (key.startsWith("ReferenceProcessingDirective_")) {
                processingDirectives.put(key.substring("ReferenceProcessingDirective_".length()), value);
            }
        });
        properties.setProperties(MetaDataPropertiesEnum.PROCESSING_DIRECTIVE, processingDirectives);
        return properties;
    }

    private String getResultForAckResult(String ackResult) {
        switch (ackResult) {
            case "Success": 
            case "Warning": {
                return OutboundStatusEnum.SUCCESS.toString();
            }
        }
        return OutboundStatusEnum.TRANSMISSION_ERROR.toString();
    }

    public SimpleProperties createStatusUpdate(SendToListenerResult sendToListenerResult) {
        XpOutboundMessage xpOutboundQueueMessage = sendToListenerResult.getXpOutboundQueueMessage();
        SimpleProperties properties = new SimpleProperties();
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_UNIQUE_ID, String.valueOf(xpOutboundQueueMessage.getDatabaseId()));
        properties.setProperty(AdapterPropertiesEnum.MESSAGE_TYPE, ProtocolMessageTypeEnum.OutboundMessageStatusUpdate.name());
        properties.setProperty(AdapterPropertiesEnum.TRANSFER_ID, xpOutboundQueueMessage.getTransferId());
        properties.setProperty(AdapterPropertiesEnum.RESULT, this.covertResult(sendToListenerResult.getResult()).toString());
        properties.setProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT, this.getDetailText(sendToListenerResult), UNKNOWN);
        properties.setProperty(AdapterPropertiesEnum.IS_FINAL, String.valueOf(this.isFinal(sendToListenerResult)));
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_ID, xpOutboundQueueMessage.getMessageId(), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.CONVERSATION_ID, xpOutboundQueueMessage.getConversationId(), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.SEQUENCE_NUMBER, String.valueOf(xpOutboundQueueMessage.getSequenceNumber()));
        properties.setProperty(MetaDataPropertiesEnum.SENDER_ID, xpOutboundQueueMessage.getSenderInternalId(), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.RECEIVER_ID, xpOutboundQueueMessage.getReceiverInternalId(), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.CREATION_TIME, String.valueOf(xpOutboundQueueMessage.getMessageTimestamp().getTime()));
        String originalFileName = xpOutboundQueueMessage.getProcessingDirective("OriginalFilename");
        if (originalFileName != null && !originalFileName.isBlank()) {
            properties.setProperty(MetaDataPropertiesEnum.FILENAME, originalFileName);
        } else {
            properties.setProperty(MetaDataPropertiesEnum.FILENAME, xpOutboundQueueMessage.getProcessingDirective("ProcessedOriginalFilename"), UNKNOWN);
        }
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_TYPE, xpOutboundQueueMessage.getMessageType(), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_TYPE_DISPLAY_NAME, xpOutboundQueueMessage.getMessageType(), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.MESSAGE_VERSION, xpOutboundQueueMessage.getMessageVersion(), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.SCHEMA_SET, xpOutboundQueueMessage.getSchemaSet(), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.MIME_TYPE, xpOutboundQueueMessage.getCurrentContentType(), UNKNOWN);
        properties.setProperty(MetaDataPropertiesEnum.LOG_INFO, xpOutboundQueueMessage.getProcessingDirective("LogInfo"), UNKNOWN);
        properties.setProperties(MetaDataPropertiesEnum.PROCESSING_DIRECTIVE, xpOutboundQueueMessage.getProcessingDirectives());
        return properties;
    }

    private OutboundStatusEnum covertResult(SendToListenerResult.Result result) {
        switch (result) {
            case MSG_SUCCESSFULLY_SENT: {
                return OutboundStatusEnum.PROCESSED_AND_QUEUED;
            }
            case PARTNER_IS_NOT_KNOWN: 
            case PARTNER_IS_DISABLED: 
            case PARTNER_STORE_COULD_NOT_BE_ACCESSED: 
            case SENDER_IS_NOT_A_LOCAL_PARTNER: 
            case RECEIVER_IS_NOT_A_REMOTE_PARTNER: 
            case NO_AGREEMENT_FOUND: 
            case COULD_NOT_PROCESS_MESSAGE: 
            case COULD_NOT_PACKAGE_MESSAGE: 
            case SIGNING_FAILED: 
            case ENCRYPTION_FAILED: 
            case COMPRESSION_FAILED: 
            case TRANSPORT_PROVIDER_NOT_FOUND: {
                return OutboundStatusEnum.CONFIG_ERROR;
            }
            case VALIDATION_FAILED: {
                return OutboundStatusEnum.CONTENT_ERROR;
            }
        }
        return OutboundStatusEnum.FAILED;
    }

    private String getDetailText(SendToListenerResult sendToListenerResult) {
        StringBuilder detailText = new StringBuilder();
        if (Objects.nonNull(sendToListenerResult.getDetails())) {
            detailText.append(sendToListenerResult.getDetails());
        }
        if (Objects.nonNull(sendToListenerResult.getException())) {
            detailText.append(sendToListenerResult.getException().toString());
        }
        return detailText.toString().replace("\n", " ").replace("\r", " ").trim();
    }

    private boolean isFinal(SendToListenerResult sendToListenerResult) {
        return sendToListenerResult.getResult() != SendToListenerResult.Result.MSG_SUCCESSFULLY_SENT;
    }
}

