/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.hibernate.AssertionFailure;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.internal.AttributeFactory;
import org.hibernate.metamodel.internal.JpaMetaModelPopulationSetting;
import org.hibernate.metamodel.internal.JpaStaticMetaModelPopulationSetting;
import org.hibernate.metamodel.model.domain.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.internal.BasicTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.internal.PrimitiveBasicTypeImpl;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

@Internal
public class MetadataContext {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(MetadataContext.class);
    private final JpaMetamodelImplementor jpaMetamodel;
    private final RuntimeModelCreationContext runtimeModelCreationContext;
    private final Set<MappedSuperclass> knownMappedSuperclasses;
    private final TypeConfiguration typeConfiguration;
    private final JpaStaticMetaModelPopulationSetting jpaStaticMetaModelPopulationSetting;
    private final JpaMetaModelPopulationSetting jpaMetaModelPopulationSetting;
    private final AttributeFactory attributeFactory = new AttributeFactory(this);
    private final Map<Class<?>, EntityDomainType<?>> entityTypes = new HashMap();
    private final Map<String, IdentifiableDomainType<?>> identifiableTypesByName = new HashMap();
    private final Map<PersistentClass, EntityDomainType<?>> entityTypesByPersistentClass = new HashMap();
    private final Map<Class<?>, EmbeddableDomainType<?>> embeddables = new HashMap();
    private final Map<Class<?>, List<EmbeddableDomainType<?>>> embeddablesToProcess = new HashMap();
    private final Map<EmbeddableDomainType<?>, Component> componentByEmbeddable = new HashMap();
    private final Map<MappedSuperclass, MappedSuperclassDomainType<?>> mappedSuperclassByMappedSuperclassMapping = new HashMap();
    private final Map<MappedSuperclassDomainType<?>, PersistentClass> mappedSuperClassTypeToPersistentClass = new HashMap();
    private final List<Object> orderedMappings = new ArrayList<Object>();
    private final List<PersistentClass> stackOfPersistentClassesBeingProcessed = new ArrayList<PersistentClass>();
    private final MappingMetamodel metamodel;
    private final ClassLoaderService classLoaderService;
    private final Map<Class<?>, BasicDomainType<?>> basicDomainTypeMap = new HashMap();

    public MetadataContext(JpaMetamodelImplementor jpaMetamodel, MappingMetamodel mappingMetamodel, MetadataImplementor bootMetamodel, JpaStaticMetaModelPopulationSetting jpaStaticMetaModelPopulationSetting, JpaMetaModelPopulationSetting jpaMetaModelPopulationSetting, RuntimeModelCreationContext runtimeModelCreationContext) {
        this.jpaMetamodel = jpaMetamodel;
        this.classLoaderService = jpaMetamodel.getServiceRegistry().getService(ClassLoaderService.class);
        this.metamodel = mappingMetamodel;
        this.knownMappedSuperclasses = bootMetamodel.getMappedSuperclassMappingsCopy();
        this.typeConfiguration = runtimeModelCreationContext.getTypeConfiguration();
        this.jpaStaticMetaModelPopulationSetting = jpaStaticMetaModelPopulationSetting;
        this.jpaMetaModelPopulationSetting = jpaMetaModelPopulationSetting;
        this.runtimeModelCreationContext = runtimeModelCreationContext;
    }

    public RuntimeModelCreationContext getRuntimeModelCreationContext() {
        return this.runtimeModelCreationContext;
    }

    public JpaMetamodelImplementor getJpaMetamodel() {
        return this.jpaMetamodel;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public JavaTypeRegistry getJavaTypeRegistry() {
        return this.typeConfiguration.getJavaTypeRegistry();
    }

    MappingMetamodel getMetamodel() {
        return this.metamodel;
    }

    public Map<Class<?>, EntityDomainType<?>> getEntityTypeMap() {
        return Collections.unmodifiableMap(this.entityTypes);
    }

    public Set<EmbeddableDomainType<?>> getEmbeddableTypeSet() {
        return this.componentByEmbeddable.keySet();
    }

    public Map<Class<?>, MappedSuperclassDomainType<?>> getMappedSuperclassTypeMap() {
        HashMap<Class<?>, MappedSuperclassDomainType<?>> mappedSuperClassTypeMap = CollectionHelper.mapOfSize(this.mappedSuperclassByMappedSuperclassMapping.size());
        for (MappedSuperclassDomainType<?> mappedSuperclassType : this.mappedSuperclassByMappedSuperclassMapping.values()) {
            mappedSuperClassTypeMap.put(mappedSuperclassType.getJavaType(), mappedSuperclassType);
        }
        return mappedSuperClassTypeMap;
    }

    public void registerEntityType(PersistentClass persistentClass, EntityTypeImpl<?> entityType) {
        if (entityType.getBindableJavaType() != null && entityType.getBindableJavaType() != Map.class) {
            this.entityTypes.put(entityType.getBindableJavaType(), entityType);
        }
        this.identifiableTypesByName.put(persistentClass.getEntityName(), entityType);
        this.entityTypesByPersistentClass.put(persistentClass, entityType);
        this.orderedMappings.add(persistentClass);
    }

    public void registerEmbeddableType(EmbeddableDomainType<?> embeddableType, Component bootDescriptor) {
        assert (embeddableType.getJavaType() != null);
        assert (!Map.class.isAssignableFrom(embeddableType.getJavaType()));
        this.embeddablesToProcess.computeIfAbsent(embeddableType.getJavaType(), k -> new ArrayList(1)).add(embeddableType);
        this.registerComponentByEmbeddable(embeddableType, bootDescriptor);
    }

    public void registerComponentByEmbeddable(EmbeddableDomainType<?> embeddableType, Component bootDescriptor) {
        this.componentByEmbeddable.put(embeddableType, bootDescriptor);
    }

    public Component getEmbeddableBootDescriptor(EmbeddableDomainType<?> embeddableType) {
        return this.componentByEmbeddable.get(embeddableType);
    }

    public void registerMappedSuperclassType(MappedSuperclass mappedSuperclass, MappedSuperclassDomainType<?> mappedSuperclassType) {
        this.identifiableTypesByName.put(mappedSuperclassType.getTypeName(), mappedSuperclassType);
        this.mappedSuperclassByMappedSuperclassMapping.put(mappedSuperclass, mappedSuperclassType);
        this.orderedMappings.add(mappedSuperclass);
        if (!this.stackOfPersistentClassesBeingProcessed.isEmpty()) {
            this.mappedSuperClassTypeToPersistentClass.put(mappedSuperclassType, this.getEntityWorkedOn());
        }
        this.knownMappedSuperclasses.remove(mappedSuperclass);
    }

    public EntityDomainType<?> locateEntityType(PersistentClass persistentClass) {
        return this.entityTypesByPersistentClass.get(persistentClass);
    }

    public EntityDomainType<?> locateEntityType(Class<?> javaType) {
        return this.entityTypes.get(javaType);
    }

    public <E> IdentifiableDomainType<E> locateIdentifiableType(String entityName) {
        return this.identifiableTypesByName.get(entityName);
    }

    public Map<String, IdentifiableDomainType<?>> getIdentifiableTypesByName() {
        return Collections.unmodifiableMap(this.identifiableTypesByName);
    }

    private <X> PersistentAttribute<X, ?> buildAttribute(Property property, IdentifiableDomainType<X> entityType, BiFunction<IdentifiableDomainType<X>, Property, PersistentAttribute<X, ?>> factoryFunction) {
        PersistentAttribute<X, ?> attribute;
        Component component;
        Component component2 = component = property.getValue() instanceof Component ? (Component)property.getValue() : null;
        if (component != null && component.isGeneric()) {
            PersistentAttribute<X, ?> concreteAttribute;
            Component genericComponent = this.runtimeModelCreationContext.getMetadata().getGenericComponent(component.getComponentClass());
            Property genericProperty = property.copy();
            genericProperty.setValue(genericComponent);
            genericProperty.setGeneric(true);
            attribute = factoryFunction.apply(entityType, genericProperty);
            if (!property.isGeneric() && (concreteAttribute = factoryFunction.apply(entityType, property)) != null) {
                ((AttributeContainer)((Object)entityType)).getInFlightAccess().addConcreteGenericAttribute(concreteAttribute);
            }
        } else {
            attribute = factoryFunction.apply(entityType, property);
        }
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapUp() {
        PersistentAttribute<Object, Object> attribute;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Wrapping up metadata context...");
        }
        boolean staticMetamodelScanEnabled = this.jpaStaticMetaModelPopulationSetting != JpaStaticMetaModelPopulationSetting.DISABLED;
        HashSet<String> processedMetamodelClasses = new HashSet<String>();
        for (Object mapping : this.orderedMappings) {
            if (PersistentClass.class.isAssignableFrom(mapping.getClass())) {
                PersistentClass persistentClass = (PersistentClass)mapping;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Starting entity [" + persistentClass.getEntityName() + "]");
                }
                try {
                    EntityDomainType<?> jpaMapping = this.entityTypesByPersistentClass.get(persistentClass);
                    this.applyIdMetadata(persistentClass, jpaMapping);
                    this.applyVersionAttribute(persistentClass, jpaMapping);
                    this.applyGenericProperties(persistentClass, jpaMapping);
                    for (Property property : persistentClass.getDeclaredProperties()) {
                        if (property.getValue() == persistentClass.getIdentifierMapper() || persistentClass.isVersioned() && property == persistentClass.getVersion() || (attribute = this.buildAttribute(property, jpaMapping, this.attributeFactory::buildAttribute)) == null) continue;
                        this.addAttribute(jpaMapping, attribute);
                        if (!property.isNaturalIdentifier()) continue;
                        ((AttributeContainer)((Object)jpaMapping)).getInFlightAccess().applyNaturalIdAttribute(attribute);
                    }
                    ((AttributeContainer)((Object)jpaMapping)).getInFlightAccess().finishUp();
                    if (!staticMetamodelScanEnabled) continue;
                    this.populateStaticMetamodel(jpaMapping, processedMetamodelClasses);
                    continue;
                }
                finally {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Completed entity [" + persistentClass.getEntityName() + "]");
                    }
                    continue;
                }
            }
            if (MappedSuperclass.class.isAssignableFrom(mapping.getClass())) {
                MappedSuperclass mappedSuperclass = (MappedSuperclass)mapping;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Starting mapped superclass [" + mappedSuperclass.getMappedClass().getName() + "]");
                }
                try {
                    MappedSuperclassDomainType<?> jpaType = this.mappedSuperclassByMappedSuperclassMapping.get(mappedSuperclass);
                    this.applyIdMetadata(mappedSuperclass, jpaType);
                    this.applyVersionAttribute(mappedSuperclass, jpaType);
                    for (Property property : mappedSuperclass.getDeclaredProperties()) {
                        if (MetadataContext.isIdentifierProperty(property, mappedSuperclass) || mappedSuperclass.isVersioned() && property == mappedSuperclass.getVersion() || (attribute = this.buildAttribute(property, jpaType, this.attributeFactory::buildAttribute)) == null) continue;
                        this.addAttribute(jpaType, attribute);
                        if (!property.isNaturalIdentifier()) continue;
                        ((AttributeContainer)((Object)jpaType)).getInFlightAccess().applyNaturalIdAttribute(attribute);
                    }
                    ((AttributeContainer)((Object)jpaType)).getInFlightAccess().finishUp();
                    if (!staticMetamodelScanEnabled) continue;
                    this.populateStaticMetamodel(jpaType, processedMetamodelClasses);
                    continue;
                }
                finally {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Completed mapped superclass [" + mappedSuperclass.getMappedClass().getName() + "]");
                    }
                    continue;
                }
            }
            throw new AssertionFailure("Unexpected mapping type: " + mapping.getClass());
        }
        while (!this.embeddablesToProcess.isEmpty()) {
            ArrayList processingEmbeddables = new ArrayList(this.embeddablesToProcess.size());
            for (List<EmbeddableDomainType<?>> list : this.embeddablesToProcess.values()) {
                processingEmbeddables.addAll(list);
            }
            this.embeddablesToProcess.clear();
            for (EmbeddableDomainType embeddableDomainType : processingEmbeddables) {
                Component component = this.componentByEmbeddable.get(embeddableDomainType);
                for (Property property : component.getProperties()) {
                    if (component.isPolymorphic() && !embeddableDomainType.getTypeName().equals(component.getPropertyDeclaringClass(property)) || (attribute = this.attributeFactory.buildAttribute(embeddableDomainType, property)) == null) continue;
                    Property superclassProperty = this.getMappedSuperclassProperty(property.getName(), component.getMappedSuperclass());
                    if (superclassProperty != null && superclassProperty.isGeneric()) {
                        ((AttributeContainer)((Object)embeddableDomainType)).getInFlightAccess().addConcreteGenericAttribute(attribute);
                        continue;
                    }
                    this.addAttribute(embeddableDomainType, attribute);
                }
                ((AttributeContainer)((Object)embeddableDomainType)).getInFlightAccess().finishUp();
                if (component.isGeneric() || embeddableDomainType.getExpressibleJavaType() instanceof EntityJavaType) continue;
                this.embeddables.put(embeddableDomainType.getJavaType(), embeddableDomainType);
                if (!staticMetamodelScanEnabled) continue;
                this.populateStaticMetamodel(embeddableDomainType, processedMetamodelClasses);
            }
        }
    }

    private static boolean isIdentifierProperty(Property property, MappedSuperclass mappedSuperclass) {
        Component identifierMapper = mappedSuperclass.getIdentifierMapper();
        return identifierMapper != null && ArrayHelper.contains(identifierMapper.getPropertyNames(), property.getName());
    }

    private void addAttribute(ManagedDomainType<?> type, PersistentAttribute<Object, ?> attribute) {
        boolean virtual;
        AttributeContainer container = (AttributeContainer)((Object)type);
        AttributeContainer.InFlightAccess<Object> inFlightAccess = container.getInFlightAccess();
        boolean bl = virtual = attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED && attribute.getAttributeJavaType() instanceof EntityJavaType;
        if (virtual) {
            EmbeddableDomainType embeddableDomainType = (EmbeddableDomainType)attribute.getValueGraphType();
            Component component = this.componentByEmbeddable.get(embeddableDomainType);
            Iterator<Property> iterator = component.getProperties().iterator();
            while (iterator.hasNext()) {
                EmbeddableDomainType managedDomainType = embeddableDomainType;
                Property property = iterator.next();
                PersistentAttribute subAttribute = this.attributeFactory.buildAttribute(managedDomainType, property);
                if (subAttribute == null) continue;
                inFlightAccess.addAttribute(subAttribute);
            }
            if (this.jpaMetaModelPopulationSetting != JpaMetaModelPopulationSetting.ENABLED) {
                return;
            }
        }
        inFlightAccess.addAttribute(attribute);
    }

    private void applyIdMetadata(PersistentClass persistentClass, IdentifiableDomainType<?> identifiableType) {
        if (persistentClass.hasIdentifierProperty()) {
            Property declaredIdentifierProperty = persistentClass.getDeclaredIdentifierProperty();
            AttributeContainer attributeContainer = (AttributeContainer)((Object)identifiableType);
            if (declaredIdentifierProperty != null) {
                SingularPersistentAttribute idAttribute = (SingularPersistentAttribute)this.buildAttribute(declaredIdentifierProperty, identifiableType, this.attributeFactory::buildIdAttribute);
                attributeContainer.getInFlightAccess().applyIdAttribute(idAttribute);
            } else {
                Property superclassIdentifier = this.getMappedSuperclassIdentifier(persistentClass);
                if (superclassIdentifier != null && superclassIdentifier.isGeneric()) {
                    SingularPersistentAttribute concreteIdentifier = this.attributeFactory.buildIdAttribute(identifiableType, persistentClass.getIdentifierProperty());
                    attributeContainer.getInFlightAccess().addConcreteGenericAttribute(concreteIdentifier);
                }
            }
        } else {
            EmbeddableTypeImpl<?> idClassType;
            int propertySpan;
            List<Property> cidProperties;
            if (!(persistentClass.getIdentifier() instanceof Component)) {
                throw new MappingException("Expecting Component for id mapping with no id-attribute");
            }
            Component cidValue = (Component)persistentClass.getIdentifier();
            Component identifierMapper = persistentClass.getIdentifierMapper();
            if (identifierMapper != null) {
                cidProperties = identifierMapper.getProperties();
                propertySpan = identifierMapper.getPropertySpan();
                idClassType = this.applyIdClassMetadata((Component)persistentClass.getIdentifier());
            } else {
                cidProperties = cidValue.getProperties();
                propertySpan = cidValue.getPropertySpan();
                idClassType = null;
            }
            assert (cidValue.isEmbedded());
            AbstractIdentifiableType idType = (AbstractIdentifiableType)this.identifiableTypesByName.get(cidValue.getOwner().getEntityName());
            Set idAttributes = idType.getIdClassAttributesSafely();
            if (idAttributes == null) {
                idAttributes = new HashSet(propertySpan);
                for (Property cidSubproperty : cidProperties) {
                    SingularPersistentAttribute cidSubAttr = this.attributeFactory.buildIdAttribute(idType, cidSubproperty);
                    idAttributes.add(cidSubAttr);
                }
            }
            AttributeContainer container = (AttributeContainer)((Object)identifiableType);
            container.getInFlightAccess().applyNonAggregatedIdAttributes(idAttributes, idClassType);
        }
    }

    private Property getMappedSuperclassIdentifier(PersistentClass persistentClass) {
        MappedSuperclass mappedSuperclass = this.getMappedSuperclass(persistentClass);
        while (mappedSuperclass != null) {
            Property declaredIdentifierProperty = mappedSuperclass.getDeclaredIdentifierProperty();
            if (declaredIdentifierProperty != null) {
                return declaredIdentifierProperty;
            }
            mappedSuperclass = this.getMappedSuperclass(mappedSuperclass);
        }
        return null;
    }

    private EmbeddableTypeImpl<?> applyIdClassMetadata(Component idClassComponent) {
        JavaTypeRegistry registry = this.getTypeConfiguration().getJavaTypeRegistry();
        Class<?> componentClass = idClassComponent.getComponentClass();
        JavaType javaType = registry.resolveManagedTypeDescriptor(componentClass);
        EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(javaType, null, null, false, this.getJpaMetamodel());
        this.registerEmbeddableType(embeddableType, idClassComponent);
        return embeddableType;
    }

    private <X> void applyIdMetadata(MappedSuperclass mappingType, MappedSuperclassDomainType<X> jpaMappingType) {
        AttributeContainer attributeContainer = (AttributeContainer)((Object)jpaMappingType);
        if (mappingType.hasIdentifierProperty()) {
            Property declaredIdentifierProperty = mappingType.getDeclaredIdentifierProperty();
            if (declaredIdentifierProperty != null) {
                SingularPersistentAttribute attribute = (SingularPersistentAttribute)this.buildAttribute(declaredIdentifierProperty, jpaMappingType, this.attributeFactory::buildIdAttribute);
                attributeContainer.getInFlightAccess().applyIdAttribute(attribute);
            }
        } else if (mappingType.getIdentifierMapper() != null) {
            Set attributes = this.buildIdClassAttributes(jpaMappingType, mappingType.getIdentifierMapper().getProperties());
            attributeContainer.getInFlightAccess().applyIdClassAttributes(attributes);
        }
    }

    private <X> void applyVersionAttribute(PersistentClass persistentClass, EntityDomainType<X> jpaEntityType) {
        Property declaredVersion = persistentClass.getDeclaredVersion();
        if (declaredVersion != null) {
            ((AttributeContainer)((Object)jpaEntityType)).getInFlightAccess().applyVersionAttribute(this.attributeFactory.buildVersionAttribute(jpaEntityType, declaredVersion));
        }
    }

    private <X> void applyVersionAttribute(MappedSuperclass mappingType, MappedSuperclassDomainType<X> jpaMappingType) {
        Property declaredVersion = mappingType.getDeclaredVersion();
        if (declaredVersion != null) {
            ((AttributeContainer)((Object)jpaMappingType)).getInFlightAccess().applyVersionAttribute(this.attributeFactory.buildVersionAttribute(jpaMappingType, declaredVersion));
        }
    }

    private <X> void applyGenericProperties(PersistentClass persistentClass, EntityDomainType<X> entityType) {
        MappedSuperclass mappedSuperclass = this.getMappedSuperclass(persistentClass);
        while (mappedSuperclass != null) {
            for (Property superclassProperty : mappedSuperclass.getDeclaredProperties()) {
                if (!superclassProperty.isGeneric()) continue;
                Property property = persistentClass.getProperty(superclassProperty.getName());
                PersistentAttribute attribute = this.attributeFactory.buildAttribute(entityType, property);
                ((AttributeContainer)((Object)entityType)).getInFlightAccess().addConcreteGenericAttribute(attribute);
            }
            mappedSuperclass = this.getMappedSuperclass(mappedSuperclass);
        }
    }

    private MappedSuperclass getMappedSuperclass(PersistentClass persistentClass) {
        while (persistentClass != null) {
            MappedSuperclass mappedSuperclass = persistentClass.getSuperMappedSuperclass();
            if (mappedSuperclass != null) {
                return mappedSuperclass;
            }
            persistentClass = persistentClass.getSuperclass();
        }
        return null;
    }

    private MappedSuperclass getMappedSuperclass(MappedSuperclass mappedSuperclass) {
        return mappedSuperclass.getSuperMappedSuperclass() != null ? mappedSuperclass.getSuperMappedSuperclass() : this.getMappedSuperclass(mappedSuperclass.getSuperPersistentClass());
    }

    private Property getMappedSuperclassProperty(String propertyName, MappedSuperclass mappedSuperclass) {
        if (mappedSuperclass == null) {
            return null;
        }
        for (Property property : mappedSuperclass.getDeclaredProperties()) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        Property property = this.getMappedSuperclassProperty(propertyName, mappedSuperclass.getSuperMappedSuperclass());
        if (property != null) {
            return property;
        }
        if (mappedSuperclass.getSuperPersistentClass() != null) {
            return mappedSuperclass.getSuperPersistentClass().getProperty(propertyName);
        }
        return null;
    }

    private <X> Set<SingularPersistentAttribute<? super X, ?>> buildIdClassAttributes(IdentifiableDomainType<X> ownerType, List<Property> properties) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Building old-school composite identifier [" + ownerType.getJavaType().getName() + "]");
        }
        HashSet attributes = new HashSet();
        for (Property property : properties) {
            attributes.add(this.attributeFactory.buildIdAttribute(ownerType, property));
        }
        return attributes;
    }

    private <X> void populateStaticMetamodel(ManagedDomainType<X> managedType, Set<String> processedMetamodelClassName) {
        Class managedTypeClass = managedType.getJavaType();
        if (managedTypeClass == null) {
            return;
        }
        String metamodelClassName = managedTypeClass.getName() + "_";
        if (processedMetamodelClassName.add(metamodelClassName)) {
            try {
                Class metamodelClass = this.classLoaderService.classForName(metamodelClassName);
                this.registerAttributes(metamodelClass, managedType);
                try {
                    MetadataContext.injectField(metamodelClass, "class_", managedType, false);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
            catch (ClassLoadingException metamodelClass) {
                // empty catch block
            }
            ManagedDomainType<X> superType = managedType.getSuperType();
            if (superType != null) {
                this.populateStaticMetamodel(superType, processedMetamodelClassName);
            }
        }
    }

    private <X> void registerAttributes(Class<?> metamodelClass, ManagedDomainType<X> managedType) {
        for (Attribute attribute : managedType.getDeclaredAttributes()) {
            this.registerAttribute(metamodelClass, attribute);
        }
        if (managedType instanceof IdentifiableType) {
            Set attributes;
            AbstractIdentifiableType entityType = (AbstractIdentifiableType)managedType;
            if (entityType.hasDeclaredVersionAttribute()) {
                this.registerAttribute(metamodelClass, (Attribute<X, ?>)entityType.getDeclaredVersion());
            }
            if (entityType.hasIdClass() && (attributes = entityType.getIdClassAttributesSafely()) != null) {
                for (SingularAttribute singularAttribute : attributes) {
                    this.registerAttribute(metamodelClass, (Attribute<X, ?>)singularAttribute);
                }
            }
        }
    }

    private <X> void registerAttribute(Class<?> metamodelClass, Attribute<X, ?> attribute) {
        String name = attribute.getName();
        try {
            boolean allowNonDeclaredFieldReference = attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED || attribute.getDeclaringType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE;
            MetadataContext.injectField(metamodelClass, name, attribute, allowNonDeclaredFieldReference);
        }
        catch (NoSuchFieldException e) {
            LOG.unableToLocateStaticMetamodelField(metamodelClass.getName(), name);
        }
    }

    private static <X> void injectField(Class<?> metamodelClass, String name, Object model, boolean allowNonDeclaredFieldReference) throws NoSuchFieldException {
        block3: {
            Field field = allowNonDeclaredFieldReference ? metamodelClass.getField(name) : metamodelClass.getDeclaredField(name);
            try {
                ReflectHelper.ensureAccessibility(field);
                field.set(null, model);
            }
            catch (IllegalAccessException e) {
                throw new AssertionFailure("Unable to inject static metamodel attribute : " + metamodelClass.getName() + "#" + name, e);
            }
            catch (IllegalArgumentException e) {
                if (MetadataContext.isDefaultEnversRevisionType(metamodelClass)) break block3;
                LOG.illegalArgumentOnStaticMetamodelFieldInjection(metamodelClass.getName(), name, model.getClass().getName(), field.getType().getName());
            }
        }
    }

    private static boolean isDefaultEnversRevisionType(Class<?> metamodelClass) {
        return Set.of("org.hibernate.envers.DefaultRevisionEntity_", "org.hibernate.envers.DefaultTrackingModifiedEntitiesRevisionEntity_", "org.hibernate.envers.enhanced.SequenceIdRevisionEntity_", "org.hibernate.envers.enhanced.SequenceIdTrackingModifiedEntitiesRevisionEntity_").contains(metamodelClass.getName());
    }

    public MappedSuperclassDomainType<?> locateMappedSuperclassType(MappedSuperclass mappedSuperclass) {
        return this.mappedSuperclassByMappedSuperclassMapping.get(mappedSuperclass);
    }

    public void pushEntityWorkedOn(PersistentClass persistentClass) {
        this.stackOfPersistentClassesBeingProcessed.add(persistentClass);
    }

    public void popEntityWorkedOn(PersistentClass persistentClass) {
        PersistentClass stackTop = this.stackOfPersistentClassesBeingProcessed.remove(this.stackOfPersistentClassesBeingProcessed.size() - 1);
        if (stackTop != persistentClass) {
            throw new AssertionFailure("Inconsistent popping: " + persistentClass.getEntityName() + " instead of " + stackTop.getEntityName());
        }
    }

    private PersistentClass getEntityWorkedOn() {
        return this.stackOfPersistentClassesBeingProcessed.get(this.stackOfPersistentClassesBeingProcessed.size() - 1);
    }

    public PersistentClass getPersistentClassHostingProperties(MappedSuperclassTypeImpl<?> mappedSuperclassType) {
        return this.mappedSuperClassTypeToPersistentClass.get(mappedSuperclassType);
    }

    public Set<MappedSuperclass> getUnusedMappedSuperclasses() {
        return new HashSet<MappedSuperclass>(this.knownMappedSuperclasses);
    }

    public <J> BasicDomainType<J> resolveBasicType(Class<J> javaType) {
        return this.basicDomainTypeMap.computeIfAbsent(javaType, jt -> {
            JavaTypeRegistry registry = this.getTypeConfiguration().getJavaTypeRegistry();
            JavaType javaTypeDescriptor = registry.resolveDescriptor(javaType);
            JdbcType jdbcType = javaTypeDescriptor.getRecommendedJdbcType(this.typeConfiguration.getCurrentBaseSqlTypeIndicators());
            return javaType.isPrimitive() ? new PrimitiveBasicTypeImpl(javaTypeDescriptor, jdbcType, javaType) : new BasicTypeImpl(javaTypeDescriptor, jdbcType);
        });
    }

    public <J> EmbeddableDomainType<J> locateEmbeddable(Class<J> embeddableClass, Component component) {
        Iterator<EmbeddableDomainType<?>> iterator;
        List<EmbeddableDomainType<?>> embeddableDomainTypes;
        EmbeddableDomainType<?> domainType = this.embeddables.get(embeddableClass);
        if (domainType == null && (embeddableDomainTypes = this.embeddablesToProcess.get(embeddableClass)) != null && (iterator = embeddableDomainTypes.iterator()).hasNext()) {
            EmbeddableDomainType<?> embeddableDomainType = iterator.next();
            Component cachedComponent = this.componentByEmbeddable.get(embeddableDomainType);
            if (cachedComponent.isSame(component)) {
                domainType = embeddableDomainType;
            } else if (cachedComponent.getComponentClass().equals(component.getComponentClass())) {
                int cachedComponentPropertySpan = cachedComponent.getPropertySpan();
                if (cachedComponentPropertySpan != component.getPropertySpan()) {
                    throw new MappingException("Encountered multiple component mappings for the same java class " + embeddableClass.getName() + " with different property mappings. Every property mapping combination should have its own java class");
                }
                for (int i = 0; i < cachedComponentPropertySpan; ++i) {
                    if (cachedComponent.getProperty(i).getName().equals(component.getProperty(i).getName())) continue;
                    throw new MappingException("Encountered multiple component mappings for the same java class " + embeddableClass.getName() + " with different property mappings. Every property mapping combination should have its own java class");
                }
                domainType = embeddableDomainType;
            } else {
                throw new MappingException("Encountered multiple component mappings for the same java class " + embeddableClass.getName() + " with different property mappings. Every property mapping combination should have its own java class");
            }
        }
        return domainType;
    }
}

