/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.util;

public class Utils {
    public static int compareProductVersions(String leftProductVersion, String rightProductVersion) {
        if (leftProductVersion == null || rightProductVersion == null) {
            throw new IllegalArgumentException("Product version must not be NULL.");
        }
        String[] leftVersionParts = leftProductVersion.split("\\.");
        String[] rightVersionParts = rightProductVersion.split("\\.");
        int minLength = Math.min(leftVersionParts.length, rightVersionParts.length);
        for (int i = 0; i < minLength; ++i) {
            int rightVersionPart;
            int leftVersionPart = Utils.getNumber(leftVersionParts[i]);
            if (leftVersionPart == (rightVersionPart = Utils.getNumber(rightVersionParts[i]))) continue;
            if (leftVersionPart < rightVersionPart) {
                return -1;
            }
            if (leftVersionPart <= rightVersionPart) continue;
            return 1;
        }
        return 0;
    }

    private static int getNumber(String versionPart) {
        return Integer.parseInt(versionPart.split("-")[0]);
    }
}

