/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.activation.util;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.activation.ActivationRequest;
import de.pontonconsulting.activation.License;
import de.pontonconsulting.security.ASN1Security;
import de.pontonconsulting.util.CommonFormat;
import java.security.cert.X509Certificate;

public class ActivationRequestUtil {
    public static byte[] encryptActivationRequest(ActivationRequest request) throws ActivationException {
        License license = request.getLicense();
        X509Certificate certificate = license.getCertificate();
        if (certificate == null) {
            certificate = license.getCA();
        }
        try {
            return ASN1Security.encrypt(request.getDecodedDER(), certificate);
        }
        catch (Exception e) {
            ActivationException ae = new ActivationException(1008L, "could not encode activation request");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    public static String encodeBase64(byte[] encodedRequest) throws ActivationException {
        return CommonFormat.encodeBase64("-----BEGIN ACTIVATION REQUEST-----\r\n", encodedRequest, "\r\n-----END ACTIVATION REQUEST-----\r\n");
    }

    public static byte[] decodeBase64(String encodedRequest) throws ActivationException {
        return CommonFormat.decodeBase64("-----BEGIN ACTIVATION REQUEST-----\r\n", encodedRequest, "\r\n-----END ACTIVATION REQUEST-----\r\n");
    }
}

