/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.activation;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.activation.License;
import de.pontonconsulting.activation.ProductIdentification;
import de.pontonconsulting.security.ASN1Security;
import de.pontonconsulting.security.CertificateRequest;
import de.pontonconsulting.security.Extension;
import de.pontonconsulting.util.CommonFormat;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.CMSException;

public class ActivationRequest {
    public static final String REQUEST_HEADER = "-----BEGIN ACTIVATION REQUEST-----\r\n";
    public static final String REQUEST_FOOTER = "\r\n-----END ACTIVATION REQUEST-----\r\n";
    private static final String FORMAT = "CANONICAL";
    private CertificateRequest _certRequest;
    private Extension[] _extensions;
    private License _license;

    public ActivationRequest(X500Principal subject, Extension[] extensions, ProductIdentification productIdent, License license) throws ActivationException {
        if (productIdent == null) {
            throw new ActivationException(1003L, "product identification is required");
        }
        if (license == null) {
            throw new ActivationException(1004L, "license or license CA is required");
        }
        if (subject == null) {
            throw new ActivationException(1005L, "subject for activation request is required");
        }
        this._license = license;
        PublicKey publicKey = productIdent.getPublicKey();
        PrivateKey signingKey = productIdent.getPrivateKey();
        this._extensions = extensions;
        try {
            X500Name subjectX500Name = new X500Name(subject.getName(FORMAT));
            this._certRequest = new CertificateRequest(subjectX500Name, this._extensions, publicKey, signingKey);
        }
        catch (Exception e) {
            ActivationException ae = new ActivationException(1006L, "could not create activation request");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    public ActivationRequest(byte[] decodedDER, License license) throws ActivationException {
        if (license == null) {
            throw new ActivationException(1004L, "license or license CA is required");
        }
        this._license = license;
        try {
            this._certRequest = new CertificateRequest(decodedDER);
            this._extensions = CertificateRequest.createExtensions(this._certRequest.getASN1Set());
        }
        catch (Exception e) {
            ActivationException ae = new ActivationException(1007L, "could not read activation request");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    public byte[] getDecodedDER() throws IOException {
        return this._certRequest.getDER();
    }

    @Deprecated
    public byte[] getEncodedDER() throws ActivationException {
        X509Certificate encodeCert = this._license.getCertificate();
        if (encodeCert == null) {
            encodeCert = this._license.getCA();
        }
        try {
            return ASN1Security.encrypt(this.getDecodedDER(), encodeCert);
        }
        catch (IOException e) {
            ActivationException ae = new ActivationException(1008L, "could not encode activation request");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        catch (GeneralSecurityException e) {
            ActivationException ae = new ActivationException(1008L, "could not encode activation request");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        catch (CMSException e) {
            ActivationException ae = new ActivationException(1008L, "could not encode activation request");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    @Deprecated
    public String getBase64Encoded() throws ActivationException {
        return CommonFormat.encodeBase64(REQUEST_HEADER, this.getEncodedDER(), REQUEST_FOOTER);
    }

    public Extension[] getExtensions() {
        return this._extensions;
    }

    public X500Name getSubject() {
        return this._certRequest.getSubject();
    }

    public PublicKey getPublicKey() throws ActivationException {
        try {
            return this._certRequest.getPublicKey();
        }
        catch (GeneralSecurityException e) {
            ActivationException ae = new ActivationException(1009L, "could not get public key of certificate request");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    protected CertificateRequest getCertificateRequest() {
        return this._certRequest;
    }

    public License getLicense() {
        return this._license;
    }
}

