/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.applicationpart.patchinfo;

import de.ponton.application.update.api.wrapperconf.OsType;
import de.ponton.application.update.api.wrapperconf.WrapperConf;
import de.ponton.application.update.applicationpart.exception.PatchException;
import de.ponton.application.update.applicationpart.patchinfo.PatchInfo;
import de.ponton.application.update.applicationpart.patchinfo.Version;
import java.io.File;
import java.text.ParseException;
import shaded.org.apache.commons.lang3.StringUtils;

public class PatchInfoBuilder {
    private File patchFile;
    private Version minAppVersion;
    private Version postPatchAppVersion;
    private Version postPatchAppJavaVersion;
    private Version minPatcherJavaVersion;
    private long requiredDiskSpace;
    private OsType osType;
    private String appID;
    private String addonID;
    private Version minAppJavaVersion;
    private String newJavaPath;
    private Version postPatchAddonVersion;
    private Version addonApiVersion;
    private Version addonConfigVersion;

    public static PatchInfo buildPatchInfo(File patchJarFile, WrapperConf wrapperConf) throws PatchException {
        PatchInfoBuilder builder = new PatchInfoBuilder();
        try {
            builder.setMinAppVersion(PatchInfoBuilder.getVersion(wrapperConf, "ponton.app.min_version", true));
            builder.setPostPatchAppVersion(PatchInfoBuilder.getVersion(wrapperConf, "ponton.app.after_patch_version", false));
            builder.setPostPatchAppJavaVersion(PatchInfoBuilder.getVersion(wrapperConf, "ponton.app.java.after_patch_version", false));
            builder.setMinPatcherJavaVersion(PatchInfoBuilder.getVersion(wrapperConf, "ponton.patch.java.min_version", true));
            builder.setOSType(OsType.valueOf(wrapperConf.getProperty("ponton.os.type")));
            builder.setAppID(wrapperConf.getProperty("ponton.app.id"));
            builder.setAddonID(wrapperConf.getProperty("ponton.addon.id"));
            builder.setMinAppJavaVersion(PatchInfoBuilder.getVersion(wrapperConf, "ponton.app.java.min_version", false));
            builder.setNewJavaPath(wrapperConf.getProperty("ponton.new.java.path"));
            builder.setPostPatchAddonVersion(PatchInfoBuilder.getVersion(wrapperConf, "ponton.addon.after_patch_version", false));
            builder.setAddonApiVersion(PatchInfoBuilder.getVersion(wrapperConf, "ponton.addon.api_version", false));
            builder.setAddonConfigVersion(PatchInfoBuilder.getVersion(wrapperConf, "ponton.addon.config_version", false));
        }
        catch (ParseException e) {
            throw new PatchException("There was an error while reading the patch information: " + e.getMessage(), e);
        }
        builder.setPatchFile(patchJarFile);
        builder.setRequiredDisKSpace(patchJarFile.length() * 2L);
        return builder.build();
    }

    private static Version getVersion(WrapperConf wrapperConf, String propertyName, boolean required) throws PatchException, ParseException {
        String value = wrapperConf.getProperty(propertyName);
        if (StringUtils.isBlank(value)) {
            if (required) {
                throw new PatchException(String.format("The property '%s' is required.", propertyName));
            }
            return null;
        }
        return new Version(value);
    }

    public PatchInfo build() throws PatchException {
        return new PatchInfo(this.patchFile, this.minAppVersion, this.postPatchAppVersion, this.postPatchAppJavaVersion, this.minPatcherJavaVersion, this.requiredDiskSpace, this.osType, this.appID, this.addonID, this.minAppJavaVersion, this.newJavaPath, this.postPatchAddonVersion, this.addonApiVersion, this.addonConfigVersion);
    }

    public PatchInfoBuilder setPatchFile(File patchFile) {
        this.patchFile = patchFile;
        return this;
    }

    public PatchInfoBuilder setMinAppVersion(Version minAppVersion) {
        this.minAppVersion = minAppVersion;
        return this;
    }

    public PatchInfoBuilder setPostPatchAppVersion(Version postPatchAppVersion) {
        this.postPatchAppVersion = postPatchAppVersion;
        return this;
    }

    public PatchInfoBuilder setPostPatchAppJavaVersion(Version postPatchAppJavaVersion) {
        this.postPatchAppJavaVersion = postPatchAppJavaVersion;
        return this;
    }

    public PatchInfoBuilder setMinPatcherJavaVersion(Version minPatcherJavaVersion) {
        this.minPatcherJavaVersion = minPatcherJavaVersion;
        return this;
    }

    public PatchInfoBuilder setRequiredDisKSpace(long requiredDiskSpace) {
        this.requiredDiskSpace = requiredDiskSpace;
        return this;
    }

    public PatchInfoBuilder setOSType(OsType osType) {
        this.osType = osType;
        return this;
    }

    public PatchInfoBuilder setAppID(String appID) {
        this.appID = appID;
        return this;
    }

    public PatchInfoBuilder setAddonID(String addonID) {
        this.addonID = addonID;
        return this;
    }

    public PatchInfoBuilder setMinAppJavaVersion(Version minAppJavaVersion) {
        this.minAppJavaVersion = minAppJavaVersion;
        return this;
    }

    public PatchInfoBuilder setNewJavaPath(String newJavaPath) {
        this.newJavaPath = newJavaPath;
        return this;
    }

    public PatchInfoBuilder setPostPatchAddonVersion(Version postPatchAddonVersion) {
        this.postPatchAddonVersion = postPatchAddonVersion;
        return this;
    }

    public PatchInfoBuilder setAddonApiVersion(Version addonApiVersion) {
        this.addonApiVersion = addonApiVersion;
        return this;
    }

    public PatchInfoBuilder setAddonConfigVersion(Version addonConfigVersion) {
        this.addonConfigVersion = addonConfigVersion;
        return this;
    }
}

