/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.applicationpart.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;

public class PermissionChecker {
    private final Path rootDir;

    public PermissionChecker(Path rootDir) {
        this.rootDir = rootDir;
    }

    public void checkPermissions(Set<Path> paths) throws IOException {
        Files.walkFileTree(this.rootDir, new HashSet<FileVisitOption>(0), 0, new PermissionFileVisitor());
        for (Path path : paths) {
            Files.walkFileTree(path, new PermissionFileVisitor());
        }
    }

    class PermissionFileVisitor
    extends SimpleFileVisitor<Path> {
        PermissionFileVisitor() {
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.checkPermissions(dir, attrs);
            return FileVisitResult.CONTINUE;
        }

        private void checkPermissions(Path path, BasicFileAttributes attrs) throws IOException {
            boolean hasAllPermissions;
            if (attrs instanceof DosFileAttributes) {
                hasAllPermissions = !((DosFileAttributes)attrs).isReadOnly();
            } else if (attrs instanceof PosixFileAttributes) {
                Set<PosixFilePermission> permissions = ((PosixFileAttributes)attrs).permissions();
                hasAllPermissions = permissions.contains((Object)PosixFilePermission.OWNER_READ) && permissions.contains((Object)PosixFilePermission.OWNER_WRITE);
            } else {
                File file = path.toFile();
                boolean bl = hasAllPermissions = file.canRead() && file.canWrite();
            }
            if (!hasAllPermissions) {
                throw new IOException(path.toString() + " does not have read or write permission.");
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.checkPermissions(file, attrs);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.TERMINATE;
        }
    }
}

