/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaElementType;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DITContentRuleDefinition
extends SchemaElement {
    private static final long serialVersionUID = 3224440505307817586L;
    private final boolean isObsolete;
    @NotNull
    private final Map<String, String[]> extensions;
    @Nullable
    private final String description;
    @NotNull
    private final String ditContentRuleString;
    @NotNull
    private final String oid;
    @NotNull
    private final String[] auxiliaryClasses;
    @NotNull
    private final String[] names;
    @NotNull
    private final String[] optionalAttributes;
    @NotNull
    private final String[] prohibitedAttributes;
    @NotNull
    private final String[] requiredAttributes;

    public DITContentRuleDefinition(@NotNull String s) throws LDAPException {
        String descr;
        Boolean obsolete;
        LinkedHashMap<String, String[]> exts;
        ArrayList<String> auxOCs;
        ArrayList<String> notAttrs;
        ArrayList<String> optAttrs;
        ArrayList<String> reqAttrs;
        ArrayList<String> nameList;
        block22: {
            String token;
            Validator.ensureNotNull(s);
            this.ditContentRuleString = s.trim();
            int length = this.ditContentRuleString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_EMPTY.get());
            }
            if (this.ditContentRuleString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_NO_OPENING_PAREN.get(this.ditContentRuleString));
            }
            int pos = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = DITContentRuleDefinition.readOID(this.ditContentRuleString, pos, length, buffer);
            this.oid = buffer.toString();
            nameList = new ArrayList<String>(5);
            reqAttrs = new ArrayList<String>(10);
            optAttrs = new ArrayList<String>(10);
            notAttrs = new ArrayList<String>(10);
            auxOCs = new ArrayList<String>(10);
            exts = new LinkedHashMap<String, String[]>(StaticUtils.computeMapCapacity(5));
            obsolete = null;
            descr = null;
            while (true) {
                String lowerToken;
                int tokenStartPos = pos = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, pos, length);
                while (pos < length && this.ditContentRuleString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = this.ditContentRuleString.substring(tokenStartPos, pos);
                if (token.length() > 1 && token.endsWith(")")) {
                    token = token.substring(0, token.length() - 1);
                    --pos;
                }
                if ((lowerToken = StaticUtils.toLowerCase(token)).equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_CLOSE_NOT_AT_END.get(this.ditContentRuleString));
                    }
                    break block22;
                }
                if (lowerToken.equals("name")) {
                    if (nameList.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readQDStrings(this.ditContentRuleString, pos, length, token, nameList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "NAME"));
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, pos, length);
                        buffer = new StringBuilder();
                        pos = DITContentRuleDefinition.readQDString(this.ditContentRuleString, pos, length, token, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "DESC"));
                }
                if (lowerToken.equals("obsolete")) {
                    if (obsolete == null) {
                        obsolete = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "OBSOLETE"));
                }
                if (lowerToken.equals("aux")) {
                    if (auxOCs.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readOIDs(this.ditContentRuleString, pos, length, token, auxOCs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "AUX"));
                }
                if (lowerToken.equals("must")) {
                    if (reqAttrs.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readOIDs(this.ditContentRuleString, pos, length, token, reqAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "MUST"));
                }
                if (lowerToken.equals("may")) {
                    if (optAttrs.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readOIDs(this.ditContentRuleString, pos, length, token, optAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "MAY"));
                }
                if (lowerToken.equals("not")) {
                    if (notAttrs.isEmpty()) {
                        pos = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, pos, length);
                        pos = DITContentRuleDefinition.readOIDs(this.ditContentRuleString, pos, length, token, notAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "NOT"));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>(5);
                pos = DITContentRuleDefinition.readQDStrings(this.ditContentRuleString, pos, length, token, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_DUP_EXT.get(this.ditContentRuleString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_DUP_EXT.get(this.ditContentRuleString, token));
        }
        this.description = descr;
        this.names = new String[nameList.size()];
        nameList.toArray(this.names);
        this.auxiliaryClasses = new String[auxOCs.size()];
        auxOCs.toArray(this.auxiliaryClasses);
        this.requiredAttributes = new String[reqAttrs.size()];
        reqAttrs.toArray(this.requiredAttributes);
        this.optionalAttributes = new String[optAttrs.size()];
        optAttrs.toArray(this.optionalAttributes);
        this.prohibitedAttributes = new String[notAttrs.size()];
        notAttrs.toArray(this.prohibitedAttributes);
        this.isObsolete = obsolete != null;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public DITContentRuleDefinition(@NotNull String oid, @Nullable String name, @Nullable String description, @Nullable String[] auxiliaryClasses, @Nullable String[] requiredAttributes, @Nullable String[] optionalAttributes, @Nullable String[] prohibitedAttributes, @Nullable Map<String, String[]> extensions) {
        String[] stringArray;
        if (name == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        this(oid, stringArray, description, false, auxiliaryClasses, requiredAttributes, optionalAttributes, prohibitedAttributes, extensions);
    }

    public DITContentRuleDefinition(@NotNull String oid, @Nullable String name, @Nullable String description, @Nullable Collection<String> auxiliaryClasses, @Nullable Collection<String> requiredAttributes, @Nullable Collection<String> optionalAttributes, @Nullable Collection<String> prohibitedAttributes, @Nullable Map<String, String[]> extensions) {
        String[] stringArray;
        if (name == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        this(oid, stringArray, description, false, DITContentRuleDefinition.toArray(auxiliaryClasses), DITContentRuleDefinition.toArray(requiredAttributes), DITContentRuleDefinition.toArray(optionalAttributes), DITContentRuleDefinition.toArray(prohibitedAttributes), extensions);
    }

    public DITContentRuleDefinition(@NotNull String oid, @Nullable String[] names, @Nullable String description, boolean isObsolete, @Nullable String[] auxiliaryClasses, @Nullable String[] requiredAttributes, @Nullable String[] optionalAttributes, @Nullable String[] prohibitedAttributes, @Nullable Map<String, String[]> extensions) {
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.isObsolete = isObsolete;
        this.description = description;
        this.names = names == null ? StaticUtils.NO_STRINGS : names;
        this.auxiliaryClasses = auxiliaryClasses == null ? StaticUtils.NO_STRINGS : auxiliaryClasses;
        this.requiredAttributes = requiredAttributes == null ? StaticUtils.NO_STRINGS : requiredAttributes;
        this.optionalAttributes = optionalAttributes == null ? StaticUtils.NO_STRINGS : optionalAttributes;
        this.prohibitedAttributes = prohibitedAttributes == null ? StaticUtils.NO_STRINGS : prohibitedAttributes;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.ditContentRuleString = buffer.toString();
    }

    private void createDefinitionString(@NotNull StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.names.length == 1) {
            buffer.append(" NAME '");
            buffer.append(this.names[0]);
            buffer.append('\'');
        } else if (this.names.length > 1) {
            buffer.append(" NAME (");
            for (String name : this.names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        if (this.description != null) {
            buffer.append(" DESC '");
            DITContentRuleDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (this.auxiliaryClasses.length == 1) {
            buffer.append(" AUX ");
            buffer.append(this.auxiliaryClasses[0]);
        } else if (this.auxiliaryClasses.length > 1) {
            buffer.append(" AUX (");
            for (int i = 0; i < this.auxiliaryClasses.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.auxiliaryClasses[i]);
            }
            buffer.append(" )");
        }
        if (this.requiredAttributes.length == 1) {
            buffer.append(" MUST ");
            buffer.append(this.requiredAttributes[0]);
        } else if (this.requiredAttributes.length > 1) {
            buffer.append(" MUST (");
            for (int i = 0; i < this.requiredAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.requiredAttributes[i]);
            }
            buffer.append(" )");
        }
        if (this.optionalAttributes.length == 1) {
            buffer.append(" MAY ");
            buffer.append(this.optionalAttributes[0]);
        } else if (this.optionalAttributes.length > 1) {
            buffer.append(" MAY (");
            for (int i = 0; i < this.optionalAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.optionalAttributes[i]);
            }
            buffer.append(" )");
        }
        if (this.prohibitedAttributes.length == 1) {
            buffer.append(" NOT ");
            buffer.append(this.prohibitedAttributes[0]);
        } else if (this.prohibitedAttributes.length > 1) {
            buffer.append(" NOT (");
            for (int i = 0; i < this.prohibitedAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.prohibitedAttributes[i]);
            }
            buffer.append(" )");
        }
        for (Map.Entry entry : this.extensions.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                DITContentRuleDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                DITContentRuleDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    @NotNull
    public String getOID() {
        return this.oid;
    }

    @NotNull
    public String[] getNames() {
        return this.names;
    }

    @NotNull
    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(@NotNull String s) {
        for (String name : this.names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return s.equalsIgnoreCase(this.oid);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @NotNull
    public String[] getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    @NotNull
    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    @NotNull
    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    @NotNull
    public String[] getProhibitedAttributes() {
        return this.prohibitedAttributes;
    }

    @NotNull
    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    @NotNull
    public SchemaElementType getSchemaElementType() {
        return SchemaElementType.DIT_CONTENT_RULE;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof DITContentRuleDefinition)) {
            return false;
        }
        DITContentRuleDefinition d = (DITContentRuleDefinition)o;
        return this.oid.equals(d.oid) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, d.names) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.auxiliaryClasses, d.auxiliaryClasses) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.requiredAttributes, d.requiredAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.optionalAttributes, d.optionalAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.prohibitedAttributes, d.prohibitedAttributes) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, d.description) && this.isObsolete == d.isObsolete && DITContentRuleDefinition.extensionsEqual(this.extensions, d.extensions);
    }

    @Override
    @NotNull
    public String toString() {
        return this.ditContentRuleString;
    }
}

