/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal.messages;

import de.ponton.xp.adapter.api.domainvalues.SerializeableDomainValue;
import de.ponton.xp.adapter.api.domainvalues.TransferId;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.StatusUpdateResponseEnum;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessage;
import de.ponton.xp.adapter.api.internal.messages.ProtocolMessageTypeEnum;

public class ProtocolOutboundMessageResponse
extends ProtocolMessage {
    public static ProtocolOutboundMessageResponseBuilder createBuilder() {
        return new ProtocolOutboundMessageResponseBuilder();
    }

    private ProtocolOutboundMessageResponse(TransferId transferId, StatusUpdateResponseEnum result, String resultText) {
        super(ProtocolMessageTypeEnum.OutboundMessageResponse);
        this.setDomainValueProperty(AdapterPropertiesEnum.TRANSFER_ID.toString(), (SerializeableDomainValue)transferId);
        this.setProperty(AdapterPropertiesEnum.RESULT, result.name());
        if (resultText != null && resultText.trim().length() > 0) {
            this.setProperty(AdapterPropertiesEnum.RESULT_DETAIL_TEXT, resultText);
        }
    }

    public static class ProtocolOutboundMessageResponseBuilder {
        TransferId transferId;
        StatusUpdateResponseEnum result;
        String resultText;

        public ProtocolOutboundMessageResponseBuilder setTransferId(TransferId transferId) {
            this.transferId = transferId;
            return this;
        }

        public ProtocolOutboundMessageResponseBuilder setResult(StatusUpdateResponseEnum result) {
            this.result = result;
            return this;
        }

        public ProtocolOutboundMessageResponseBuilder setResultText(String resultText) {
            this.resultText = resultText;
            return this;
        }

        public ProtocolOutboundMessageResponse build() {
            return new ProtocolOutboundMessageResponse(this.transferId, this.result, this.resultText);
        }
    }
}

