/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.AdapterStatusRequestHandler;
import de.ponton.xp.adapter.api.ArchiveHandler;
import de.ponton.xp.adapter.api.ConnectionException;
import de.ponton.xp.adapter.api.ConnectionStatusChangeHandler;
import de.ponton.xp.adapter.api.ErrorNotificationHandler;
import de.ponton.xp.adapter.api.MessageHandler;
import de.ponton.xp.adapter.api.OutboundMessageStatusUpdateHandler;
import de.ponton.xp.adapter.api.domainvalues.AdapterInfo;
import de.ponton.xp.adapter.api.domainvalues.MessengerInstance;
import de.ponton.xp.adapter.api.internal.ApiX509ExtendedTrustManager;
import de.ponton.xp.adapter.api.internal.ArchiveWebSocketConnectionFactory;
import de.ponton.xp.adapter.api.internal.ConnectionCountWatcher;
import de.ponton.xp.adapter.api.internal.InboundWebSocketConnectionFactory;
import de.ponton.xp.adapter.api.internal.OutboundWebSocketConnectionFactory;
import de.ponton.xp.adapter.api.internal.PontonThreadFactory;
import de.ponton.xp.adapter.api.internal.WebSocketConnectionBundle;
import de.ponton.xp.adapter.api.internal.WebSocketConnectionPool;
import de.ponton.xp.adapter.api.internal.security.Signer;
import de.ponton.xp.adapter.api.internal.security.UniqueId;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;

public class WebSocketConnectionBundleFactory {
    public List<WebSocketConnectionBundle> connect(List<MessengerInstance> messengerInstances, MessageHandler messageHandler, OutboundMessageStatusUpdateHandler outboundMessageStatusUpdateHandler, ErrorNotificationHandler errorNotificationHandler, AdapterStatusRequestHandler adapterStatusRequestHandler, ArchiveHandler archiveHandler, File workFolder, UniqueId uniqueId, Signer signer, AdapterInfo adapterInfo, ConnectionStatusChangeHandler connectionStatusChangeHandler) throws ConnectionException {
        this.checkWorkFolderStructure(workFolder);
        ExecutorService executor = Executors.newCachedThreadPool(new PontonThreadFactory("WebSocket-HttpClient-"));
        ArrayList<WebSocketConnectionBundle> webSocketConnectionBundles = new ArrayList<WebSocketConnectionBundle>();
        for (MessengerInstance messengerInstance : messengerInstances) {
            try {
                String[] cipherSuites = SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites();
                String[] protocols = new String[]{"TLSv1.2"};
                SSLParameters sslParameters = new SSLParameters(cipherSuites, protocols);
                HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).connectTimeout(Duration.ofSeconds(60L)).proxy(HttpClient.Builder.NO_PROXY).executor(executor).sslContext(this.createTrustAllSslContext()).sslParameters(sslParameters).build();
                OutboundWebSocketConnectionFactory outboundWebSocketConnectionFactory = new OutboundWebSocketConnectionFactory(httpClient, messengerInstance.getHostname(), messengerInstance.getPort(), uniqueId, signer, adapterInfo);
                Path inboundWorkFolder = workFolder.toPath().resolve(Paths.get("inbound", new String[0]));
                InboundWebSocketConnectionFactory inboundWebSocketConnectionFactory = new InboundWebSocketConnectionFactory(inboundWorkFolder, messageHandler, outboundMessageStatusUpdateHandler, errorNotificationHandler, adapterStatusRequestHandler, httpClient, messengerInstance.getHostname(), messengerInstance.getPort(), uniqueId, signer, adapterInfo);
                Path archiveWorkFolder = workFolder.toPath().resolve(Paths.get("archive", new String[0]));
                ArchiveWebSocketConnectionFactory archiveWebSocketConnectionFactory = new ArchiveWebSocketConnectionFactory(archiveWorkFolder, archiveHandler, httpClient, messengerInstance.getHostname(), messengerInstance.getPort(), uniqueId, signer, adapterInfo);
                ConnectionCountWatcher connectionCountWatcher = new ConnectionCountWatcher(messengerInstance, connectionStatusChangeHandler);
                WebSocketConnectionPool outboundConnectionPool = new WebSocketConnectionPool(outboundWebSocketConnectionFactory, messengerInstance.getOutboundParallelConnections(), connectionCountWatcher::publishTotalOutboundConnectionCount);
                WebSocketConnectionPool inboundConnectionPool = new WebSocketConnectionPool(inboundWebSocketConnectionFactory, adapterInfo.isSupportInboundMessage() ? messengerInstance.getInboundParallelConnections() : 0, connectionCountWatcher::publishTotalInboundConnectionCount);
                WebSocketConnectionPool archiveConnectionPool = new WebSocketConnectionPool(archiveWebSocketConnectionFactory, adapterInfo.isSupportArchiving() ? messengerInstance.getArchiveParallelConnections() : 0, connectionCountWatcher::publishTotalArchiveConnectionCount);
                webSocketConnectionBundles.add(new WebSocketConnectionBundle(outboundConnectionPool, inboundConnectionPool, archiveConnectionPool));
            }
            catch (URISyntaxException | GeneralSecurityException e) {
                throw new ConnectionException("Could not initialize websocket connection.", e);
            }
            catch (CompletionException e) {
                throw new ConnectionException("Could not initialize websocket connection.", e.getCause());
            }
        }
        return webSocketConnectionBundles;
    }

    private void checkWorkFolderStructure(File workFolder) {
        if (workFolder.isFile() || !workFolder.exists()) {
            throw new IllegalArgumentException("The work folder '" + workFolder.getAbsolutePath() + "' does not exist.");
        }
        Path inboundWorkFolder = workFolder.toPath().resolve(Paths.get("inbound", new String[0]));
        if (Files.notExists(inboundWorkFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(inboundWorkFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not create the subdirectory '" + String.valueOf(inboundWorkFolder) + "': " + String.valueOf(e));
            }
        } else if (Files.isRegularFile(inboundWorkFolder, new LinkOption[0])) {
            throw new IllegalArgumentException("The following path is not a directory '" + String.valueOf(inboundWorkFolder) + "'.");
        }
        Path archiveWorkFolder = workFolder.toPath().resolve(Paths.get("archive", new String[0]));
        if (Files.notExists(archiveWorkFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(archiveWorkFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not create the subdirectory '" + String.valueOf(archiveWorkFolder) + "': " + String.valueOf(e));
            }
        } else if (Files.isRegularFile(archiveWorkFolder, new LinkOption[0])) {
            throw new IllegalArgumentException("The following path is not a directory '" + String.valueOf(archiveWorkFolder) + "'.");
        }
    }

    private SSLContext createTrustAllSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new ApiX509ExtendedTrustManager()};
        SSLContext trustAllSslContext = SSLContext.getInstance("SSL");
        trustAllSslContext.init(null, trustAllCerts, new SecureRandom());
        return trustAllSslContext;
    }
}

