/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.ArchivePropertiesEnum;
import de.ponton.xp.adapter.api.internal.MetaDataPropertiesEnum;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class SimpleProperties {
    private static final String CRLF = "\r\n";
    private static final String SEPARATOR = " = ";
    private static final String ESC_LN = "~\\u000a~";
    private static final String ESC_CR = "~\\u000d~";
    private final TreeMap<String, String> properties = new TreeMap();

    public void store(OutputStream out, String comments) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        if (comments != null) {
            writer.write("# " + comments);
            writer.write(CRLF);
        }
        for (Map.Entry<String, String> x : this.properties.entrySet()) {
            writer.write(x.getKey() + SEPARATOR + this.escapeLineBreaks(x.getValue()));
            writer.write(CRLF);
        }
        writer.flush();
    }

    public String getWireFormat() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.store(out, "no comments");
        return out.toString(StandardCharsets.UTF_8);
    }

    private String escapeLineBreaks(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("\r", ESC_CR).replace("\n", ESC_LN);
    }

    private String getRealValue(String value) {
        if (value == null) {
            return null;
        }
        return value.replace(ESC_CR, "\r").replace(ESC_LN, "\n");
    }

    public void load(String toString) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(toString.getBytes(StandardCharsets.UTF_8));){
            this.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid data format", e);
        }
    }

    public void load(InputStream in) throws IOException {
        String line;
        this.properties.clear();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            int index = line.indexOf(SEPARATOR);
            String key = line.substring(0, index);
            String value = this.getRealValue(line.substring(index + SEPARATOR.length()));
            this.properties.put(key, value);
        }
    }

    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }

    public boolean containsProperty(AdapterPropertiesEnum key) {
        return this.containsProperty(key.toString());
    }

    public boolean containsProperty(MetaDataPropertiesEnum key) {
        return this.containsProperty(key.toString());
    }

    public boolean containsProperty(ArchivePropertiesEnum key) {
        return this.containsProperty(key.toString());
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProperty(AdapterPropertiesEnum key) {
        return this.getProperty(key.toString());
    }

    public String getProperty(ArchivePropertiesEnum key) {
        return this.getProperty(key.toString());
    }

    public String getProperty(MetaDataPropertiesEnum key) {
        return this.getProperty(key.toString());
    }

    public String setProperty(String key, String value) {
        return this.properties.put(key, value == null ? "" : value);
    }

    public String setProperty(String key, String value, String defaultValue) {
        if (Objects.isNull(value)) {
            return this.setProperty(key, defaultValue);
        }
        return this.setProperty(key, value);
    }

    public String setProperty(AdapterPropertiesEnum key, String value) {
        return this.setProperty(key.toString(), value);
    }

    public String setProperty(AdapterPropertiesEnum key, String value, String defaultValue) {
        return this.setProperty(key.toString(), value, defaultValue);
    }

    public String setProperty(MetaDataPropertiesEnum key, String value) {
        return this.setProperty(key.toString(), value);
    }

    public String setProperty(MetaDataPropertiesEnum key, String value, String defaultValue) {
        return this.setProperty(key.toString(), value, defaultValue);
    }

    public String setProperty(ArchivePropertiesEnum key, String value) {
        return this.setProperty(key.toString(), value);
    }

    public String setProperty(ArchivePropertiesEnum key, String value, String defaultValue) {
        return this.setProperty(key.toString(), value, defaultValue);
    }

    public String getProperty(String key, String defaultValue) {
        return Objects.requireNonNullElse(this.getProperty(key), defaultValue);
    }

    public String getProperty(AdapterPropertiesEnum key, String defaultValue) {
        return Objects.requireNonNullElse(this.getProperty(key), defaultValue);
    }

    public String getProperty(ArchivePropertiesEnum key, String defaultValue) {
        return Objects.requireNonNullElse(this.getProperty(key), defaultValue);
    }

    public Map<String, String> getProperties(MetaDataPropertiesEnum key) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (key != null) {
            String keyPrefix = key.toString();
            int i = 1;
            while (true) {
                String propertyKey = this.properties.get(keyPrefix + "." + i + ".key");
                String propertyValue = Objects.requireNonNullElse(this.properties.get(keyPrefix + "." + i + ".value"), "");
                if (Objects.isNull(propertyKey)) break;
                result.put(propertyKey, propertyValue);
                ++i;
            }
        }
        return result;
    }

    public void setProperties(MetaDataPropertiesEnum key, Map<String, String> entries) {
        if (key != null) {
            String keyPrefix = key.toString();
            int i = 1;
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                this.properties.put(keyPrefix + "." + i + ".key", entry.getKey());
                this.properties.put(keyPrefix + "." + i + ".value", entry.getValue());
                ++i;
            }
        }
    }
}

