/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.MessageHandler;
import de.ponton.xp.adapter.api.domainvalues.ConversationId;
import de.ponton.xp.adapter.api.domainvalues.CreationTime;
import de.ponton.xp.adapter.api.domainvalues.Filename;
import de.ponton.xp.adapter.api.domainvalues.InboundStatusEnum;
import de.ponton.xp.adapter.api.domainvalues.LogInfo;
import de.ponton.xp.adapter.api.domainvalues.MessageId;
import de.ponton.xp.adapter.api.domainvalues.MessageType;
import de.ponton.xp.adapter.api.domainvalues.MessageTypeName;
import de.ponton.xp.adapter.api.domainvalues.MessageTypeVersion;
import de.ponton.xp.adapter.api.domainvalues.MessageUniqueId;
import de.ponton.xp.adapter.api.domainvalues.MimeType;
import de.ponton.xp.adapter.api.domainvalues.PayloadSize;
import de.ponton.xp.adapter.api.domainvalues.ProcessingDirective;
import de.ponton.xp.adapter.api.domainvalues.ReceiverId;
import de.ponton.xp.adapter.api.domainvalues.SchemaSet;
import de.ponton.xp.adapter.api.domainvalues.SenderId;
import de.ponton.xp.adapter.api.domainvalues.SequenceNumber;
import de.ponton.xp.adapter.api.domainvalues.internal.InboundMetaDataImpl;
import de.ponton.xp.adapter.api.domainvalues.internal.ReceptionTimeImpl;
import de.ponton.xp.adapter.api.internal.AdapterPropertiesEnum;
import de.ponton.xp.adapter.api.internal.ByteBufferBackedInputStream;
import de.ponton.xp.adapter.api.internal.MetaDataPropertiesEnum;
import de.ponton.xp.adapter.api.internal.SimpleProperties;
import de.ponton.xp.adapter.api.internal.messages.ProtocolInboundMessageStatusUpdate;
import de.ponton.xp.adapter.api.messages.InboundMessageStatusUpdate;
import de.ponton.xp.adapter.api.messages.internal.InboundMessageImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

class InboundMessageHandler {
    private static final Logger LOG = Logger.getLogger(InboundMessageHandler.class.getName());
    private final MessageHandler messageHandler;
    private final Path inboundWorkFolder;
    private SimpleProperties properties;
    private Path dataPath;
    private OutputStream dataStream;

    InboundMessageHandler(MessageHandler messageHandler, Path inboundWorkFolder) {
        this.messageHandler = messageHandler;
        this.inboundWorkFolder = inboundWorkFolder;
    }

    void handleOnText(SimpleProperties properties, WebSocket webSocket) {
        this.properties = properties;
        try {
            this.dataPath = Files.createTempFile(this.inboundWorkFolder, "inbound-message_", ".dat", new FileAttribute[0]);
            this.dataStream = Files.newOutputStream(this.dataPath, new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "could not create temp file " + String.valueOf(this.dataPath) + ": " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOnBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        block11: {
            try {
                ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(data);
                inputStream.transferTo(this.dataStream);
                if (!last) break block11;
                this.dataStream.close();
                LOG.log(Level.FINE, "received " + Files.size(this.dataPath) + " bytes");
                InboundMessageImpl inboundMessage = this.createInboundMessage();
                try {
                    InboundMessageStatusUpdate inboundMessageStatusUpdate = this.messageHandler == null ? InboundMessageStatusUpdate.newBuilder().setInboundMessage(inboundMessage).setStatus(InboundStatusEnum.REJECTED).setStatusText("Adapter ignores inbound messages").build() : this.messageHandler.onMessage(inboundMessage);
                    this.sendResponse(webSocket, inboundMessageStatusUpdate);
                }
                finally {
                    inboundMessage.purge();
                    try {
                        Files.deleteIfExists(this.dataPath);
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "could not delete temp file " + String.valueOf(this.dataPath) + ": " + e.toString());
                    }
                }
            }
            catch (IOException e) {
                LOG.log(Level.FINE, "could not write to temp file " + String.valueOf(this.dataPath) + ": " + e.toString());
                if (last) {
                    LOG.log(Level.SEVERE, "could not write to temp file " + String.valueOf(this.dataPath) + ": " + e.toString());
                    this.sendTempError(webSocket, e);
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "could not process inbound message.", e);
                if (!last) break block11;
                LOG.log(Level.SEVERE, "could not process inbound message.", e);
                this.sendTempError(webSocket, e);
            }
        }
    }

    private void sendResponse(WebSocket webSocket, InboundMessageStatusUpdate inboundMessageStatusUpdate) {
        ProtocolInboundMessageStatusUpdate protocolInboundMessageStatusUpdate = ProtocolInboundMessageStatusUpdate.createBuilder().setInboundMessageStatusUpdate(inboundMessageStatusUpdate).build();
        webSocket.sendText(protocolInboundMessageStatusUpdate.toWireFormat(), true);
    }

    private void sendTempError(WebSocket webSocket, Exception e) {
        InboundMessageImpl inboundMessage = this.createInboundMessage();
        InboundMessageStatusUpdate inboundMessageStatusUpdate = InboundMessageStatusUpdate.newBuilder().setInboundMessage(inboundMessage).setStatus(InboundStatusEnum.TEMPORARY_ERROR).setStatusText("Error occurs while receiving data: " + e.toString()).build();
        this.sendResponse(webSocket, inboundMessageStatusUpdate);
    }

    private List<ProcessingDirective> getProcessingDirectives() {
        ArrayList<ProcessingDirective> processingDirectives = new ArrayList<ProcessingDirective>();
        Map<String, String> processingDirectiveValues = this.properties.getProperties(MetaDataPropertiesEnum.PROCESSING_DIRECTIVE);
        for (Map.Entry<String, String> entry : processingDirectiveValues.entrySet()) {
            processingDirectives.add(ProcessingDirective.create(entry.getKey(), entry.getValue()));
        }
        return processingDirectives;
    }

    private InboundMessageImpl createInboundMessage() {
        InboundMetaDataImpl.InboundMetaDataBuilder inboundMetaDataBuilder = (InboundMetaDataImpl.InboundMetaDataBuilder)((InboundMetaDataImpl.InboundMetaDataBuilder)((InboundMetaDataImpl.InboundMetaDataBuilder)((InboundMetaDataImpl.InboundMetaDataBuilder)((InboundMetaDataImpl.InboundMetaDataBuilder)((InboundMetaDataImpl.InboundMetaDataBuilder)((InboundMetaDataImpl.InboundMetaDataBuilder)((InboundMetaDataImpl.InboundMetaDataBuilder)((InboundMetaDataImpl.InboundMetaDataBuilder)((InboundMetaDataImpl.InboundMetaDataBuilder)InboundMetaDataImpl.newBuilder().setMessageUniqueId(new MessageUniqueId(Long.parseLong(this.properties.getProperty(MetaDataPropertiesEnum.MESSAGE_UNIQUE_ID)))).setSenderId(new SenderId(this.properties.getProperty(MetaDataPropertiesEnum.SENDER_ID)))).setReceiverId(new ReceiverId(this.properties.getProperty(MetaDataPropertiesEnum.RECEIVER_ID)))).setMessageId(new MessageId(this.properties.getProperty(MetaDataPropertiesEnum.MESSAGE_ID)))).setConversationId(new ConversationId(this.properties.getProperty(MetaDataPropertiesEnum.CONVERSATION_ID)))).setMessageType(MessageType.newBuilder().setName(new MessageTypeName(this.properties.getProperty(MetaDataPropertiesEnum.MESSAGE_TYPE))).setVersion(new MessageTypeVersion(this.properties.getProperty(MetaDataPropertiesEnum.MESSAGE_VERSION))).setSchemaSet(new SchemaSet(this.properties.getProperty(MetaDataPropertiesEnum.SCHEMA_SET))).setName(new MessageTypeName(this.properties.getProperty(MetaDataPropertiesEnum.MESSAGE_TYPE_DISPLAY_NAME))).setMimeType(new MimeType(this.properties.getProperty(MetaDataPropertiesEnum.MIME_TYPE))).build())).setCreationTime(new CreationTime(Instant.ofEpochMilli(Long.parseLong(this.properties.getProperty(MetaDataPropertiesEnum.CREATION_TIME)))))).setReceptionTime(new ReceptionTimeImpl(Instant.ofEpochMilli(Long.parseLong(this.properties.getProperty(MetaDataPropertiesEnum.RECEPTION_TIME))))).setSequenceNumber(new SequenceNumber(Integer.parseInt(this.properties.getProperty(MetaDataPropertiesEnum.SEQUENCE_NUMBER))))).setOriginalFilename(new Filename(this.properties.getProperty(MetaDataPropertiesEnum.FILENAME)))).setPayloadSize(new PayloadSize(Integer.parseInt(this.properties.getProperty(AdapterPropertiesEnum.CONTENT_LENGTH))))).addProcessingDirectives((List)this.getProcessingDirectives());
        if (Objects.nonNull(this.properties.getProperty(MetaDataPropertiesEnum.LOG_INFO))) {
            inboundMetaDataBuilder.setLogInfo(new LogInfo(this.properties.getProperty(MetaDataPropertiesEnum.LOG_INFO)));
        }
        InboundMetaDataImpl inboundMetaData = inboundMetaDataBuilder.build();
        return InboundMessageImpl.newBuilder().setInboundMetaData(inboundMetaData).setPath(this.dataPath).build();
    }

    void purge() {
        if (this.dataStream != null) {
            try {
                this.dataStream.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "could not close data stream: " + e.toString());
            }
        }
        if (this.dataPath != null) {
            try {
                Files.deleteIfExists(this.dataPath);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "could not delete temp file " + String.valueOf(this.dataPath) + ": " + e.toString());
            }
        }
    }
}

