/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.internal;

import de.ponton.xp.adapter.api.ArchiveHandler;
import de.ponton.xp.adapter.api.ConnectionException;
import de.ponton.xp.adapter.api.domainvalues.AdapterInfo;
import de.ponton.xp.adapter.api.internal.ArchiveWebSocketConnection;
import de.ponton.xp.adapter.api.internal.ArchiveWebSocketEndpoint;
import de.ponton.xp.adapter.api.internal.OnCloseListener;
import de.ponton.xp.adapter.api.internal.WebSocketConnection;
import de.ponton.xp.adapter.api.internal.WebSocketConnectionFactory;
import de.ponton.xp.adapter.api.internal.security.Signer;
import de.ponton.xp.adapter.api.internal.security.UniqueId;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;

public class ArchiveWebSocketConnectionFactory
implements WebSocketConnectionFactory {
    private static final Logger LOG = Logger.getLogger(ArchiveWebSocketConnectionFactory.class.getName());
    private final Path archiveWorkFolder;
    private final ArchiveHandler archiveHandler;
    private final UniqueId uniqueId;
    private final Signer signer;
    private final AdapterInfo adapterInfo;
    private final HttpClient httpClient;
    private final String hostname;
    private final int port;

    ArchiveWebSocketConnectionFactory(Path archiveWorkFolder, ArchiveHandler archiveHandler, HttpClient httpClient, String hostname, int port, UniqueId uniqueId, Signer signer, AdapterInfo adapterInfo) {
        this.archiveWorkFolder = archiveWorkFolder;
        this.archiveHandler = archiveHandler;
        this.httpClient = httpClient;
        this.hostname = hostname;
        this.port = port;
        this.uniqueId = uniqueId;
        this.signer = signer;
        this.adapterInfo = adapterInfo;
    }

    @Override
    public WebSocketConnection create(OnCloseListener listener) throws ConnectionException, URISyntaxException {
        ArchiveWebSocketEndpoint archiveWebSocketEndpoint = new ArchiveWebSocketEndpoint(this.archiveWorkFolder, this.archiveHandler, this.uniqueId, this.signer, this.adapterInfo, listener);
        WebSocket archiveWebSocket = this.init(archiveWebSocketEndpoint);
        return new ArchiveWebSocketConnection(archiveWebSocket, archiveWebSocketEndpoint);
    }

    private WebSocket init(ArchiveWebSocketEndpoint archiveWebSocketEndpoint) throws URISyntaxException, ConnectionException {
        WebSocket webSocket;
        URI archiveUri = new URI("wss", null, this.hostname, this.port, "/archive", null, null);
        CompletableFuture<WebSocket> future = this.httpClient.newWebSocketBuilder().header("User-Agent", "PONTON XP Adapter API").connectTimeout(Duration.ofSeconds(10L)).buildAsync(archiveUri, archiveWebSocketEndpoint);
        LOG.fine(() -> "Waiting for websocket connect to " + String.valueOf(archiveUri));
        try {
            webSocket = future.join();
        }
        catch (CompletionException e) {
            Exception cause = this.findRootCause(e);
            throw new ConnectionException("Could not establish archive connection (" + this.hostname + ":" + this.port + "): " + cause.getMessage(), cause);
        }
        LOG.fine(() -> "Waiting for authentication on " + String.valueOf(webSocket));
        archiveWebSocketEndpoint.waitForAuthentication();
        return webSocket;
    }

    private Exception findRootCause(Exception e) {
        if (e.getCause() instanceof Exception) {
            return this.findRootCause((Exception)e.getCause());
        }
        return e;
    }
}

