/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xp.adapter.api.domainvalues.internal;

import de.ponton.xp.adapter.api.domainvalues.ConversationId;
import de.ponton.xp.adapter.api.domainvalues.CreationTime;
import de.ponton.xp.adapter.api.domainvalues.Filename;
import de.ponton.xp.adapter.api.domainvalues.LogInfo;
import de.ponton.xp.adapter.api.domainvalues.MessageId;
import de.ponton.xp.adapter.api.domainvalues.MessageType;
import de.ponton.xp.adapter.api.domainvalues.PayloadSize;
import de.ponton.xp.adapter.api.domainvalues.ProcessingDirective;
import de.ponton.xp.adapter.api.domainvalues.ReceiverId;
import de.ponton.xp.adapter.api.domainvalues.SenderId;
import de.ponton.xp.adapter.api.domainvalues.SequenceNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MetaData {
    private final ReceiverId receiverId;
    private final SenderId senderId;
    private final MessageId messageId;
    private final ConversationId conversationId;
    private final SequenceNumber sequenceNumber;
    private final CreationTime creationTime;
    private final Filename filename;
    private final Map<String, ProcessingDirective> processingDirectives = new HashMap<String, ProcessingDirective>(1);
    private final MessageType messageType;
    private final PayloadSize payloadSize;
    private final LogInfo logInfo;

    protected MetaData(PayloadSize payloadSize, ReceiverId receiverId, SenderId senderId, MessageId messageId, ConversationId conversationId, SequenceNumber sequenceNumber, CreationTime creationTime, Filename filename, List<ProcessingDirective> processingDirectives, MessageType messageType, LogInfo logInfo) {
        this.payloadSize = payloadSize;
        this.receiverId = receiverId;
        this.senderId = senderId;
        this.messageId = messageId;
        this.conversationId = conversationId;
        this.sequenceNumber = sequenceNumber;
        this.creationTime = creationTime;
        this.filename = filename;
        this.logInfo = logInfo;
        for (ProcessingDirective processingDirective : processingDirectives) {
            this.processingDirectives.put(processingDirective.getName(), processingDirective);
        }
        this.messageType = messageType;
    }

    public PayloadSize getPayloadSize() {
        return this.payloadSize;
    }

    public ReceiverId getReceiverId() {
        return this.receiverId;
    }

    public SenderId getSenderId() {
        return this.senderId;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public ConversationId getConversationId() {
        return this.conversationId;
    }

    public SequenceNumber getSequenceNumber() {
        return this.sequenceNumber;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public CreationTime getCreationTime() {
        return this.creationTime;
    }

    public Map<String, ProcessingDirective> getProcessingDirectives() {
        return Collections.unmodifiableMap(this.processingDirectives);
    }

    public ProcessingDirective getProcessingDirective(String key) {
        return this.processingDirectives.get(key);
    }

    public Filename getOriginalFilename() {
        return this.filename;
    }

    public LogInfo getLogInfo() {
        return this.logInfo;
    }

    protected static abstract class MetaDataBuilder<T extends MetaDataBuilder> {
        protected PayloadSize payloadSize;
        protected ReceiverId receiverId;
        protected SenderId senderId;
        protected MessageId messageId;
        protected ConversationId conversationId;
        protected SequenceNumber sequenceNumber;
        protected CreationTime creationTime;
        protected Filename filename;
        protected List<ProcessingDirective> processingDirectives = new ArrayList<ProcessingDirective>();
        protected MessageType messageType;
        protected LogInfo logInfo;

        protected MetaDataBuilder() {
        }

        public T setPayloadSize(PayloadSize payloadSize) {
            this.payloadSize = payloadSize;
            return (T)this;
        }

        public T setReceiverId(ReceiverId receiverId) {
            this.receiverId = receiverId;
            return (T)this;
        }

        public T setSenderId(SenderId senderId) {
            this.senderId = senderId;
            return (T)this;
        }

        public T setMessageId(MessageId messageId) {
            this.messageId = messageId;
            return (T)this;
        }

        public T setConversationId(ConversationId conversationId) {
            this.conversationId = conversationId;
            return (T)this;
        }

        public T setSequenceNumber(SequenceNumber sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return (T)this;
        }

        public T setCreationTime(CreationTime creationTime) {
            this.creationTime = creationTime;
            return (T)this;
        }

        public T setOriginalFilename(Filename filename) {
            this.filename = filename;
            return (T)this;
        }

        public T addProcessingDirective(ProcessingDirective processingDirective) {
            this.processingDirectives.add(processingDirective);
            return (T)this;
        }

        public T addProcessingDirectives(List<ProcessingDirective> processingDirectives) {
            this.processingDirectives.addAll(processingDirectives);
            return (T)this;
        }

        public T setMessageType(MessageType messageType) {
            this.messageType = messageType;
            return (T)this;
        }

        public T setLogInfo(LogInfo logInfo) {
            this.logInfo = logInfo;
            return (T)this;
        }
    }
}

