/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config.server;

import de.pontonconsulting.xmlpipe.config.server.ClientAuthType;
import de.pontonconsulting.xmlpipe.config.server.LogLevel;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"logging", "folders", "connector", "securitySettings", "adapterInterface"})
@XmlRootElement(name="Server")
public class Server {
    @XmlElement(name="Logging", required=true)
    protected Logging logging;
    @XmlElement(name="Folders", required=true)
    protected Folders folders;
    @XmlElement(name="Connector", required=true)
    protected List<Connector> connector;
    @XmlElement(name="SecuritySettings")
    protected SecuritySettings securitySettings;
    @XmlElement(name="AdapterInterface")
    protected AdapterInterface adapterInterface;
    @XmlAttribute(name="Port", required=true)
    protected int port;

    public Logging getLogging() {
        return this.logging;
    }

    public void setLogging(Logging value) {
        this.logging = value;
    }

    public Folders getFolders() {
        return this.folders;
    }

    public void setFolders(Folders value) {
        this.folders = value;
    }

    public List<Connector> getConnector() {
        if (this.connector == null) {
            this.connector = new ArrayList<Connector>();
        }
        return this.connector;
    }

    public SecuritySettings getSecuritySettings() {
        return this.securitySettings;
    }

    public void setSecuritySettings(SecuritySettings value) {
        this.securitySettings = value;
    }

    public AdapterInterface getAdapterInterface() {
        return this.adapterInterface;
    }

    public void setAdapterInterface(AdapterInterface value) {
        this.adapterInterface = value;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        this.port = value;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"serverLogLevel", "messengerLogLevel", "jdbcLogLevel"})
    public static class Logging {
        @XmlElement(name="ServerLogLevel", required=true)
        @XmlSchemaType(name="string")
        protected LogLevel serverLogLevel;
        @XmlElement(name="MessengerLogLevel", required=true)
        @XmlSchemaType(name="string")
        protected LogLevel messengerLogLevel;
        @XmlElement(name="JDBCLogLevel", required=true)
        @XmlSchemaType(name="string")
        protected LogLevel jdbcLogLevel;

        public LogLevel getServerLogLevel() {
            return this.serverLogLevel;
        }

        public void setServerLogLevel(LogLevel value) {
            this.serverLogLevel = value;
        }

        public LogLevel getMessengerLogLevel() {
            return this.messengerLogLevel;
        }

        public void setMessengerLogLevel(LogLevel value) {
            this.messengerLogLevel = value;
        }

        public LogLevel getJDBCLogLevel() {
            return this.jdbcLogLevel;
        }

        public void setJDBCLogLevel(LogLevel value) {
            this.jdbcLogLevel = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"logFolder", "tempFolder"})
    public static class Folders {
        @XmlElement(name="LogFolder", required=true)
        protected String logFolder;
        @XmlElement(name="TempFolder", required=true)
        protected String tempFolder;

        public String getLogFolder() {
            return this.logFolder;
        }

        public void setLogFolder(String value) {
            this.logFolder = value;
        }

        public String getTempFolder() {
            return this.tempFolder;
        }

        public void setTempFolder(String value) {
            this.tempFolder = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"userPasswordValidity", "userAccountLockDuration", "maxFailedLoginAttempts", "enforceTwoFactors"})
    public static class SecuritySettings {
        @XmlElement(name="UserPasswordValidity", defaultValue="365")
        protected int userPasswordValidity;
        @XmlElement(name="UserAccountLockDuration", defaultValue="1")
        protected int userAccountLockDuration;
        @XmlElement(name="MaxFailedLoginAttempts", defaultValue="3")
        protected int maxFailedLoginAttempts;
        @XmlElement(name="EnforceTwoFactors", defaultValue="false")
        protected boolean enforceTwoFactors;

        public int getUserPasswordValidity() {
            return this.userPasswordValidity;
        }

        public void setUserPasswordValidity(int value) {
            this.userPasswordValidity = value;
        }

        public int getUserAccountLockDuration() {
            return this.userAccountLockDuration;
        }

        public void setUserAccountLockDuration(int value) {
            this.userAccountLockDuration = value;
        }

        public int getMaxFailedLoginAttempts() {
            return this.maxFailedLoginAttempts;
        }

        public void setMaxFailedLoginAttempts(int value) {
            this.maxFailedLoginAttempts = value;
        }

        public boolean isEnforceTwoFactors() {
            return this.enforceTwoFactors;
        }

        public void setEnforceTwoFactors(boolean value) {
            this.enforceTwoFactors = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"address", "port", "timeout"})
    public static class AdapterInterface {
        @XmlElement(name="Address", required=true, defaultValue="0.0.0.0")
        protected String address;
        @XmlElement(name="Port", defaultValue="2600")
        protected int port;
        @XmlElement(name="Timeout", defaultValue="60")
        protected int timeout;
        @XmlAttribute(name="enabled")
        protected Boolean enabled;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String value) {
            this.address = value;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int value) {
            this.port = value;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int value) {
            this.timeout = value;
        }

        public boolean isEnabled() {
            if (this.enabled == null) {
                return true;
            }
            return this.enabled;
        }

        public void setEnabled(Boolean value) {
            this.enabled = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"address", "port", "minThreads", "maxThreads", "maxIdleTime", "lowResources", "lowResourcePersistTime", "ssl", "service"})
    public static class Connector {
        @XmlElement(name="Address", required=true)
        protected String address;
        @XmlElement(name="Port")
        protected int port;
        @XmlElement(name="MinThreads")
        protected int minThreads;
        @XmlElement(name="MaxThreads")
        protected int maxThreads;
        @XmlElement(name="MaxIdleTime")
        protected int maxIdleTime;
        @XmlElement(name="LowResources")
        protected int lowResources;
        @XmlElement(name="LowResourcePersistTime")
        protected int lowResourcePersistTime;
        @XmlElement(name="SSL")
        protected SSL ssl;
        @XmlElement(name="Service", required=true)
        protected List<String> service;
        @XmlAttribute(name="id")
        protected String id;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String value) {
            this.address = value;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int value) {
            this.port = value;
        }

        public int getMinThreads() {
            return this.minThreads;
        }

        public void setMinThreads(int value) {
            this.minThreads = value;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public void setMaxThreads(int value) {
            this.maxThreads = value;
        }

        public int getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public void setMaxIdleTime(int value) {
            this.maxIdleTime = value;
        }

        public int getLowResources() {
            return this.lowResources;
        }

        public void setLowResources(int value) {
            this.lowResources = value;
        }

        public int getLowResourcePersistTime() {
            return this.lowResourcePersistTime;
        }

        public void setLowResourcePersistTime(int value) {
            this.lowResourcePersistTime = value;
        }

        public SSL getSSL() {
            return this.ssl;
        }

        public void setSSL(SSL value) {
            this.ssl = value;
        }

        public List<String> getService() {
            if (this.service == null) {
                this.service = new ArrayList<String>();
            }
            return this.service;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String value) {
            this.id = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"keystore", "keystorePassword", "keyPassword", "clientAuthKeystore", "clientAuthKeystorePassword", "clientAuthentication", "excludedProtocols", "excludedCiphers"})
        public static class SSL {
            @XmlElement(name="Keystore", required=true)
            protected String keystore;
            @XmlElement(name="KeystorePassword", required=true)
            protected String keystorePassword;
            @XmlElement(name="KeyPassword", required=true)
            protected String keyPassword;
            @XmlElement(name="ClientAuthKeystore", required=true)
            protected String clientAuthKeystore;
            @XmlElement(name="ClientAuthKeystorePassword", required=true)
            protected String clientAuthKeystorePassword;
            @XmlElement(name="ClientAuthentication", required=true)
            @XmlSchemaType(name="string")
            protected ClientAuthType clientAuthentication;
            @XmlElement(name="ExcludedProtocols")
            protected String excludedProtocols;
            @XmlElement(name="ExcludedCiphers")
            protected String excludedCiphers;

            public String getKeystore() {
                return this.keystore;
            }

            public void setKeystore(String value) {
                this.keystore = value;
            }

            public String getKeystorePassword() {
                return this.keystorePassword;
            }

            public void setKeystorePassword(String value) {
                this.keystorePassword = value;
            }

            public String getKeyPassword() {
                return this.keyPassword;
            }

            public void setKeyPassword(String value) {
                this.keyPassword = value;
            }

            public String getClientAuthKeystore() {
                return this.clientAuthKeystore;
            }

            public void setClientAuthKeystore(String value) {
                this.clientAuthKeystore = value;
            }

            public String getClientAuthKeystorePassword() {
                return this.clientAuthKeystorePassword;
            }

            public void setClientAuthKeystorePassword(String value) {
                this.clientAuthKeystorePassword = value;
            }

            public ClientAuthType getClientAuthentication() {
                return this.clientAuthentication;
            }

            public void setClientAuthentication(ClientAuthType value) {
                this.clientAuthentication = value;
            }

            public String getExcludedProtocols() {
                return this.excludedProtocols;
            }

            public void setExcludedProtocols(String value) {
                this.excludedProtocols = value;
            }

            public String getExcludedCiphers() {
                return this.excludedCiphers;
            }

            public void setExcludedCiphers(String value) {
                this.excludedCiphers = value;
            }
        }
    }
}

