/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket.ftpforwarding;

import de.ponton.securelistener.MimeTypeMapper;
import de.ponton.securelistener.administration.Constants;
import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.ftp.FtpUser;
import de.ponton.securelistener.ftp.filesystem.ListenerFtpFile;
import de.ponton.securelistener.websocket.LimitedOutputStream;
import de.ponton.securelistener.websocket.ResponseSynchronizer;
import de.ponton.securelistener.websocket.SessionPool;
import de.ponton.securelistener.websocket.SessionPoolManager;
import de.ponton.securelistener.websocket.WebSocketOutputStream;
import de.ponton.securelistener.websocket.ftpforwarding.FtpResponse;
import jakarta.inject.Inject;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.impl.FtpIoSession;
import org.eclipse.jetty.http.HttpHeader;

public class FtpToWebsocketAdapter {
    public static final String ORIGINAL_FILENAME_HEADER = "X-Original-Filename";
    private final SessionPool sessionPool;
    private final ListenerProperties listenerConfig;
    private final ResponseSynchronizer synchronizer;

    @Inject
    public FtpToWebsocketAdapter(SessionPoolManager sessionPoolManager, ListenerProperties listenerConfig, ResponseSynchronizer synchronizer) {
        this.sessionPool = sessionPoolManager.getSessionPool("Data");
        this.listenerConfig = listenerConfig;
        this.synchronizer = synchronizer;
    }

    public FtpResponse forwardFtpRequest(DataConnection dataConnection, FtpIoSession session, ListenerFtpFile file) throws TimeoutException, IOException {
        Object postfix;
        boolean sendHeaderWithContent;
        if (!this.sessionPool.hasSessions()) {
            throw new IOException("No Messenger connected");
        }
        String listener = file.getParent().getListener();
        if ("PlainListener".equals(listener)) {
            sendHeaderWithContent = true;
            String receiver = file.getParent().getName();
            FtpUser user = file.getFtpUser();
            postfix = listener + "?cpa=" + receiver + "$" + user.getPartnerLocalId() + "&pass=" + user.getPassword();
        } else {
            sendHeaderWithContent = false;
            postfix = listener;
        }
        String listenerPath = this.listenerConfig.getListenerPath(listener);
        String uri = this.listenerConfig.getForwardPath((String)postfix);
        int timeout = this.listenerConfig.getInternalCommunicationTimeout();
        FtpResponse response = new FtpResponse();
        Session s = this.sessionPool.borrowSession(timeout, TimeUnit.SECONDS);
        this.synchronizer.prepareSession(s, response);
        long transmittedBytes = 0L;
        try {
            String remoteIp = "unknown";
            SocketAddress a = session.getRemoteAddress();
            if (a instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)a;
                remoteIp = address.getAddress().getHostAddress();
            }
            this.sendHeaders(s, listenerPath, uri, session.isSecure(), remoteIp);
            long limit = this.listenerConfig.getForwardMaxDatasize();
            StringBuilder header = new StringBuilder();
            if (sendHeaderWithContent) {
                header.append(ORIGINAL_FILENAME_HEADER);
                header.append(": ");
                header.append(Path.of(file.getName(), new String[0]).getFileName());
                header.append("\r\n");
                header.append(HttpHeader.CONTENT_TYPE);
                header.append(": ");
                header.append(MimeTypeMapper.getMimeType(Path.of(file.getName(), new String[0]).getFileName().toString()));
                header.append("\r\n");
                header.append("\r\n");
            }
            try (LimitedOutputStream outStream = new LimitedOutputStream(new WebSocketOutputStream(s), limit + (long)header.length());){
                if (header.length() > 0) {
                    outStream.write(header.toString().getBytes());
                }
                transmittedBytes = dataConnection.transferFromClient(session.getFtpletSession(), (OutputStream)outStream);
                s.getBasicRemote().sendBinary(ByteBuffer.wrap(Constants.TRANSMISSION_OK), true);
            }
            this.synchronizer.waitForResponse(s);
        }
        catch (IOException e) {
            s.getBasicRemote().sendBinary(ByteBuffer.wrap(Constants.TRANSMISSION_ABORT), true);
            throw e;
        }
        finally {
            this.sessionPool.returnSession(s);
        }
        response.setTransmittedBytes(transmittedBytes);
        return response;
    }

    private void sendHeaders(Session s, String messageReceiver, String requestUrl, boolean secure, String remoteIP) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("POST");
        builder.append("\r\n");
        builder.append(messageReceiver);
        builder.append("\r\n");
        builder.append(requestUrl.toString());
        builder.append("\r\n");
        builder.append("X-inbound-protocol");
        builder.append(": ");
        builder.append(secure ? "FTPS" : "FTP");
        builder.append("\r\n");
        builder.append("X-Forwarded-For");
        builder.append(": ");
        builder.append(remoteIP);
        builder.append("\r\n");
        s.getBasicRemote().sendText(builder.toString());
    }
}

