/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import jakarta.websocket.Session;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebSocketOutputStream
extends OutputStream {
    private static Logger LOG = LogManager.getLogger(WebSocketOutputStream.class);
    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    int count = 0;
    Session session;

    public WebSocketOutputStream(Session session) {
        this.session = session;
    }

    @Override
    public void flush() throws IOException {
        LOG.debug("flushing data");
        if (this.count > 0) {
            byte[] buffer = this.bos.toByteArray();
            LOG.debug("should send {} bytes", (Object)this.count);
            this.write(buffer, 0, buffer.length);
            this.bos.reset();
            this.count = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.bos.write(b);
        ++this.count;
        if (this.count > 8192) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] buff, int off, int len) throws IOException {
        ByteBuffer b = ByteBuffer.wrap(buff, off, len);
        LOG.debug("sending {} bytes", (Object)len);
        this.session.getBasicRemote().sendBinary(b, false);
    }

    @Override
    public void close() throws IOException {
        LOG.debug("stream closed");
    }
}

